/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.complex.SweValuesTest;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class ClientPropertyIdentifierTest {
    private NamespaceSupport namespaces = new NamespaceSupport();
    private FeatureSource obsSource;

    public ClientPropertyIdentifierTest() {
        this.namespaces.declarePrefix("om", "http://www.opengis.net/om/2.0");
        this.namespaces.declarePrefix("swe", "http://www.opengis.net/swe/2.0");
        this.namespaces.declarePrefix("gml", "http://www.opengis.net/gml/3.2");
        this.namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
    }

    @Before
    public void loadDataAccess() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = SweValuesTest.class.getResource("/test-data/sweValuesAsList.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess omsoDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)omsoDataAccess);
        FeatureType observationFeatureType = omsoDataAccess.getSchema(SweValuesTest.OBSERVATION_FEATURE);
        Assert.assertNotNull((Object)observationFeatureType);
        this.obsSource = omsoDataAccess.getFeatureSource(SweValuesTest.OBSERVATION_FEATURE);
        Assert.assertNotNull((Object)this.obsSource);
        FeatureCollection obsFeatures = this.obsSource.getFeatures();
        Assert.assertEquals((long)2L, (long)SweValuesTest.size(obsFeatures));
    }

    @Test
    public void testRetrieveTimeInstantGmlId() throws IOException {
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware(this.namespaces);
        PropertyName gmlIdProperty = ff.property("om:resultTime/gml:TimeInstant/@gml:id");
        try (FeatureIterator featureIt = this.obsSource.getFeatures().features();){
            Feature f = featureIt.next();
            String gmlId = (String)gmlIdProperty.evaluate((Object)f);
            Assert.assertTrue((gmlId != null && !gmlId.trim().isEmpty() ? 1 : 0) != 0);
        }
    }
}

