/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.util;

import java.util.List;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.appschema.util.IndexQueryUtils;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.TestFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class IndexQueryUtilsTest {
    @Test
    public void testCheckAllPropertiesIndexedXpath() {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            Assert.assertTrue((boolean)IndexQueryUtils.checkAllPropertiesIndexed((List)IndexQueryUtils.getAttributesOnFilter((Filter)this.totallyIndexedFilterXpath()), (FeatureTypeMapping)fsource.getMappedSource().getMapping()));
            Assert.assertFalse((boolean)IndexQueryUtils.checkAllPropertiesIndexed((List)IndexQueryUtils.getAttributesOnFilter((Filter)this.partialIndexedFilterXpath()), (FeatureTypeMapping)fsource.getMappedSource().getMapping()));
        }
    }

    @Test
    public void testEqualsXpath() {
        try (TestFeatureSource fsource = new TestFeatureSource("/test-data/index/", "stationsIndexed.xml", "http://www.stations.org/1.0", "stationsIndexed");){
            AttributeMapping attMap = fsource.getMappedSource().getMapping().getAttributeMapping("st:Station/st:name");
            Assert.assertNotNull((Object)attMap);
        }
    }

    private Filter totallyIndexedFilterXpath() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        And filter = ff.and((Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.1")), (Filter)ff.like((Expression)ff.property("st:Station/st:name"), "*fer*"));
        return filter;
    }

    private Filter partialIndexedFilterXpath() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        And filter = ff.and((Filter)ff.equals((Expression)ff.property("st:Station"), (Expression)ff.literal((Object)"st.1")), (Filter)ff.like((Expression)ff.property("st:Station/st:location/st:name"), "*fer*"));
        return filter;
    }
}

