/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter.expression;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.appschema.filter.expression.FormatDateTimezoneFunction;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class FormatDateTimezoneFunctionTest {
    private static final String TIME = "1948-01-01T00:00:00Z";
    private static final String PATTERN = "yyyy-MM-dd";
    private static final String DAY = "1948-01-01";
    private static final String PREVIOUS_DAY = "1947-12-31";
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    private String formatTimezone(String timezone) {
        return (String)ff.function(FormatDateTimezoneFunction.NAME.getFunctionName(), new Expression[]{ff.literal((Object)PATTERN), ff.literal((Object)TIME), ff.literal((Object)timezone)}).evaluate(null);
    }

    @Test
    public void utc() {
        Assert.assertEquals((Object)DAY, (Object)this.formatTimezone("UTC"));
    }

    @Test
    public void canadaMountain() {
        Assert.assertEquals((Object)PREVIOUS_DAY, (Object)this.formatTimezone("Canada/Mountain"));
    }

    @Test
    public void australiaPerth() {
        Assert.assertEquals((Object)DAY, (Object)this.formatTimezone("Australia/Perth"));
    }

    @Test
    public void wrongNumberOfParameters() {
        try {
            ff.function(FormatDateTimezoneFunction.NAME.getFunctionName(), new Expression[]{ff.literal((Object)PATTERN), ff.literal((Object)TIME)}).evaluate(null);
            Assert.fail((String)"Unexpected success");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)(FormatDateTimezoneFunction.NAME.getFunctionName() + ": wrong number of parameters (2 not 3)"), (Object)e.getMessage());
        }
    }

    @Test
    public void invalidDate() {
        try {
            ff.function(FormatDateTimezoneFunction.NAME.getFunctionName(), new Expression[]{ff.literal((Object)PATTERN), ff.literal((Object)"not a valid time"), ff.literal((Object)"UTC")}).evaluate(null);
            Assert.fail((String)"Unexpected success");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)(FormatDateTimezoneFunction.NAME.getFunctionName() + ": could not parse date: not a valid time"), (Object)e.getMessage());
        }
    }

    @Test
    public void nullPattern() {
        Assert.assertNull((Object)ff.function(FormatDateTimezoneFunction.NAME.getFunctionName(), new Expression[]{ff.literal(null), ff.literal((Object)TIME), ff.literal((Object)"UTC")}).evaluate(null));
    }

    @Test
    public void nullDate() {
        Assert.assertNull((Object)ff.function(FormatDateTimezoneFunction.NAME.getFunctionName(), new Expression[]{ff.literal((Object)PATTERN), ff.literal(null), ff.literal((Object)"UTC")}).evaluate(null));
    }

    @Test
    public void nullTimezone() {
        Assert.assertNull((Object)ff.function(FormatDateTimezoneFunction.NAME.getFunctionName(), new Expression[]{ff.literal((Object)PATTERN), ff.literal((Object)TIME), ff.literal(null)}).evaluate(null));
    }
}

