/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.IndexedMappingFeatureIteratorFactory;
import org.geotools.data.complex.MappingAttributeIterator;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.PostFilteringMappingFeatureIterator;
import org.geotools.data.complex.XmlFeatureTypeMapping;
import org.geotools.data.complex.XmlMappingFeatureIterator;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.spi.CustomSourceDataStore;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class MappingFeatureIteratorFactory {
    protected static final Logger LOGGER = Logging.getLogger(MappingFeatureIteratorFactory.class);

    public static IMappingFeatureIterator getInstance(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter) throws IOException {
        return MappingFeatureIteratorFactory.getInstance(store, mapping, query, unrolledFilter, null);
    }

    public static IMappingFeatureIterator getInstance(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter, Transaction transaction) throws IOException {
        return MappingFeatureIteratorFactory.getInstance(store, mapping, query, unrolledFilter, transaction, true);
    }

    public static IMappingFeatureIterator getInstance(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Filter unrolledFilter, Transaction transaction, boolean indexEnable) throws IOException {
        IndexedMappingFeatureIteratorFactory factory;
        if (indexEnable && mapping.getIndexSource() != null && (factory = new IndexedMappingFeatureIteratorFactory(store, mapping, query, unrolledFilter, transaction)).getIndexModeProcessor().isIndexDrivenIteratorCase()) {
            return factory.buildInstance();
        }
        if (mapping instanceof XmlFeatureTypeMapping) {
            return new XmlMappingFeatureIterator(store, mapping, query);
        }
        boolean isJoining = AppSchemaDataAccessConfigurator.isJoining();
        boolean removeQueryLimitIfDenormalised = false;
        FeatureSource<? extends FeatureType, ? extends Feature> mappedSource = mapping.getSource();
        if (isJoining && !(mappedSource instanceof JDBCFeatureSource) && !(mappedSource instanceof JDBCFeatureStore)) {
            if (AppSchemaDataAccessConfigurator.isJoiningSet()) {
                throw new IllegalArgumentException("Joining queries are only supported on JDBC data stores");
            }
            isJoining = false;
        }
        if (isJoining && !(query instanceof JoiningQuery)) {
            boolean hasIdColumn = !Expression.NIL.equals(mapping.getFeatureIdExpression()) && !(mapping.getFeatureIdExpression() instanceof Literal);
            query = new JoiningQuery(query);
            if (hasIdColumn) {
                FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                mapping.getFeatureIdExpression().accept((ExpressionVisitor)extractor, null);
                for (String pn : extractor.getAttributeNameSet()) {
                    ((JoiningQuery)query).addId(pn);
                }
            }
            ((JoiningQuery)query).setRootMapping(mapping);
        }
        IMappingFeatureIterator iterator = null;
        if (unrolledFilter != null) {
            query.setFilter((Filter)Filter.INCLUDE);
            Query unrolledQuery = store.unrollQuery(query, mapping);
            unrolledQuery.setFilter(unrolledFilter);
            if (query instanceof JoiningQuery && unrolledQuery instanceof JoiningQuery) {
                ((JoiningQuery)unrolledQuery).setRootMapping(((JoiningQuery)query).getRootMapping());
            }
            iterator = MappingFeatureIteratorFactory.isSimpleType(mapping) ? new MappingAttributeIterator(store, mapping, query, unrolledQuery, transaction) : new DataAccessMappingFeatureIterator(store, mapping, query, unrolledQuery, false, transaction);
        } else {
            List<AttributeMapping> listMappings = mapping.getIsListMappings();
            Filter isListFilter = null;
            if (!listMappings.isEmpty()) {
                IsListFilterVisitor listChecker = new IsListFilterVisitor(listMappings, mapping);
                Filter complexFilter = query.getFilter();
                complexFilter.accept((FilterVisitor)listChecker, null);
                if (listChecker.isListFilterExists()) {
                    isListFilter = AppSchemaDataAccess.unrollFilter(complexFilter, mapping);
                }
            }
            if (isJoining || mappedSource instanceof JDBCFeatureSource || mappedSource instanceof JDBCFeatureStore) {
                FilterCapabilities capabilities = MappingFeatureIteratorFactory.getFilterCapabilities(mappedSource);
                ComplexFilterSplitter splitter = new ComplexFilterSplitter(capabilities, mapping);
                Filter filter = query.getFilter();
                filter.accept((FilterVisitor)splitter, null);
                Filter preFilter = splitter.getFilterPre();
                query.setFilter(preFilter);
                filter = splitter.getFilterPost();
                if (isJoining) {
                    ((JoiningQuery)query).setDenormalised(mapping.isDenormalised());
                }
                if (isJoining && isListFilter != null) {
                    ((JoiningQuery)query).setSubset(true);
                    if (filter == null || filter.equals(Filter.INCLUDE)) {
                        isListFilter = null;
                    }
                }
                boolean isFiltered = !isJoining && preFilter != null && preFilter != Filter.INCLUDE;
                boolean hasPostFilter = false;
                if (isListFilter == null && filter != null && filter != Filter.INCLUDE) {
                    hasPostFilter = true;
                }
                int offset = 0;
                int maxFeatures = 1000000;
                if (hasPostFilter) {
                    offset = query.getStartIndex() == null ? 0 : query.getStartIndex();
                    query.setStartIndex(null);
                    maxFeatures = query.getMaxFeatures();
                    removeQueryLimitIfDenormalised = true;
                }
                iterator = new DataAccessMappingFeatureIterator(store, mapping, query, isFiltered, removeQueryLimitIfDenormalised, hasPostFilter, transaction);
                if (isListFilter != null) {
                    ((DataAccessMappingFeatureIterator)iterator).setListFilter(isListFilter);
                }
                if (hasPostFilter) {
                    iterator = new PostFilteringMappingFeatureIterator(iterator, filter, maxFeatures, offset);
                }
            } else if (mappedSource instanceof MappingFeatureSource) {
                iterator = new DataAccessMappingFeatureIterator(store, mapping, query);
                if (isListFilter != null) {
                    ((DataAccessMappingFeatureIterator)iterator).setListFilter(isListFilter);
                }
            } else {
                Filter filter = query.getFilter();
                for (CustomSourceDataStore customSourceDataStore : CustomSourceDataStore.loadExtensions()) {
                    iterator = customSourceDataStore.buildIterator(store, mapping, query, transaction);
                }
                if (iterator == null) {
                    iterator = new DataAccessMappingFeatureIterator(store, mapping, query, !Filter.INCLUDE.equals(filter), true);
                }
                if (isListFilter != null) {
                    ((DataAccessMappingFeatureIterator)iterator).setListFilter(isListFilter);
                }
            }
        }
        return iterator;
    }

    private static boolean isSimpleType(FeatureTypeMapping mapping) {
        return Types.isSimpleContentType((PropertyType)mapping.getTargetFeature().getType());
    }

    private static FilterCapabilities getFilterCapabilities(FeatureSource mappedSource) throws IllegalArgumentException {
        FilterCapabilities capabilities = null;
        if (mappedSource instanceof JDBCFeatureSource) {
            capabilities = ((JDBCFeatureSource)mappedSource).getDataStore().getFilterCapabilities();
        } else if (mappedSource instanceof JDBCFeatureStore) {
            capabilities = ((JDBCFeatureStore)mappedSource).getDataStore().getFilterCapabilities();
        } else {
            throw new IllegalArgumentException("Joining queries are only supported on JDBC data stores");
        }
        return capabilities;
    }

    static class IsListFilterVisitor
    extends DefaultFilterVisitor {
        private List<AttributeMapping> listMappings;
        private boolean isListFilter;
        private FeatureTypeMapping mappings;

        public IsListFilterVisitor(List<AttributeMapping> listMappings, FeatureTypeMapping mappings) {
            this.listMappings = listMappings;
            this.mappings = mappings;
            this.isListFilter = false;
        }

        public Object visit(PropertyName expression, Object extraData) {
            AttributeDescriptor root = this.mappings.getTargetFeature();
            String attPath = expression.getPropertyName();
            NamespaceSupport namespaces = this.mappings.getNamespaces();
            XPathUtil.StepList simplifiedSteps = XPath.steps((AttributeDescriptor)root, (String)attPath, (NamespaceSupport)namespaces);
            for (AttributeMapping mapping : this.listMappings) {
                XPathUtil.StepList targetXpath = mapping.getTargetXPath();
                if (!targetXpath.equals((Object)simplifiedSteps)) continue;
                this.isListFilter = true;
                return extraData;
            }
            return extraData;
        }

        public boolean isListFilterExists() {
            return this.isListFilter;
        }
    }
}

