/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.Iterator;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.data.complex.util.XPathUtil;

public class MappingAttributeIterator
extends DataAccessMappingFeatureIterator {
    private Name elementName;

    public MappingAttributeIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery) throws IOException {
        this(store, mapping, query, unrolledQuery, null);
    }

    public MappingAttributeIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery, Transaction transaction) throws IOException {
        super(store, mapping, query, unrolledQuery, false, transaction);
        this.elementName = mapping.getTargetFeature().getName();
        this.checkAttributeMappings();
    }

    private void checkAttributeMappings() {
        Iterator<AttributeMapping> mappings = this.mapping.getAttributeMappings().iterator();
        AttributeMapping rootMapping = null;
        while (mappings.hasNext()) {
            AttributeMapping att = mappings.next();
            XPathUtil.StepList xpath = att.getTargetXPath();
            if (XPath.equals((Name)this.elementName, (XPathUtil.StepList)xpath)) {
                if (rootMapping != null) {
                    throw new RuntimeException("Duplicate AttributeMapping for: '" + this.elementName + "' is found in FeatureTypeMapping '" + this.elementName + "'!");
                }
                rootMapping = att;
                continue;
            }
            if (XPath.equals((Name)ComplexFeatureConstants.FEATURE_CHAINING_LINK_NAME, (XPathUtil.StepList)xpath)) continue;
            String msg = "AttributeMapping for: '" + xpath + "' found in FeatureTypeMapping '" + this.elementName + "' ! This will be ignored as it doesn't belong to the type.";
            LOGGER.warning(msg);
        }
        if (rootMapping == null) {
            throw new RuntimeException("AttributeMapping for: '" + this.elementName + "' is missing in FeatureTypeMapping '" + this.elementName + "'!");
        }
    }
}

