/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.jdbc;

import java.io.IOException;
import java.io.Writer;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.JdbcMultipleValue;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;

public final class JdbcMultipleValueEncoder
extends DuplicatingFilterVisitor {
    private final JDBCDataStore store;
    private final Writer output;

    public JdbcMultipleValueEncoder(FeatureTypeMapping typeMapping, Writer output) {
        this.store = (JDBCDataStore)typeMapping.getSource().getDataStore();
        this.output = output;
    }

    protected Expression visit(Expression expression, Object extraData) {
        if (!(expression instanceof JdbcMultipleValue)) {
            return super.visit(expression, extraData);
        }
        JdbcMultipleValue multipleValue = (JdbcMultipleValue)expression;
        FilterToSQL filterToSql = this.createFilterToSQL(multipleValue);
        filterToSql.setFieldEncoder(field -> {
            StringBuffer sql = new StringBuffer();
            this.store.dialect.encodeTableName(multipleValue.getId(), sql);
            sql.append(".");
            sql.append(field);
            return sql.toString();
        });
        try {
            return new MultipleValueExpressionHolder(this.output, filterToSql.encodeToString(((JdbcMultipleValue)expression).getTargetValue()));
        }
        catch (FilterToSQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    private FilterToSQL createFilterToSQL(JdbcMultipleValue multipleValue) {
        SimpleFeatureType ft;
        try {
            ft = this.store.getSchema(multipleValue.getTargetTable());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.store.getSQLDialect() instanceof PreparedStatementSQLDialect) {
            PreparedFilterToSQL preparedFilterToSQL = this.store.createPreparedFilterToSQL(ft);
            preparedFilterToSQL.setPrepareEnabled(false);
            return preparedFilterToSQL;
        }
        return this.store.createFilterToSQL(ft);
    }

    private static final class MultipleValueExpressionHolder
    implements Expression {
        private final Writer output;
        private final String expression;

        private MultipleValueExpressionHolder(Writer output, String expression) {
            this.output = output;
            this.expression = expression;
        }

        public Object evaluate(Object object) {
            throw new UnsupportedOperationException();
        }

        public <T> T evaluate(Object object, Class<T> context) {
            throw new UnsupportedOperationException();
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            if (visitor instanceof FilterToSQL) {
                try {
                    this.output.write(this.expression);
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("Error writing multiple value expression '%s' to output.", this.expression), exception);
                }
            }
            return null;
        }
    }
}

