/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.math.BigInteger;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class Gsml30MappedFeatureTest
extends AppSchemaTestSupport {
    private static final String TEST_DATA = "/test-data/gsml30/";
    private static final String GSML = "urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0";
    private static final Name MAPPED_FEATURE = new NameImpl("urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0", "MappedFeature");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void features() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dbtype", "app-schema");
        URL url = this.getClass().getResource("/test-data/gsml30/Gsml30MappedFeature.xml");
        Assert.assertNotNull((Object)url);
        params.put("url", url.toExternalForm());
        DataAccess dataAccess = null;
        try {
            dataAccess = DataAccessFinder.getDataStore(params);
            Assert.assertNotNull((Object)dataAccess);
            FeatureType mappedFeatureType = dataAccess.getSchema(MAPPED_FEATURE);
            Assert.assertNotNull((Object)mappedFeatureType);
            FeatureSource source = dataAccess.getFeatureSource(MAPPED_FEATURE);
            FeatureCollection features = source.getFeatures();
            LinkedHashMap<String, Feature> featureMap = new LinkedHashMap<String, Feature>();
            try (FeatureIterator iterator = features.features();){
                while (iterator.hasNext()) {
                    Feature f = iterator.next();
                    featureMap.put(f.getIdentifier().getID(), f);
                }
            }
            Assert.assertEquals((long)2L, (long)featureMap.size());
            Assert.assertEquals((Object)"First", (Object)((ComplexAttribute)((Feature)featureMap.get("mf.1")).getProperty((Name)new NameImpl("http://www.opengis.net/gml/3.2", "name"))).getProperty((Name)new NameImpl("simpleContent")).getValue());
            Assert.assertEquals((Object)"Second", (Object)((ComplexAttribute)((Feature)featureMap.get("mf.2")).getProperty((Name)new NameImpl("http://www.opengis.net/gml/3.2", "name"))).getProperty((Name)new NameImpl("simpleContent")).getValue());
            for (int i = 1; i <= 2; ++i) {
                Assert.assertEquals((Object)BigInteger.valueOf(250000L), (Object)((Attribute)((ComplexAttribute)((ComplexAttribute)((ComplexAttribute)((Feature)featureMap.get("mf." + i)).getProperty((Name)new NameImpl(GSML, "resolutionScale"))).getProperty((Name)new NameImpl("http://www.isotc211.org/2005/gmd", "MD_RepresentativeFraction"))).getProperty((Name)new NameImpl("http://www.isotc211.org/2005/gmd", "denominator"))).getProperty((Name)new NameImpl("http://www.isotc211.org/2005/gco", "Integer"))).getValue());
            }
        }
        finally {
            if (dataAccess != null) {
                dataAccess.dispose();
            }
        }
    }
}

