/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.data.DataAccess;
import org.geotools.data.complex.AppSchemaDataAccessFactory;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.util.FeatureStreams;
import org.geotools.feature.FeatureCollection;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class FeatureTypeMappingIndexTest
extends AppSchemaTestSupport {
    private static final String schemaBase = "/test-data/index/";
    private static final String NSURI = "http://www.stations.org/1.0";
    static final Name mappedTypeName = Types.typeName(null, (String)"stationsIndexed");
    private AppSchemaDataAccessFactory factory;
    private Map params;
    DataAccess<FeatureType, Feature> dataStore;
    MappingFeatureSource mappedSource;

    @Before
    public void setUp() throws Exception {
        this.factory = new AppSchemaDataAccessFactory();
        this.params = new HashMap();
        this.params.put("dbtype", "app-schema");
        URL resource = this.getClass().getResource("/test-data/index/stationsIndexed.xml");
        if (resource == null) {
            Assert.fail((String)"Can't find resouce /test-data/index/stationsIndexed.xml");
        }
        this.params.put("url", resource);
        this.dataStore = this.factory.createDataStore(this.params);
        this.mappedSource = (MappingFeatureSource)this.dataStore.getFeatureSource(mappedTypeName);
    }

    @After
    public void tearDown() throws Exception {
        this.dataStore.dispose();
        this.factory = null;
        this.params = null;
    }

    @Test
    public void testIndexesNames() throws Exception {
        List atts = this.mappedSource.getMapping().getAttributeMappings();
        Assert.assertTrue((boolean)atts.stream().anyMatch(att -> "ID".equals(att.getIndexField())));
        Assert.assertTrue((boolean)atts.stream().anyMatch(att -> "NAME".equals(att.getIndexField())));
    }

    @Test
    public void testIndexesSources() throws Exception {
        try (Stream fstream = FeatureStreams.toFeatureStream((FeatureCollection)this.mappedSource.getMapping().getIndexSource().getFeatures());){
            Assert.assertTrue((boolean)fstream.anyMatch(f -> f.getIdentifier().getID().equals("st.1")));
        }
    }

    @Test
    public void testSourcesFeatures() throws Exception {
        try (Stream fstream = FeatureStreams.toFeatureStream((FeatureCollection)this.mappedSource.getFeatures());){
            List flist = fstream.collect(Collectors.toList());
            Assert.assertTrue((flist.size() == 11 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Feature)flist.get(2)).getIdentifier().getID().equals("st.3"));
        }
    }
}

