/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.xml.sax.helpers.NamespaceSupport;

public class DefaultGeometryTest {
    static final String STATIONS_SCHEMA_BASE = "/test-data/stations/";
    static final String STATIONS_NS = "http://www.stations.org/1.0";
    static final Name STATION_FEATURE_TYPE = Types.typeName((String)"http://www.stations.org/1.0", (String)"StationType");
    static final Name STATION_FEATURE = Types.typeName((String)"http://www.stations.org/1.0", (String)"Station");
    static final Name STATION_NO_DEFAULT_GEOM_MAPPING = Types.typeName((String)"stationsNoDefaultGeometry");
    static final Name STATION_MULTIPLE_GEOM_MAPPING = Types.typeName((String)"stationsMultipleGeometries");
    static final Name STATION_WITH_MEASUREMENTS_FEATURE_TYPE = Types.typeName((String)"http://www.stations.org/1.0", (String)"StationWithMeasurementsType");
    static final Name STATION_WITH_MEASUREMENTS_FEATURE = Types.typeName((String)"http://www.stations.org/1.0", (String)"StationWithMeasurements");
    static final Name STATION_WITH_GEOM_FEATURE_TYPE = Types.typeName((String)"http://www.stations.org/1.0", (String)"StationWithGeometryPropertyType");
    static final Name STATION_WITH_GEOM_FEATURE = Types.typeName((String)"http://www.stations.org/1.0", (String)"StationWithGeometryProperty");
    static final Name STATION_DEFAULT_GEOM_OVERRIDE_MAPPING = Types.typeName((String)"stationsDefaultGeometryOverride");
    static final String MEASUREMENTS_NS = "http://www.measurements.org/1.0";
    static final Name MEASUREMENT_FEATURE_TYPE = Types.typeName((String)"http://www.measurements.org/1.0", (String)"MeasurementType");
    static final Name MEASUREMENT_FEATURE = Types.typeName((String)"http://www.measurements.org/1.0", (String)"Measurement");
    static final Name MEASUREMENT_MANY_TO_ONE_MAPPING = Types.typeName((String)"measurementsManyToOne");
    private static FilterFactory2 ff;
    private WKTWriter writer = new WKTWriter();
    private NamespaceSupport namespaces = new NamespaceSupport();
    private static AppSchemaDataAccess stationsDataAccess;
    private static AppSchemaDataAccess measurementsDataAccess;

    public DefaultGeometryTest() {
        this.namespaces.declarePrefix("st", STATIONS_NS);
        this.namespaces.declarePrefix("ms", MEASUREMENTS_NS);
        ff = new FilterFactoryImplNamespaceAware(this.namespaces);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DefaultGeometryTest.loadDataAccesses();
    }

    private static void loadDataAccesses() throws Exception {
        measurementsDataAccess = DefaultGeometryTest.loadDataAccess("measurementsDefaultGeometry.xml");
        stationsDataAccess = DefaultGeometryTest.loadDataAccess("stationsDefaultGeometry.xml");
        FeatureType ft = stationsDataAccess.getSchema(STATION_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)STATION_FEATURE_TYPE, (Object)ft.getName());
        Assert.assertNotNull((Object)stationsDataAccess.getSchema(STATION_NO_DEFAULT_GEOM_MAPPING));
        Assert.assertNotNull((Object)stationsDataAccess.getSchema(STATION_MULTIPLE_GEOM_MAPPING));
        ft = stationsDataAccess.getSchema(STATION_WITH_MEASUREMENTS_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)STATION_WITH_MEASUREMENTS_FEATURE_TYPE, (Object)ft.getName());
        ft = stationsDataAccess.getSchema(STATION_WITH_GEOM_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)STATION_WITH_GEOM_FEATURE_TYPE, (Object)ft.getName());
        Assert.assertNotNull((Object)stationsDataAccess.getSchema(STATION_DEFAULT_GEOM_OVERRIDE_MAPPING));
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_FEATURE);
        FeatureCollection stationFeatures = fs.getFeatures();
        Assert.assertEquals((long)3L, (long)DefaultGeometryTest.size((FeatureCollection<FeatureType, Feature>)stationFeatures));
        ft = measurementsDataAccess.getSchema(MEASUREMENT_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)MEASUREMENT_FEATURE_TYPE, (Object)ft.getName());
        Assert.assertNotNull((Object)measurementsDataAccess.getSchema(MEASUREMENT_MANY_TO_ONE_MAPPING));
    }

    private static AppSchemaDataAccess loadDataAccess(String mappingFile) throws IOException {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = DefaultGeometryTest.class.getResource(STATIONS_SCHEMA_BASE + mappingFile);
        Assert.assertNotNull((Object)url);
        DataAccess dataAccess = null;
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        Assert.assertTrue((boolean)(dataAccess instanceof AppSchemaDataAccess));
        return (AppSchemaDataAccess)dataAccess;
    }

    private static int size(FeatureCollection<FeatureType, Feature> features) {
        int size = 0;
        FeatureIterator iterator = features.features();
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        iterator.close();
        return size;
    }

    @Test
    public void testDefaultGeometryMappingConfiguration() throws IOException {
        FeatureType ftWithDefaultGeom = stationsDataAccess.getSchema(STATION_FEATURE);
        Assert.assertNotNull((Object)ftWithDefaultGeom.getGeometryDescriptor());
        Assert.assertEquals((Object)"__DEFAULT_GEOMETRY__", (Object)ftWithDefaultGeom.getGeometryDescriptor().getLocalName());
        FeatureTypeMapping mappingDefaultGeom = stationsDataAccess.getMappingByName(STATION_FEATURE);
        Assert.assertNotNull((Object)mappingDefaultGeom);
        Assert.assertNotNull((Object)mappingDefaultGeom.getDefaultGeometryXPath());
        Assert.assertEquals((Object)"st:location/st:position", (Object)mappingDefaultGeom.getDefaultGeometryXPath());
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_FEATURE);
        Id filter = ff.id(new FeatureId[]{ff.featureId("st.1")});
        FeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)DefaultGeometryTest.size((FeatureCollection<FeatureType, Feature>)fc));
        try (FeatureIterator it = fc.features();){
            Feature station1 = it.next();
            Assert.assertEquals((Object)"st.1", (Object)station1.getIdentifier().toString());
            GeometryAttribute defaultGeom = station1.getDefaultGeometryProperty();
            Assert.assertNotNull((Object)defaultGeom);
            Assert.assertNotNull((Object)defaultGeom.getValue());
            Assert.assertTrue((boolean)(defaultGeom.getValue() instanceof Point));
            Point point = (Point)defaultGeom.getValue();
            Assert.assertEquals((Object)"POINT (-1 1)", (Object)this.writer.write((Geometry)point));
        }
    }

    @Test
    public void testDefaultGeometryNone() throws IOException {
        FeatureTypeMapping mappingNoDefaultGeom = stationsDataAccess.getMappingByNameOrElement(STATION_NO_DEFAULT_GEOM_MAPPING);
        Assert.assertNotNull((Object)mappingNoDefaultGeom);
        Assert.assertNull((Object)mappingNoDefaultGeom.getDefaultGeometryXPath());
        FeatureType ftNoDefaultGeom = stationsDataAccess.getSchema(STATION_NO_DEFAULT_GEOM_MAPPING);
        Assert.assertNull((Object)ftNoDefaultGeom.getGeometryDescriptor());
    }

    @Test
    public void testDefaultGeometryOverride() throws IOException {
        FeatureTypeMapping mappingWithGeom = stationsDataAccess.getMappingByName(STATION_WITH_GEOM_FEATURE);
        Assert.assertNotNull((Object)mappingWithGeom);
        Assert.assertNull((Object)mappingWithGeom.getDefaultGeometryXPath());
        FeatureType ftWithGeom = stationsDataAccess.getSchema(STATION_WITH_GEOM_FEATURE);
        Assert.assertNotNull((Object)ftWithGeom.getGeometryDescriptor());
        Assert.assertEquals((Object)Types.typeName((String)STATIONS_NS, (String)"geometry"), (Object)ftWithGeom.getGeometryDescriptor().getName());
        FeatureTypeMapping mappingDefaultGeomOverride = stationsDataAccess.getMappingByName(STATION_DEFAULT_GEOM_OVERRIDE_MAPPING);
        Assert.assertEquals((Object)mappingWithGeom.getTargetFeature().getName(), (Object)mappingDefaultGeomOverride.getTargetFeature().getName());
        Assert.assertNotNull((Object)mappingDefaultGeomOverride);
        Assert.assertEquals((Object)"st:location/st:position", (Object)mappingDefaultGeomOverride.getDefaultGeometryXPath());
        FeatureType ftDefaultGeomOverride = stationsDataAccess.getSchema(STATION_DEFAULT_GEOM_OVERRIDE_MAPPING);
        Assert.assertEquals((Object)ftWithGeom.getName(), (Object)ftDefaultGeomOverride.getName());
        Assert.assertNotNull((Object)ftDefaultGeomOverride.getGeometryDescriptor());
        Assert.assertEquals((Object)"__DEFAULT_GEOMETRY__", (Object)ftDefaultGeomOverride.getGeometryDescriptor().getLocalName());
    }

    @Test
    public void testDefaultGeometryInsideChainedFeatureType() throws IOException {
        FeatureTypeMapping mappingChained = stationsDataAccess.getMappingByName(STATION_WITH_MEASUREMENTS_FEATURE);
        Assert.assertNotNull((Object)mappingChained);
        Assert.assertEquals((Object)"st:measurements/ms:Measurement/ms:sampledArea/ms:SampledArea/ms:geometry", (Object)mappingChained.getDefaultGeometryXPath());
        FeatureType ftChained = stationsDataAccess.getSchema(STATION_WITH_MEASUREMENTS_FEATURE);
        Assert.assertNotNull((Object)ftChained.getGeometryDescriptor());
        Assert.assertEquals((Object)"__DEFAULT_GEOMETRY__", (Object)ftChained.getGeometryDescriptor().getLocalName());
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_WITH_MEASUREMENTS_FEATURE);
        Id filter = ff.id(new FeatureId[]{ff.featureId("st.1")});
        FeatureCollection fc = fs.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)DefaultGeometryTest.size((FeatureCollection<FeatureType, Feature>)fc));
        try (FeatureIterator it = fc.features();){
            Feature station1 = it.next();
            Assert.assertEquals((Object)"st.1", (Object)station1.getIdentifier().toString());
            GeometryAttribute defaultGeom = station1.getDefaultGeometryProperty();
            Assert.assertNotNull((Object)defaultGeom);
            Assert.assertNotNull((Object)defaultGeom.getValue());
            Assert.assertTrue((boolean)(defaultGeom.getValue() instanceof Polygon));
            Polygon poly = (Polygon)defaultGeom.getValue();
            Assert.assertEquals((Object)"POLYGON ((-2 2, 0 2, 0 -2, -2 -2, -2 2))", (Object)this.writer.write((Geometry)poly));
        }
    }

    @Test
    public void testDefaultGeometryWrongType() {
        try {
            DefaultGeometryTest.loadDataAccess("stationsDefaultGeometryWrongType.xml");
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
            IllegalArgumentException iae = (IllegalArgumentException)ex.getCause();
            Assert.assertEquals((Object)"Default geometry descriptor could not be found for type \"http://www.stations.org/1.0:Station\" at x-path \"st:location/st:name\"", (Object)iae.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Expected IllegalArgumentException to be thrown, but " + e.getClass().getName() + " was thrown instead"));
        }
    }

    @Test
    public void testDefaultGeometryNonExistentProperty() {
        try {
            DefaultGeometryTest.loadDataAccess("stationsDefaultGeometryNonExistentProperty.xml");
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
            IllegalArgumentException iae = (IllegalArgumentException)ex.getCause();
            Assert.assertEquals((Object)"Default geometry descriptor could not be found for type \"http://www.stations.org/1.0:Station\" at x-path \"st:location/st:notThere\"", (Object)iae.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Expected IllegalArgumentException to be thrown, but " + e.getClass().getName() + " was thrown instead"));
        }
    }

    @Test
    public void testDefaultGeometryMultipleValues() throws IOException {
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_MULTIPLE_GEOM_MAPPING);
        FeatureCollection fc = fs.getFeatures();
        try (FeatureIterator it = fc.features();){
            try {
                it.next();
            }
            catch (Exception ex) {
                Assert.assertNotNull((Object)ex.getCause());
                Assert.assertTrue((String)"Expected RuntimeException to be thrown", (boolean)(ex.getCause() instanceof RuntimeException));
                RuntimeException re = (RuntimeException)ex.getCause();
                Assert.assertEquals((Object)"Error setting default geometry value: multiple values were found", (Object)re.getMessage());
            }
        }
    }
}

