/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessFactory;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.type.Name;

public class AppSchemaDataAccessFactoryTest
extends AppSchemaTestSupport {
    AppSchemaDataAccessFactory factory;
    Map params;
    private static final String NSURI = "http://online.socialchange.net.au";
    static final Name mappedTypeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"RoadSegment");

    @Before
    public void setUp() throws Exception {
        this.factory = new AppSchemaDataAccessFactory();
        this.params = new HashMap();
        this.params.put("dbtype", "app-schema");
        URL resource = this.getClass().getResource("/test-data/roadsegments.xml");
        if (resource == null) {
            Assert.fail((String)"Can't find resouce /test-data/roadsegments.xml");
        }
        this.params.put("url", resource);
    }

    @After
    public void tearDown() throws Exception {
        this.factory = null;
        this.params = null;
    }

    @Test
    public void testCreateDataStorePreconditions() {
        HashMap<String, String> badParams = new HashMap<String, String>();
        try {
            this.factory.createDataStore(badParams);
            Assert.fail((String)"allowed bad params");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        badParams.put("dbtype", "app-schema");
        try {
            this.factory.createDataStore(badParams);
            Assert.fail((String)"allowed bad params");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        badParams.put("url", "file://_inexistentConfigFile123456.xml");
        try {
            this.factory.createDataStore(badParams);
            Assert.fail((String)"allowed bad params");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDataStore() throws IOException {
        DataAccess ds = this.factory.createDataStore(this.params);
        Assert.assertNotNull((Object)ds);
        FeatureSource mappedSource = ds.getFeatureSource(mappedTypeName);
        Assert.assertNotNull((Object)mappedSource);
        Assert.assertSame((Object)ds, (Object)mappedSource.getDataStore());
        ds.dispose();
    }

    @Test
    public void testFactoryLookup() throws IOException {
        DataAccess ds = DataAccessFinder.getDataStore((Map)this.params);
        Assert.assertNotNull((Object)ds);
        Assert.assertTrue((boolean)(ds instanceof AppSchemaDataAccess));
        FeatureSource mappedSource = ds.getFeatureSource(mappedTypeName);
        Assert.assertNotNull((Object)mappedSource);
        ds.dispose();
    }

    @Test
    public void testCreateNewDataStore() throws IOException {
        try {
            this.factory.createNewDataStore(Collections.EMPTY_MAP);
            Assert.fail((String)"unsupported?");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetParametersInfo() {
        DataAccessFactory.Param[] params = this.factory.getParametersInfo();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)2L, (long)params.length);
        Assert.assertEquals(String.class, (Object)params[0].type);
        Assert.assertEquals(URL.class, (Object)params[1].type);
    }

    @Test
    public void testCanProcess() {
        HashMap<String, String> params = new HashMap<String, String>();
        Assert.assertFalse((boolean)this.factory.canProcess(params));
        params.put("dbtype", "arcsde");
        params.put("url", "http://somesite.net/config.xml");
        Assert.assertFalse((boolean)this.factory.canProcess(params));
        params.remove("url");
        params.put("dbtype", "app-schema");
        Assert.assertFalse((boolean)this.factory.canProcess(params));
        params.put("url", "http://somesite.net/config.xml");
        Assert.assertTrue((boolean)this.factory.canProcess(params));
    }

    @Test
    public void testIsAvailable() {
        Assert.assertTrue((boolean)this.factory.isAvailable());
    }

    @Test
    public void testGetImplementationHints() {
        Assert.assertNotNull((Object)this.factory.getImplementationHints());
        Assert.assertEquals((long)0L, (long)this.factory.getImplementationHints().size());
    }

    public static class AppSchemaDataAccessFactoryFailureTest
    extends AppSchemaTestSupport {
        private AppSchemaDataAccessFactory factory;
        private Map params;

        @Test
        public void testUnregisterOnFailure() throws Exception {
            this.factory = new AppSchemaDataAccessFactory();
            this.params = new HashMap();
            this.params.put("dbtype", "app-schema");
            URL resource = this.getClass().getResource("/test-data/creation_failure/roadsegments_bad.xml");
            if (resource == null) {
                Assert.fail((String)"Can't find resouce /test-data/creation_failure/roadsegments_bad.xml");
            }
            this.params.put("url", resource);
            boolean exceptionCatched = false;
            try {
                DataAccess ds = this.factory.createDataStore(this.params);
                Assert.assertNotNull((Object)ds);
                FeatureSource mappedSource = ds.getFeatureSource(mappedTypeName);
                Assert.assertNull((Object)mappedSource);
            }
            catch (Exception ex) {
                exceptionCatched = true;
            }
            Assert.assertTrue((boolean)exceptionCatched);
            Assert.assertFalse((boolean)DataAccessRegistry.hasName((Name)mappedTypeName));
        }

        @After
        public void tearDown() throws Exception {
            this.factory = null;
            this.params = null;
        }
    }
}

