/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.xml.sax.helpers.NamespaceSupport;

public class BBoxTest
extends AppSchemaTestSupport {
    private static FilterFactoryImpl ff;
    private static DataAccess<FeatureType, Feature> dataAccess;
    private static FeatureSource<FeatureType, Feature> fSource;

    @BeforeClass
    public static void onetimeSetUp() throws Exception {
        String GSML_URI = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        ff = new FilterFactoryImplNamespaceAware(namespaces);
        Name FEATURE_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
        String schemaBase = "/test-data/";
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = BBoxTest.class.getResource("/test-data/MappedFeatureAsOccurrence.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        dataAccess = DataAccessFinder.getDataStore(dsParams);
        fSource = dataAccess.getFeatureSource(FEATURE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBBoxWithPropertyName() throws Exception {
        BBOX filter = ff.bbox((Expression)ff.property("gsml:shape"), -1.1, 52.5, -1.1, 52.6, null);
        FeatureCollection features = fSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)2L, (long)this.size((FeatureCollection<FeatureType, Feature>)features));
        try (FeatureIterator iterator = features.features();){
            Feature f = iterator.next();
            Assert.assertEquals((Object)"mf1", (Object)f.getIdentifier().toString());
            f = iterator.next();
            Assert.assertEquals((Object)"mf3", (Object)f.getIdentifier().toString());
        }
        filter = ff.bbox((Expression)ff.property("gml:name[1]"), -1.2, 52.5, -1.1, 52.6, null);
        features = fSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)0L, (long)this.size((FeatureCollection<FeatureType, Feature>)features));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBBoxWithNoPropertyName() throws IOException {
        BBOX filter = ff.bbox((Expression)ff.property(""), -1.1, 52.5, -1.1, 52.6, null);
        FeatureCollection features = fSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)2L, (long)this.size((FeatureCollection<FeatureType, Feature>)features));
        try (FeatureIterator iterator = features.features();){
            Feature f = iterator.next();
            Assert.assertEquals((Object)f.getIdentifier().toString(), (Object)"mf1");
            f = iterator.next();
            Assert.assertEquals((Object)f.getIdentifier().toString(), (Object)"mf3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(FeatureCollection<FeatureType, Feature> features) {
        int size = 0;
        try (FeatureIterator i = features.features();){
            while (i.hasNext()) {
                ++size;
                i.next();
            }
        }
        return size;
    }
}

