/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.wfs20.ResolveValueType;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureCollection;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

public class NestedAttributeMapping
extends AttributeMapping {
    private static final Logger LOGGER = Logging.getLogger(NestedAttributeMapping.class);
    private FeatureSource<? extends FeatureType, ? extends Feature> source;
    private FeatureSource<? extends FeatureType, ? extends Feature> mappingSource;
    protected final Expression nestedFeatureType;
    protected final XPathUtil.StepList nestedTargetXPath;
    private Expression nestedSourceExpression;
    protected FilterFactory filterFac;
    private NamespaceSupport namespaces;
    private Expression nestedIdExpression;
    private boolean isConditional;

    public NestedAttributeMapping(Expression idExpression, Expression parentExpression, XPathUtil.StepList targetXPath, boolean isMultiValued, Map<Name, Expression> clientProperties, Expression sourceElement, XPathUtil.StepList sourcePath, NamespaceSupport namespaces) throws IOException {
        super(idExpression, parentExpression, null, targetXPath, null, isMultiValued, clientProperties);
        this.nestedTargetXPath = sourcePath;
        this.nestedFeatureType = sourceElement;
        this.filterFac = new FilterFactoryImplNamespaceAware(namespaces);
        this.namespaces = namespaces;
        this.isConditional = this.nestedFeatureType instanceof Function;
    }

    @Override
    public boolean isNestedAttribute() {
        return true;
    }

    public List<Feature> getInputFeatures(Object caller, Object foreignKeyValue, List<Object> idValues, Object feature, CoordinateReferenceSystem reprojection, List<PropertyName> selectedProperties, boolean includeMandatory) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        boolean isMultiple = false;
        if (this.source == null || this.isConditional) {
            Object featureTypeName = this.getNestedFeatureType(feature);
            if (featureTypeName == null || !(featureTypeName instanceof Name)) {
                return Collections.emptyList();
            }
            FeatureTypeMapping featureTypeMapping = AppSchemaDataAccessRegistry.getMappingByName((Name)featureTypeName);
            if (featureTypeMapping == null) {
                LOGGER.info("FeatureTypeMapping for '" + String.valueOf(featureTypeName) + "' not found when evaluating filter!");
                return Collections.emptyList();
            }
            this.nestedIdExpression = featureTypeMapping.getFeatureIdExpression();
            this.source = featureTypeMapping.getSource();
            if (this.source == null) {
                LOGGER.info("Feature source for '" + String.valueOf(featureTypeName) + "' not found when evaluating filter");
                return Collections.emptyList();
            }
            AttributeMapping mapping = this.getMapping(featureTypeMapping);
            this.nestedSourceExpression = mapping.getSourceExpression();
            isMultiple = mapping.isMultiValued();
        }
        return this.getFilteredFeatures(foreignKeyValue, isMultiple);
    }

    public AttributeMapping getMapping(FeatureTypeMapping featureTypeMapping) {
        AttributeMapping mapping;
        if (!"FEATURE_LINK".equals(((XPathUtil.Step)this.nestedTargetXPath.get(this.nestedTargetXPath.size() - 1)).getName().getLocalPart())) {
            List<AttributeMapping> mappings = featureTypeMapping.getAttributeMappingsIgnoreIndex(this.nestedTargetXPath);
            if (mappings.isEmpty()) {
                throw new IllegalArgumentException("Mapping is missing for: '" + String.valueOf(this.nestedTargetXPath) + "'!");
            }
            mapping = mappings.get(0);
        } else {
            mapping = featureTypeMapping.getAttributeMapping(this.nestedTargetXPath);
            if (mapping == null) {
                throw new IllegalArgumentException("Mapping is missing for: '" + String.valueOf(this.nestedTargetXPath) + "'!");
            }
        }
        return mapping;
    }

    private List<Feature> getFilteredFeatures(Object foreignKeyValue, boolean isMultiple) throws IOException {
        if (this.nestedSourceExpression == null) {
            return Collections.emptyList();
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        PropertyIsEqualTo filter = this.filterFac.equals(this.nestedSourceExpression, (Expression)this.filterFac.literal(foreignKeyValue));
        FeatureCollection fCollection = this.source.getFeatures((Filter)filter);
        Id matchingIdFilter = null;
        try (FeatureIterator it = fCollection.features();){
            Feature f;
            HashSet<Object> featureIds;
            if (this.nestedIdExpression.equals(Expression.NIL)) {
                featureIds = new HashSet<Object>();
                while (it.hasNext()) {
                    f = it.next();
                    matchingFeatures.add(f);
                    if (!isMultiple || f.getIdentifier() == null) continue;
                    featureIds.add(f.getIdentifier());
                }
                if (!featureIds.isEmpty()) {
                    matchingIdFilter = this.filterFac.id(featureIds);
                }
            } else {
                featureIds = new HashSet();
                while (it.hasNext()) {
                    f = it.next();
                    matchingFeatures.add(f);
                    if (!isMultiple) continue;
                    featureIds.add((String)Converters.convert((Object)this.nestedIdExpression.evaluate((Object)f), String.class));
                }
                if (!featureIds.isEmpty()) {
                    ArrayList<PropertyIsEqualTo> idFilters = new ArrayList<PropertyIsEqualTo>(featureIds.size());
                    for (String string : featureIds) {
                        idFilters.add(this.filterFac.equals(this.nestedIdExpression, (Expression)this.filterFac.literal((Object)string)));
                    }
                    matchingIdFilter = this.filterFac.or(idFilters);
                }
            }
        }
        if (matchingIdFilter != null && (fCollection = this.source.getFeatures((Filter)matchingIdFilter)).size() > matchingFeatures.size()) {
            it = fCollection.features();
            try {
                matchingFeatures.clear();
                while (it.hasNext()) {
                    matchingFeatures.add(it.next());
                }
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        return matchingFeatures;
    }

    public List<Feature> getInputFeatures(Object foreignKeyValue, FeatureTypeMapping fMapping) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        boolean isMultiple = false;
        if ((this.source == null || this.isConditional) && fMapping != null) {
            this.source = fMapping.getSource();
            if (this.source == null) {
                LOGGER.info("Feature source for '" + String.valueOf(fMapping.getTargetFeature().getName()) + "' not found when evaluating filter");
                return Collections.emptyList();
            }
            this.nestedIdExpression = fMapping.getFeatureIdExpression();
            AttributeMapping mapping = this.getMapping(fMapping);
            this.nestedSourceExpression = mapping.getSourceExpression();
            isMultiple = mapping.isMultiValued();
        }
        if (this.nestedSourceExpression == null) {
            return null;
        }
        return this.getFilteredFeatures(foreignKeyValue, isMultiple);
    }

    public List<Feature> getFeatures(Object foreignKeyValue, CoordinateReferenceSystem reprojection, Feature feature, int resolveDepth, Integer resolveTimeOut) throws IOException {
        return this.getFeatures(null, foreignKeyValue, null, reprojection, feature, null, true, resolveDepth, resolveTimeOut);
    }

    public List<Feature> getFeatures(Object source, Object foreignKeyValue, List<Object> idValues, CoordinateReferenceSystem reprojection, Object feature, List<PropertyName> selectedProperties, boolean includeMandatory, int resolveDepth, Integer resolveTimeOut) throws IOException {
        if (foreignKeyValue == null) {
            return Collections.emptyList();
        }
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        FeatureSource<? extends FeatureType, ? extends Feature> fSource = this.getMappingSource(feature);
        if (fSource == null) {
            return null;
        }
        Query query = new Query();
        query.setCoordinateSystemReproject(reprojection);
        PropertyName propertyName = this.filterFac.property(this.nestedTargetXPath.toString());
        PropertyIsEqualTo filter = this.filterFac.equals((Expression)propertyName, (Expression)this.filterFac.literal(foreignKeyValue));
        query.setFilter((Filter)filter);
        if (selectedProperties != null && !selectedProperties.isEmpty()) {
            selectedProperties = new ArrayList<PropertyName>(selectedProperties);
            selectedProperties.add(propertyName);
        }
        Hints hints = new Hints();
        hints.put((Object)Query.INCLUDE_MANDATORY_PROPS, (Object)includeMandatory);
        if (resolveDepth > 0) {
            hints.put((Object)Hints.RESOLVE, (Object)ResolveValueType.ALL);
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)resolveDepth);
            hints.put((Object)Hints.RESOLVE_TIMEOUT, (Object)resolveTimeOut);
        } else {
            hints.put((Object)Hints.RESOLVE, (Object)ResolveValueType.NONE);
        }
        query.setHints(hints);
        query.setProperties(selectedProperties);
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        FeatureCollection fCollection = fSource.getFeatures(query);
        if (fCollection instanceof MappingFeatureCollection) {
            try (FeatureIterator iterator = fCollection.features();){
                while (iterator.hasNext()) {
                    matchingFeatures.add(iterator.next());
                }
            }
        }
        return matchingFeatures;
    }

    protected FeatureSource<? extends FeatureType, ? extends Feature> getMappingSource(Object feature) throws IOException {
        if (this.mappingSource == null || this.isConditional) {
            Object featureTypeName = this.getNestedFeatureType(feature);
            if (featureTypeName == null || !(featureTypeName instanceof Name)) {
                return null;
            }
            this.mappingSource = DataAccessRegistry.getFeatureSource((Name)featureTypeName);
        }
        return this.mappingSource;
    }

    public Object getNestedFeatureType(Object feature) {
        Object fTypeValue;
        if (this.isConditional) {
            if (feature == null) {
                throw new IllegalArgumentException("Feature parameter is required!");
            }
            fTypeValue = this.nestedFeatureType.evaluate(feature);
            if (fTypeValue == null) {
                return null;
            }
            if (fTypeValue instanceof Hints) {
                return ((Hints)fTypeValue).get((Object)ComplexFeatureConstants.STRING_KEY);
            }
        } else {
            fTypeValue = this.nestedFeatureType.toString();
        }
        return Types.degloseName((String)String.valueOf(fTypeValue), (NamespaceSupport)this.namespaces);
    }

    public boolean isConditional() {
        return this.isConditional;
    }

    public boolean isSameSource() {
        return this.nestedTargetXPath == null;
    }

    public FeatureTypeMapping getFeatureTypeMapping(Feature feature) throws IOException {
        FeatureSource<? extends FeatureType, ? extends Feature> fSource = this.getMappingSource(feature);
        if (fSource == null) {
            return null;
        }
        return fSource instanceof MappingFeatureSource ? ((MappingFeatureSource)fSource).getMapping() : null;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }
}

