/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.DataAccessMap;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public class AppSchemaDataAccessFactory
implements DataAccessFactory {
    private static final Logger LOGGER = Logging.getLogger(AppSchemaDataAccessFactory.class);
    public static final String DBTYPE_STRING = "app-schema";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Fixed value 'app-schema'", true, (Object)"app-schema", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param URL = new DataAccessFactory.Param("url", URL.class, "URL to an application schema datastore XML configuration file", true);

    public DataAccess<FeatureType, Feature> createDataStore(Map<String, ?> params) throws IOException {
        HashSet<AppSchemaDataAccess> registeredAppSchemaStores = new HashSet<AppSchemaDataAccess>();
        try {
            return this.createDataStore(params, false, new DataAccessMap(), registeredAppSchemaStores, null);
        }
        catch (Exception ex) {
            for (AppSchemaDataAccess appSchemaDataAccess : registeredAppSchemaStores) {
                appSchemaDataAccess.dispose();
            }
            throw ex;
        }
    }

    public DataAccess<FeatureType, Feature> createDataStore(Map<String, ?> params, boolean hidden, DataAccessMap sourceDataStoreMap, Set<AppSchemaDataAccess> registeredAppSchemaStores, URL parentUrl) throws IOException {
        URL configFileUrl = (URL)URL.lookUp(params);
        XMLConfigDigester configReader = new XMLConfigDigester();
        AppSchemaDataAccessDTO config = configReader.parse(configFileUrl);
        List<String> includes = config.getIncludes();
        HashMap extendedParams = new HashMap(params);
        for (String include : includes) {
            extendedParams.put("url", this.buildIncludeUrl(configFileUrl, include));
            this.createDataStore(extendedParams, true, sourceDataStoreMap, registeredAppSchemaStores, parentUrl == null ? configFileUrl : parentUrl);
        }
        Set<FeatureTypeMapping> mappings = AppSchemaDataAccessConfigurator.buildMappings(config, sourceDataStoreMap);
        AppSchemaDataAccess dataStore = new AppSchemaDataAccess(mappings, hidden);
        dataStore.url = configFileUrl;
        dataStore.parentUrl = parentUrl;
        registeredAppSchemaStores.add(dataStore);
        return dataStore;
    }

    private String buildIncludeUrl(URL parentUrl, String include) {
        String includeLowerCase = include.toLowerCase();
        if (includeLowerCase.startsWith("http:") || includeLowerCase.startsWith("file:")) {
            return include;
        }
        Object url = parentUrl.toString();
        int index = ((String)url).lastIndexOf("/");
        if (index <= 0) {
            throw new RuntimeException(String.format("Can't build include types '%s' URL using parent '%s' URL.", include, url));
        }
        url = ((String)url).substring(0, index + 1) + include;
        LOGGER.fine(String.format("Using URL '%s' to retrieve include types with '%s'.", url, include));
        return url;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName() {
        return "Application Schema DataAccess";
    }

    public String getDescription() {
        return "Application Schema DataStore allows mapping of FeatureTypes to externally defined Output Schemas";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBTYPE, URL};
    }

    public boolean canProcess(Map<String, ?> params) {
        try {
            Object dbType = DBTYPE.lookUp(params);
            Object configUrl = URL.lookUp(params);
            return DBTYPE_STRING.equals(dbType) && configUrl != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

