/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.jdbc;

import java.io.StringWriter;
import java.io.Writer;
import org.geotools.appschema.jdbc.JdbcMultipleValueEncoder;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public final class WrappedFilterToSql {
    private final StringWriter out = new StringWriter();
    private final FeatureTypeMapping featureMapping;
    private final FilterToSQL filterToSql;

    public WrappedFilterToSql(FeatureTypeMapping featureMapping, FilterToSQL filterToSql) {
        this.featureMapping = featureMapping;
        this.filterToSql = filterToSql;
        filterToSql.setWriter((Writer)this.out);
    }

    public void encode(Filter filter) throws FilterToSQLException {
        this.filterToSql.encode(this.encodeJdbcMultipleValues(filter, (Writer)this.out));
    }

    public String encodeToString(Filter filter) throws FilterToSQLException {
        StringWriter out = new StringWriter();
        this.filterToSql.setWriter((Writer)out);
        this.filterToSql.encode(this.encodeJdbcMultipleValues(filter, (Writer)out));
        return out.toString();
    }

    public void encode(Expression expression) throws FilterToSQLException {
        this.filterToSql.encode(this.encodeJdbcMultipleValues(expression, (Writer)this.out));
    }

    public String encodeToString(Expression expression) throws FilterToSQLException {
        return this.filterToSql.encodeToString(this.encodeJdbcMultipleValues(expression, (Writer)this.out));
    }

    public void setSqlNameEscape(String escape) {
        this.filterToSql.setSqlNameEscape(escape);
    }

    public void setFieldEncoder(FilterToSQL.FieldEncoder fieldEncoder) {
        this.filterToSql.setFieldEncoder(fieldEncoder);
    }

    private Filter encodeJdbcMultipleValues(Filter filter, Writer out) {
        JdbcMultipleValueEncoder encoder = new JdbcMultipleValueEncoder(this.featureMapping, out);
        return (Filter)filter.accept((FilterVisitor)encoder, null);
    }

    private Expression encodeJdbcMultipleValues(Expression expression, Writer out) {
        JdbcMultipleValueEncoder encoder = new JdbcMultipleValueEncoder(this.featureMapping, out);
        return (Expression)expression.accept((ExpressionVisitor)encoder, null);
    }
}

