/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.JdbcMultipleValue;
import org.geotools.data.complex.config.MultipleValue;
import org.geotools.data.complex.filter.MultipleValueExtractor;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JoinInfo;
import org.geotools.jdbc.JoinPropertyName;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFIDValidator;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class JoiningJDBCFeatureSource
extends JDBCFeatureSource {
    private static final Logger LOGGER = Logging.getLogger(JoiningJDBCFeatureSource.class);
    private static final String TEMP_FILTER_ALIAS = "temp_alias_used_for_filter";
    public static final String FOREIGN_ID = "FOREIGN_ID";
    public static final String PRIMARY_KEY = "PARENT_TABLE_PKEY";
    private static final String COUNT_TABLE_ALIAS = "COUNT_TABLE";
    private static final String DISTINCT_TABLE_ALIAS = "DISTINCT_TABLE";

    public JoiningJDBCFeatureSource(JDBCFeatureSource featureSource) throws IOException {
        super(featureSource);
    }

    public JoiningJDBCFeatureSource(JDBCFeatureStore featureStore) throws IOException {
        super(featureStore.delegate);
    }

    protected void encodeGeometryColumn(GeometryDescriptor gatt, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        StringBuffer temp = new StringBuffer();
        this.getDataStore().encodeGeometryColumn(gatt, temp, hints);
        StringBuffer originalColumnName = new StringBuffer();
        this.getDataStore().dialect.encodeColumnName(null, gatt.getLocalName(), originalColumnName);
        StringBuffer replaceColumnName = new StringBuffer();
        this.encodeColumnName(gatt.getLocalName(), typeName, replaceColumnName, hints);
        sql.append(temp.toString().replaceAll(originalColumnName.toString(), replaceColumnName.toString()));
    }

    protected void sort(String typeName, String alias, SortBy[] sort, Set<String> orderByFields, StringBuffer sql) throws IOException, SQLException {
        StringBuffer mySql;
        for (SortBy sortBy : sort) {
            if (SortBy.NATURAL_ORDER.equals(sortBy) || SortBy.REVERSE_ORDER.equals(sortBy)) {
                throw new IOException("Cannot do natural order in joining queries");
            }
            mySql = new StringBuffer();
            if (alias != null) {
                this.encodeColumnName2(sortBy.getPropertyName().getPropertyName(), alias, mySql, null);
            } else {
                this.encodeColumnName(sortBy.getPropertyName().getPropertyName(), typeName, mySql, null);
            }
            if (mySql.toString().isEmpty() || !orderByFields.add(mySql.toString())) continue;
            if (orderByFields.size() > 1) {
                sql.append(", ");
            }
            sql.append(mySql);
            if (sortBy.getSortOrder() == SortOrder.DESCENDING) {
                sql.append(" DESC");
                continue;
            }
            sql.append(" ASC");
        }
        if (sort.length == 0) {
            PrimaryKey joinKey = null;
            SimpleFeatureType joinFeatureType = this.getDataStore().getSchema(typeName);
            try {
                joinKey = this.getDataStore().getPrimaryKey(joinFeatureType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (PrimaryKeyColumn col : joinKey.getColumns()) {
                mySql = new StringBuffer();
                if (alias != null) {
                    this.encodeColumnName2(col.getName(), alias, mySql, null);
                } else {
                    this.encodeColumnName(col.getName(), typeName, mySql, null);
                }
                if (mySql.toString().isEmpty() || !orderByFields.add(mySql.toString())) continue;
                if (orderByFields.size() > 1) {
                    sql.append(", ");
                }
                sql.append(mySql);
                sql.append(" ASC");
            }
        }
    }

    protected void addMultiValuedSort(String tableName, Set<String> orderByFields, JoiningQuery.QueryJoin join, StringBuffer sql) throws IOException, FilterToSQLException, SQLException {
        StringBuffer field2 = new StringBuffer();
        this.encodeColumnName(join.getForeignKeyName().toString(), join.getJoiningTypeName(), field2, null);
        StringBuffer field1 = new StringBuffer();
        this.encodeColumnName(join.getJoiningKeyName().toString(), tableName, field1, null);
        if (orderByFields.add(field1.toString()) && orderByFields.add(field2.toString())) {
            if (sql.length() > 0) {
                sql.append(", ");
            }
            sql.append(" CASE WHEN ");
            sql.append(field2);
            sql.append(" = ");
            sql.append(field1);
            sql.append(" THEN 0 ELSE 1 END ASC");
        }
    }

    protected void sort(JoiningQuery query, StringBuffer sql, String[] aliases, Set<String> pkColumnNames) throws IOException, SQLException, FilterToSQLException {
        int j;
        LinkedHashSet<String> orderByFields = new LinkedHashSet<String>();
        StringBuffer joinOrders = new StringBuffer();
        int n = j = query.getQueryJoins() == null ? -1 : query.getQueryJoins().size() - 1;
        while (j >= -1) {
            SortBy[] sort;
            JoiningQuery.QueryJoin join = j < 0 ? null : query.getQueryJoins().get(j);
            SortBy[] sortByArray = sort = j < 0 ? query.getSortBy() : join.getSortBy();
            if (sort != null) {
                if (j < 0) {
                    this.sort(query.getTypeName(), null, sort, orderByFields, joinOrders);
                    if (query.getQueryJoins() != null && query.getQueryJoins().size() > 0) {
                        this.addMultiValuedSort(query.getTypeName(), orderByFields, query.getQueryJoins().get(0), joinOrders);
                    }
                    if (joinOrders.length() > 0) {
                        sql.append(" ORDER BY ");
                        sql.append(joinOrders);
                    }
                    if (!pkColumnNames.isEmpty()) {
                        for (String pk : pkColumnNames) {
                            StringBuffer pkSql = new StringBuffer();
                            this.encodeColumnName(pk, query.getTypeName(), pkSql, null);
                            if (pkSql.toString().isEmpty() || !orderByFields.add(pkSql.toString())) continue;
                            sql.append(", ");
                            sql.append(pkSql);
                        }
                    }
                } else {
                    if (aliases != null && aliases[j] != null) {
                        this.sort(join.getJoiningTypeName(), aliases[j], sort, orderByFields, joinOrders);
                    } else {
                        this.sort(join.getJoiningTypeName(), null, sort, orderByFields, joinOrders);
                    }
                    if (query.getQueryJoins().size() > j + 1) {
                        this.addMultiValuedSort(join.getJoiningTypeName(), orderByFields, query.getQueryJoins().get(j + 1), joinOrders);
                    }
                }
            }
            --j;
        }
    }

    public void encodeColumnName(String colName, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        this.getDataStore().encodeTableName(typeName, sql, hints);
        sql.append(".");
        this.getDataStore().dialect.encodeColumnName(null, colName, sql);
    }

    public void encodeColumnName2(String colName, String typeName, StringBuffer sql, Hints hints) throws SQLException {
        this.getDataStore().dialect.encodeTableName(typeName, sql);
        sql.append(".");
        this.getDataStore().dialect.encodeColumnName(null, colName, sql);
    }

    protected FilterToSQL createFilterToSQL(SimpleFeatureType ft) {
        return this.createFilterToSQL(ft, true);
    }

    protected FilterToSQL createFilterToSQL(SimpleFeatureType ft, boolean usePreparedStatementParameters) {
        if (this.getDataStore().getSQLDialect() instanceof PreparedStatementSQLDialect) {
            PreparedFilterToSQL pfsql = this.getDataStore().createPreparedFilterToSQL(ft);
            pfsql.setPrepareEnabled(usePreparedStatementParameters);
            return pfsql;
        }
        return this.getDataStore().createFilterToSQL(ft);
    }

    protected static String createAlias(String typeName, Set<String> tableNames) {
        Object alias = typeName;
        if (typeName.length() > 20) {
            typeName = typeName.substring(0, 20);
        }
        int index = 0;
        while (tableNames.contains(alias)) {
            alias = typeName + "_" + ++index;
        }
        return alias;
    }

    public String selectSQL(SimpleFeatureType featureType, JoiningQuery query, AtomicReference<PreparedFilterToSQL> toSQLref) throws SQLException, IOException, FilterToSQLException {
        return this.selectSQL(featureType, query, toSQLref, false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public String selectSQL(SimpleFeatureType featureType, JoiningQuery query, AtomicReference<PreparedFilterToSQL> toSQLref, boolean isCount) throws IOException, SQLException, FilterToSQLException {
        joinClause = new StringBuffer();
        tableNames = new HashSet<String>();
        curTypeName = lastTypeName = featureType.getTypeName();
        aliases = null;
        tableNames.add(lastTypeName);
        alias = null;
        if (query.getQueryJoins() != null) {
            aliases = new String[query.getQueryJoins().size()];
            for (i = 0; i < query.getQueryJoins().size(); ++i) {
                join = query.getQueryJoins().get(i);
                joinClause.append(" INNER JOIN ");
                toSQL1 = this.createFilterToSQL(this.getDataStore().getSchema(lastTypeName), toSQLref != null);
                toSQL2 = this.createFilterToSQL(this.getDataStore().getSchema(join.getJoiningTypeName()), toSQLref != null);
                if (tableNames.contains(join.getJoiningTypeName())) {
                    aliases[i] = alias = JoiningJDBCFeatureSource.createAlias(join.getJoiningTypeName(), tableNames);
                    this.getDataStore().encodeTableName(join.getJoiningTypeName(), joinClause, query.getHints());
                    joinClause.append(" ");
                    this.getDataStore().dialect.encodeTableName(alias, joinClause);
                    joinClause.append(" ON ( ");
                    toSQL2.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(alias, this.getDataStore()));
                    joinClause.append(toSQL2.encodeToString(join.getForeignKeyName()));
                } else {
                    aliases[i] = null;
                    this.getDataStore().encodeTableName(join.getJoiningTypeName(), joinClause, query.getHints());
                    joinClause.append(" ON ( ");
                    toSQL2.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(join.getJoiningTypeName(), this.getDataStore()));
                    joinClause.append(toSQL2.encodeToString(join.getForeignKeyName()));
                }
                joinClause.append(" = ");
                fromTypeName = curTypeName;
                toSQL1.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(fromTypeName, this.getDataStore()));
                joinClause.append(toSQL1.encodeToString(join.getJoiningKeyName()));
                joinClause.append(") ");
                lastTypeName = join.getJoiningTypeName();
                curTypeName = aliases[i] == null ? lastTypeName : aliases[i];
                tableNames.add(curTypeName);
            }
        }
        sql = new StringBuffer();
        sql.append("SELECT ");
        pkColumnNames = this.getAllPrimaryKeys(featureType);
        for (Object colName : pkColumnNames) {
            this.encodeColumnName((String)colName, featureType.getTypeName(), sql, query.getHints());
            sql.append(",");
        }
        lastPkColumnNames = pkColumnNames;
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            columnName = att.getLocalName();
            if (pkColumnNames.contains(columnName)) continue;
            if (att instanceof GeometryDescriptor) {
                this.encodeGeometryColumn((GeometryDescriptor)att, featureType.getTypeName(), sql, query.getHints());
                this.getDataStore().dialect.encodeColumnAlias(columnName, sql);
            } else {
                this.encodeColumnName(columnName, featureType.getTypeName(), sql, query.getHints());
            }
            sql.append(",");
        }
        if (query.getQueryJoins() != null && query.getQueryJoins().size() > 0) {
            for (i = 0; i < query.getQueryJoins().size(); ++i) {
                ids = query.getQueryJoins().get(i).getIds();
                for (j = 0; j < ids.size(); ++j) {
                    if (aliases[i] != null) {
                        this.getDataStore().dialect.encodeColumnName(aliases[i], query.getQueryJoins().get(i).getIds().get(j), sql);
                    } else {
                        this.encodeColumnName(query.getQueryJoins().get(i).getIds().get(j), query.getQueryJoins().get(i).getJoiningTypeName(), sql, query.getHints());
                    }
                    sql.append(" ").append("FOREIGN_ID_" + i + "_" + j).append(",");
                }
                if (!ids.isEmpty()) continue;
                joinKey = null;
                joinTypeName = query.getQueryJoins().get(i).getJoiningTypeName();
                joinFeatureType = this.getDataStore().getSchema(joinTypeName);
                try {
                    joinKey = this.getDataStore().getPrimaryKey(joinFeatureType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (!joinKey.getColumns().isEmpty()) {
                    lastPkColumnNames.clear();
                }
                j = 0;
                for (PrimaryKeyColumn col : joinKey.getColumns()) {
                    if (aliases[i] != null) {
                        this.getDataStore().dialect.encodeColumnName(aliases[i], col.getName(), sql);
                    } else {
                        this.encodeColumnName(col.getName(), joinTypeName, sql, query.getHints());
                    }
                    query.getQueryJoins().get(i).addId(col.getName());
                    sql.append(" ").append("FOREIGN_ID_" + i + "_" + j).append(",");
                    ++j;
                    lastPkColumnNames.add(col.getName());
                }
            }
        }
        if (!query.hasIdColumn() && !pkColumnNames.isEmpty()) {
            pkIndex = 0;
            for (String pk : pkColumnNames) {
                this.encodeColumnName(pk, featureType.getTypeName(), sql, query.getHints());
                sql.append(" ").append("PARENT_TABLE_PKEY").append("_").append(pkIndex).append(",");
                ++pkIndex;
            }
        }
        sql.setLength(sql.length() - 1);
        sql.append(" FROM ");
        this.getDataStore().encodeTableName(featureType.getTypeName(), sql, query.getHints());
        toSQL = null;
        filter = query.getFilter();
        sql.append(joinClause);
        isRootFeature = query.getQueryJoins() == null || query.getQueryJoins().size() == 0;
        pagingApplied = false;
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                lastSortBy = null;
                if (!query.isSubset()) {
                    lastSortBy = isRootFeature != false ? query.getSortBy() : (query.getQueryJoins() == null || query.getQueryJoins().size() == 0 ? query.getSortBy() : query.getQueryJoins().get(query.getQueryJoins().size() - 1).getSortBy());
                }
                v0 = lastTableName = isRootFeature != false ? query.getTypeName() : query.getQueryJoins().get(query.getQueryJoins().size() - 1).getJoiningTypeName();
                lastTableAlias = isRootFeature != false ? query.getTypeName() : (aliases[query.getQueryJoins().size() - 1] == null ? lastTableName : aliases[query.getQueryJoins().size() - 1]);
                toSQL = this.createFilterToSQL(this.getDataStore().getSchema(lastTableName), toSQLref != null);
                ids = new ArrayList<String>();
                if (!isCount) {
                    pagingApplied = this.applyPaging(query, isRootFeature, sql, featureType, pkColumnNames, tableNames, toSQL, filter, ids, aliases);
                }
                if (!(lastSortBy == null || lastSortBy.length <= 0 && lastPkColumnNames.isEmpty())) {
                    this.buildFilter(query, sql, lastPkColumnNames, toSQL, filter, lastSortBy, lastTableName, lastTableAlias, ids, curTypeName);
                }
                if (pagingApplied) ** GOTO lbl150
                if (NestedFilterToSQL.isNestedFilter(filter)) {
                    toSQL.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(curTypeName, this.getDataStore()));
                    sql.append(" WHERE ").append(this.createNestedFilter(filter, query, toSQL));
                }
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        } else if (!isCount) {
            pagingApplied = this.applyPaging(query, isRootFeature, sql, featureType, pkColumnNames, tableNames, null, null, null, aliases);
        }
lbl150:
        // 7 sources

        if (!isCount) {
            this.sort(query, sql, aliases, pkColumnNames);
            if (!pagingApplied) {
                this.getDataStore().applyLimitOffset(sql, (Query)query);
            }
        }
        if (toSQLref != null && toSQL instanceof PreparedFilterToSQL) {
            toSQLref.set((PreparedFilterToSQL)toSQL);
        }
        return sql.toString();
    }

    private boolean applyPaging(JoiningQuery query, boolean isRootFeature, StringBuffer sql, SimpleFeatureType featureType, Set<String> pkColumnNames, Set<String> tableNames, FilterToSQL toSQL, Filter filter, Collection<String> ids, String[] aliases) throws IOException, SQLException, FilterToSQLException {
        boolean pagingApplied = false;
        if (isRootFeature && query.isDenormalised()) {
            pagingApplied = this.applyPaging(query, sql, pkColumnNames, featureType.getTypeName(), featureType.getTypeName(), tableNames, toSQL, filter, ids);
        } else if (!isRootFeature) {
            int lastJoinIndex = query.getQueryJoins().size() - 1;
            JoiningQuery.QueryJoin lastJoin = query.getQueryJoins().get(lastJoinIndex);
            String lastTableName = query.getQueryJoins().get(lastJoinIndex).getJoiningTypeName();
            String lastTableAlias = aliases[lastJoinIndex] == null ? lastTableName : aliases[lastJoinIndex];
            pagingApplied = this.applyPaging(lastJoin, sql, pkColumnNames, lastTableName, lastTableAlias, tableNames, toSQL, filter, ids);
        }
        return pagingApplied;
    }

    private void buildFilter(JoiningQuery query, StringBuffer sql, Set<String> lastPkColumnNames, FilterToSQL toSQL, Filter filter, SortBy[] lastSortBy, String lastTableName, String lastTableAlias, Collection<String> ids, String curTypeName) throws SQLException, FilterToSQLException, IOException {
        StringBuffer sortBySQL = new StringBuffer();
        sortBySQL.append(" INNER JOIN ( SELECT DISTINCT ");
        boolean hasSortBy = false;
        boolean isMultiSort = lastSortBy.length > 1 && ids.isEmpty();
        boolean bl = hasSortBy = isMultiSort ? this.buildFiterBasedOnPk(query, toSQL, filter, lastSortBy, lastTableName, lastTableAlias, lastPkColumnNames, sortBySQL, hasSortBy) : this.buildFiterBasedOnSortBy(query, toSQL, filter, lastSortBy, lastTableName, lastTableAlias, ids, sortBySQL, hasSortBy);
        if (lastSortBy.length == 0) {
            Set<String> lastTablePk = this.getAllPrimaryKeys(this.getDataStore().getSchema(lastTableName));
            int i = 0;
            for (String pk : lastTablePk) {
                String sqlFilter;
                this.getDataStore().dialect.encodeColumnName(null, pk, sortBySQL);
                sortBySQL.append(" FROM ");
                if (!lastTableAlias.equals(lastTableName)) {
                    this.getDataStore().encodeAliasedTableName(lastTableName, sortBySQL, query.getHints(), lastTableAlias);
                } else {
                    this.getDataStore().encodeTableName(lastTableName, sortBySQL, query.getHints());
                }
                if (NestedFilterToSQL.isNestedFilter(filter)) {
                    toSQL.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(curTypeName, this.getDataStore()));
                    sortBySQL.append(" WHERE ");
                    sqlFilter = this.createNestedFilter(filter, query, toSQL).toString();
                } else {
                    sqlFilter = toSQL.encodeToString(filter);
                }
                sortBySQL.append(" ").append(sqlFilter);
                sortBySQL.append(" ) ");
                this.getDataStore().dialect.encodeTableName(TEMP_FILTER_ALIAS, sortBySQL);
                sortBySQL.append(" ON ( ");
                this.encodeColumnName2(pk, lastTableAlias, sortBySQL, null);
                sortBySQL.append(" = ");
                this.encodeColumnName2(pk, TEMP_FILTER_ALIAS, sortBySQL, null);
                if (i < lastPkColumnNames.size() - 1) {
                    sortBySQL.append(" AND ");
                }
                ++i;
                hasSortBy = true;
            }
        }
        if (hasSortBy) {
            if (sortBySQL.toString().endsWith(" AND ")) {
                sql.append(sortBySQL.substring(0, sortBySQL.length() - 5)).append(" ) ");
            } else {
                sql.append(sortBySQL).append(" ) ");
            }
        }
    }

    private boolean buildFiterBasedOnSortBy(JoiningQuery query, FilterToSQL toSQL, Filter filter, SortBy[] lastSortBy, String lastTableName, String lastTableAlias, Collection<String> ids, StringBuffer sortBySQL, boolean hasSortBy) throws SQLException, FilterToSQLException {
        for (int i = 0; i < lastSortBy.length; ++i) {
            if (ids.contains(lastSortBy[i].getPropertyName().toString())) continue;
            hasSortBy = this.processSortByKey(query, toSQL, filter, lastSortBy, lastTableName, lastTableAlias, sortBySQL, i);
        }
        return hasSortBy;
    }

    private boolean buildFiterBasedOnPk(JoiningQuery query, FilterToSQL toSQL, Filter filter, SortBy[] lastSortBy, String lastTableName, String lastTableAlias, Set<String> lastPkColumnNames, StringBuffer sortBySQL, boolean hasSortBy) throws SQLException, FilterToSQLException {
        for (int i = lastSortBy.length - lastPkColumnNames.size(); i < lastSortBy.length; ++i) {
            hasSortBy = this.processSortByKey(query, toSQL, filter, lastSortBy, lastTableName, lastTableAlias, sortBySQL, i);
        }
        return hasSortBy;
    }

    private boolean processSortByKey(JoiningQuery query, FilterToSQL toSQL, Filter filter, SortBy[] lastSortBy, String lastTableName, String lastTableAlias, StringBuffer sortBySQL, int i) throws SQLException, FilterToSQLException {
        this.getDataStore().dialect.encodeColumnName(lastTableName, lastSortBy[i].getPropertyName().getPropertyName(), sortBySQL);
        sortBySQL.append(" FROM ");
        this.getDataStore().encodeTableName(lastTableName, sortBySQL, query.getHints());
        this.encodeMultipleValueJoin(query.getRootMapping(), lastTableName, this.getDataStore(), sortBySQL);
        if (NestedFilterToSQL.isNestedFilter(filter)) {
            sortBySQL.append(" WHERE ");
            boolean replaceOrWithUnion = this.isPostgisDialect() && this.isOrUnionReplacementEnabled();
            String selectClause = sortBySQL.toString().replace(" INNER JOIN ( ", "");
            SimpleFeatureType featureType = toSQL.getFeatureType();
            FilterToSQL toSQL2 = this.createFilterToSQL(featureType, false);
            sortBySQL.append(this.createNestedFilter(filter, query, toSQL2, selectClause, replaceOrWithUnion));
        } else {
            sortBySQL.append(" ").append(toSQL.encodeToString(filter));
        }
        sortBySQL.append(" ) ");
        this.getDataStore().dialect.encodeTableName(TEMP_FILTER_ALIAS, sortBySQL);
        sortBySQL.append(" ON ( ");
        this.encodeColumnName2(lastSortBy[i].getPropertyName().getPropertyName(), lastTableAlias, sortBySQL, null);
        sortBySQL.append(" = ");
        this.encodeColumnName2(lastSortBy[i].getPropertyName().getPropertyName(), TEMP_FILTER_ALIAS, sortBySQL, null);
        if (i < lastSortBy.length - 1) {
            sortBySQL.append(" AND ");
        }
        boolean hasSortBy = true;
        return hasSortBy;
    }

    private void encodeMultipleValueJoin(FeatureTypeMapping rootMapping, String rootTableName, JDBCDataStore store, StringBuffer sql) {
        for (AttributeMapping attributeMapping : rootMapping.getAttributeMappings()) {
            if (!(attributeMapping.getMultipleValue() instanceof JdbcMultipleValue)) continue;
            JdbcMultipleValue multipleValue = (JdbcMultipleValue)attributeMapping.getMultipleValue();
            sql.append(" LEFT JOIN ");
            String alias = String.valueOf(multipleValue.getId());
            try {
                store.encodeAliasedTableName(multipleValue.getTargetTable(), sql, null, alias);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            sql.append(" ON ");
            store.dialect.encodeColumnName(null, rootTableName, sql);
            sql.append(".");
            store.dialect.encodeColumnName(null, multipleValue.getSourceColumn(), sql);
            sql.append(" = ");
            store.dialect.encodeTableName(alias, sql);
            sql.append(".");
            store.dialect.encodeColumnName(null, multipleValue.getTargetColumn(), sql);
            sql.append(" ");
        }
    }

    private Object createNestedFilter(Filter filter, JoiningQuery query, FilterToSQL filterToSQL) throws FilterToSQLException {
        NestedFilterToSQL nested = new NestedFilterToSQL(query.getRootMapping(), filterToSQL);
        nested.setInline(true);
        return nested.encodeToString(filter);
    }

    private Object createNestedFilter(Filter filter, JoiningQuery query, FilterToSQL filterToSQL, String selectClause, boolean replaceOrWithUnion) throws FilterToSQLException {
        NestedFilterToSQL nested = new NestedFilterToSQL(query.getRootMapping(), filterToSQL);
        nested.setInline(true);
        nested.setSelectClause(selectClause);
        nested.setReplaceOrWithUnion(replaceOrWithUnion);
        return nested.encodeToString(filter);
    }

    private boolean applyPaging(JoiningQuery query, StringBuffer sql, Set<String> pkColumnNames, String typeName, String alias, Set<String> tableNames, FilterToSQL filterToSQL, Filter filter, Collection<String> allIds) throws SQLException, FilterToSQLException, IOException {
        Collection<Object> ids = Collections.emptyList();
        if (this.getDataStore().dialect.isLimitOffsetSupported()) {
            int startIndex = query.getStartIndex() == null ? 0 : query.getStartIndex();
            int maxFeatures = query.getMaxFeatures();
            if (startIndex > 0 || maxFeatures < 1000000) {
                ids = !query.getIds().isEmpty() ? query.getIds() : pkColumnNames;
                for (String string : ids) {
                    sql.append(" INNER JOIN (");
                    StringBuffer topIds = new StringBuffer();
                    topIds.append("SELECT DISTINCT ");
                    StringBuffer idSQL = new StringBuffer();
                    this.encodeColumnName(string, typeName, idSQL, query.getHints());
                    topIds.append(idSQL);
                    SortBy[] sort = query.getSortBy();
                    LinkedHashSet<String> orderByFields = new LinkedHashSet<String>();
                    StringBuffer sortSQL = new StringBuffer();
                    if (sort != null) {
                        this.sort(typeName, null, sort, orderByFields, sortSQL);
                    }
                    if (!orderByFields.contains(idSQL.toString())) {
                        sortSQL.append(idSQL);
                    }
                    for (String orderBy : orderByFields) {
                        if (idSQL.toString().equals(orderBy)) continue;
                        topIds.append(", ").append(orderBy);
                    }
                    topIds.append(" FROM ");
                    this.getDataStore().encodeTableName(typeName, topIds, query.getHints());
                    this.encodeMultipleValueJoin(query.getRootMapping(), typeName, this.getDataStore(), topIds);
                    if (filter != null) {
                        if (NestedFilterToSQL.isNestedFilter(filter)) {
                            filterToSQL.setFieldEncoder((FilterToSQL.FieldEncoder)new JoiningFieldEncoder(typeName, this.getDataStore()));
                            topIds.append(" WHERE ").append(this.createNestedFilter(filter, query, filterToSQL));
                        } else {
                            topIds.append(" ").append(filterToSQL.encodeToString(filter));
                        }
                    }
                    topIds.append(" ORDER BY ");
                    topIds.append(sortSQL);
                    this.getDataStore().dialect.applyLimitOffset(topIds, maxFeatures, startIndex);
                    sql.append(topIds);
                    sql.append(") ");
                    String newAlias = JoiningJDBCFeatureSource.createAlias(typeName, tableNames);
                    tableNames.add(newAlias);
                    this.getDataStore().dialect.encodeTableName(newAlias, sql);
                    sql.append(" ON (");
                    this.getDataStore().dialect.encodeColumnName(alias, string, sql);
                    sql.append(" = ");
                    this.getDataStore().dialect.encodeColumnName(newAlias, string, sql);
                    sql.append(" ) ");
                }
            }
        }
        if (!ids.isEmpty()) {
            if (allIds != null) {
                allIds.addAll(ids);
            }
            return true;
        }
        return false;
    }

    protected PreparedStatement selectSQLPS(SimpleFeatureType featureType, JoiningQuery query, Connection cx) throws SQLException, IOException, FilterToSQLException {
        AtomicReference<PreparedFilterToSQL> toSQLref = new AtomicReference<PreparedFilterToSQL>();
        String sql = this.selectSQL(featureType, query, toSQLref);
        LOGGER.fine(sql);
        PreparedStatement ps = cx.prepareStatement(sql, 1003, 1007);
        ps.setFetchSize(this.getDataStore().fetchSize);
        if (toSQLref.get() != null) {
            this.getDataStore().setPreparedFilterValues(ps, toSQLref.get(), 0, cx);
        }
        return ps;
    }

    protected Filter[] splitFilter(Filter original) {
        Filter[] split = new Filter[2];
        if (original != null) {
            PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(this.getDataStore().getFilterCapabilities(), null, null);
            original.accept((FilterVisitor)splitter, null);
            split[0] = splitter.getFilterPre();
            split[1] = splitter.getFilterPost();
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor(){

            public Object visit(PropertyName propertyName, Object extraData) {
                if (propertyName instanceof JoinPropertyName) {
                    JoinPropertyName joinPropertyName = (JoinPropertyName)propertyName;
                    return new JoinPropertyName(joinPropertyName.getFeatureType(), joinPropertyName.getAlias(), joinPropertyName.getPropertyName());
                }
                return super.visit(propertyName, extraData);
            }
        };
        visitor.setFIDValidator((SimplifyingFilterVisitor.FIDValidator)new PrimaryKeyFIDValidator((JDBCFeatureSource)this));
        split[0] = (Filter)split[0].accept((FilterVisitor)visitor, null);
        split[1] = (Filter)split[1].accept((FilterVisitor)visitor, null);
        return split;
    }

    protected SimpleFeatureType getFeatureType(SimpleFeatureType origType, JoiningQuery query) throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(origType);
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        if (query.getQueryJoins() != null) {
            for (int i = 0; i < query.getQueryJoins().size(); ++i) {
                if (query.getQueryJoins().get(i).getIds().isEmpty()) {
                    PrimaryKey joinKey = null;
                    String joinTypeName = query.getQueryJoins().get(i).getJoiningTypeName();
                    SimpleFeatureType joinFeatureType = this.getDataStore().getSchema(joinTypeName);
                    try {
                        joinKey = this.getDataStore().getPrimaryKey(joinFeatureType);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    int j = 0;
                    for (PrimaryKeyColumn col : joinKey.getColumns()) {
                        query.getQueryJoins().get(i).addId(col.getName());
                        ab.setBinding(String.class);
                        builder.add(ab.buildDescriptor(String.valueOf(new NameImpl(FOREIGN_ID)) + "_" + i + "_" + j, ab.buildType()));
                        ++j;
                    }
                    continue;
                }
                for (int j = 0; j < query.getQueryJoins().get(i).getIds().size(); ++j) {
                    ab.setBinding(String.class);
                    builder.add(ab.buildDescriptor(String.valueOf(new NameImpl(FOREIGN_ID)) + "_" + i + "_" + j, ab.buildType()));
                }
            }
        }
        if (!query.hasIdColumn()) {
            PrimaryKey key = null;
            try {
                key = this.getDataStore().getPrimaryKey(origType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < key.getColumns().size(); ++j) {
                ab.setBinding(String.class);
                builder.add(ab.buildDescriptor("PARENT_TABLE_PKEY_" + j, ab.buildType()));
            }
        }
        return builder.buildFeatureType();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getJoiningReaderInternal(JoiningQuery query) throws IOException {
        JDBCFeatureReader reader;
        Filter[] split = this.splitFilter(query.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            throw new IllegalArgumentException("Postfilters not allowed in Joining Queries");
        }
        JoiningQuery preQuery = new JoiningQuery(query);
        preQuery.setFilter(preFilter);
        preQuery.setRootMapping(query.getRootMapping());
        SimpleFeatureType querySchema = query.getPropertyNames() == Query.ALL_NAMES ? this.getSchema() : SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])query.getPropertyNames());
        SimpleFeatureType fullSchema = query.hasIdColumn() && query.getQueryJoins() == null ? querySchema : this.getFeatureType(querySchema, query);
        JDBCDataStore store = this.getDataStore();
        Connection cx = store.getConnection(this.getState().getTransaction());
        try {
            SQLDialect dialect;
            if (this.getState().getTransaction() == Transaction.AUTO_COMMIT) {
                cx.setAutoCommit(false);
            }
            if ((dialect = store.getSQLDialect()) instanceof PreparedStatementSQLDialect) {
                PreparedStatement ps = this.selectSQLPS(querySchema, preQuery, cx);
                reader = new JDBCFeatureReader(ps, cx, (JDBCFeatureSource)this, fullSchema, (Query)query);
            } else {
                String sql = this.selectSQL(querySchema, preQuery, null);
                store.getLogger().fine(sql);
                reader = new JDBCFeatureReader(sql, cx, (JDBCFeatureSource)this, fullSchema, (Query)query);
            }
        }
        catch (Exception e) {
            store.closeSafe(cx);
            throw (IOException)new IOException().initCause(e);
        }
        return reader;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getJoiningReaderInternal(JdbcMultipleValue mv, JoiningQuery query) throws IOException {
        JDBCFeatureReader reader;
        Filter[] split = this.splitFilter(query.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            throw new IllegalArgumentException("Postfilters not allowed in Joining Queries");
        }
        JoiningQuery preQuery = new JoiningQuery(query);
        preQuery.setFilter(preFilter);
        preQuery.setRootMapping(query.getRootMapping());
        SimpleFeatureType querySchema = query.getPropertyNames() == Query.ALL_NAMES ? this.getSchema() : SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])query.getPropertyNames());
        JDBCDataStore store = this.getDataStore();
        Connection cx = store.getConnection(this.getState().getTransaction());
        try {
            if (this.getState().getTransaction() == Transaction.AUTO_COMMIT) {
                cx.setAutoCommit(false);
            }
            String sql = this.selectSQL(querySchema, preQuery, null);
            store.getLogger().fine(sql);
            StringBuffer finalSql = new StringBuffer();
            finalSql.append("SELECT ");
            SimpleFeatureType featureType = store.getSchema(mv.getTargetTable());
            PrimaryKey primaryKeys = store.getPrimaryKey(featureType);
            ArrayList<String> pkNames = new ArrayList<String>();
            for (PrimaryKeyColumn primaryKey : primaryKeys.getColumns()) {
                String pkName = primaryKey.getName();
                pkNames.add(pkName);
                this.encodeColumnName(finalSql, mv.getTargetTable(), pkName);
                finalSql.append(", ");
            }
            for (String property : mv.getProperties()) {
                if (pkNames.contains(property)) continue;
                this.encodeColumnName(finalSql, mv.getTargetTable(), property);
                finalSql.append(", ");
            }
            finalSql.delete(finalSql.length() - 2, finalSql.length());
            FilterToSQL cfToSql = this.createFilterToSQL(store.getSchema(mv.getTargetTable()));
            cfToSql.setFieldEncoder(field -> {
                StringBuffer fieldSql = new StringBuffer();
                store.dialect.encodeTableName(mv.getTargetTable(), fieldSql);
                fieldSql.append(".");
                fieldSql.append(field);
                return fieldSql.toString();
            });
            finalSql.append(" FROM ");
            store.encodeTableName(mv.getTargetTable(), finalSql, null);
            finalSql.append(" INNER JOIN (").append(sql).append(") ");
            store.dialect.encodeTableName("mv", finalSql);
            finalSql.append(" ON ");
            store.dialect.encodeTableName("mv", finalSql);
            finalSql.append(".");
            store.dialect.encodeColumnName(null, mv.getSourceColumn(), finalSql);
            finalSql.append(" = ");
            store.encodeTableName(mv.getTargetTable(), finalSql, null);
            finalSql.append(".");
            store.dialect.encodeColumnName(null, mv.getTargetColumn(), finalSql);
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName((Name)new NameImpl(null, mv.getTargetTable()));
            b.add("id", Object.class);
            b.add("value", Object.class);
            JoiningQuery jdbcQuery = new JoiningQuery(query);
            jdbcQuery.setPropertyNames(mv.getProperties());
            SimpleFeatureType featrueType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)store.getSchema(mv.getTargetTable()), (String[])jdbcQuery.getPropertyNames());
            reader = new JDBCFeatureReader(finalSql.toString(), cx, (JDBCFeatureSource)this, featrueType, (Query)jdbcQuery);
        }
        catch (Exception e) {
            store.closeSafe(cx);
            throw (IOException)new IOException().initCause(e);
        }
        return reader;
    }

    private void encodeColumnName(StringBuffer sql, String tableName, String columnName) {
        JDBCDataStore dataStore = this.getDataStore();
        SQLDialect dialect = dataStore.getSQLDialect();
        String schema = dataStore.getDatabaseSchema();
        if (schema != null) {
            dialect.encodeSchemaName(schema, sql);
            sql.append(".");
        }
        dialect.encodeColumnName(tableName, columnName, sql);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        if (query instanceof JoiningQuery) {
            return this.getJoiningReaderInternal((JoiningQuery)query);
        }
        return super.getReaderInternal(query);
    }

    protected Query resolvePropertyNames(Query query) {
        if (query instanceof JoiningQuery) {
            return query;
        }
        return super.resolvePropertyNames(query);
    }

    protected Query joinQuery(Query query) {
        if (this.query == null) {
            return query;
        }
        if (query instanceof JoiningQuery) {
            JoiningQuery jQuery = new JoiningQuery(super.joinQuery(query));
            for (String id : ((JoiningQuery)query).getIds()) {
                jQuery.addId(id);
            }
            jQuery.setQueryJoins(((JoiningQuery)query).getQueryJoins());
            return jQuery;
        }
        return super.joinQuery(query);
    }

    protected Filter aliasFilter(Filter filter, SimpleFeatureType featureType, String alias) {
        JoinInfo.JoinQualifier jq = new JoinInfo.JoinQualifier(featureType, alias);
        Filter resultFilter = (Filter)filter.accept((FilterVisitor)jq, null);
        return resultFilter;
    }

    protected boolean isPostgisDialect() {
        String dialectClassName = this.getDataStore().getSQLDialect().getClass().getName();
        return "org.geotools.data.postgis.PostGISDialect".equals(dialectClassName) || "org.geotools.data.postgis.PostGISPSDialect".equals(dialectClassName);
    }

    protected boolean isOrUnionReplacementEnabled() {
        return AppSchemaDataAccessConfigurator.isOrUnionReplacementEnabled();
    }

    protected int getCountInternal(Query query) throws IOException {
        int n;
        Set<String> idColumnNames = this.getIdColumnNames(this.getSchema());
        JoiningQuery jQuery = (JoiningQuery)query;
        MultipleValueExtractor extractor = new MultipleValueExtractor();
        jQuery.getRootMapping().getFeatureIdExpression().accept((ExpressionVisitor)extractor, null);
        HashSet<String> idMapping = new HashSet<String>();
        Collections.addAll(idMapping, extractor.getAttributeNames());
        boolean idsColumnEquals = idColumnNames.equals(idMapping);
        Filter filter = jQuery.getFilter();
        filter.accept((FilterVisitor)extractor, null);
        boolean isNestedFilter = this.isJoinRequired(filter, extractor.getMultipleValues(), extractor.getPropertyNameSet());
        if (idsColumnEquals && !isNestedFilter) {
            return super.getCountInternal(query);
        }
        if (!idsColumnEquals && !idMapping.isEmpty()) {
            idColumnNames = idMapping;
        }
        SimpleFeatureType querySchema = this.getSchema();
        JDBCDataStore store = this.getDataStore();
        Connection cx = store.getConnection(this.getState().getTransaction());
        Statement st = null;
        ResultSet rs = null;
        try {
            int maxFeatures;
            SQLDialect dialect = store.getSQLDialect();
            if (dialect instanceof PreparedStatementSQLDialect) {
                AtomicReference<PreparedFilterToSQL> toSQLref = new AtomicReference<PreparedFilterToSQL>();
                String sql = !isNestedFilter ? this.createCountQuery(dialect, querySchema, jQuery, idColumnNames, toSQLref) : this.createJoiningCountQuery(dialect, querySchema, jQuery, idColumnNames, toSQLref);
                st = cx.prepareStatement(sql, 1003, 1007);
                st.setFetchSize(this.getDataStore().fetchSize);
                if (toSQLref.get() != null && toSQLref.get().getLiteralValues() != null) {
                    this.getDataStore().setPreparedFilterValues((PreparedStatement)st, toSQLref.get(), 0, cx);
                }
                rs = ((PreparedStatement)st).executeQuery();
            } else {
                String sql = !isNestedFilter ? this.createCountQuery(dialect, querySchema, jQuery, idColumnNames, null) : this.createJoiningCountQuery(dialect, querySchema, jQuery, idColumnNames, null);
                st = cx.createStatement();
                rs = st.executeQuery(sql);
            }
            int result = 0;
            if (rs.next()) {
                Object value = rs.getObject(1);
                result = (Integer)Converters.convert((Object)value, Integer.class);
            }
            if ((maxFeatures = query.getMaxFeatures()) > 0 && result > maxFeatures) {
                result = query.getMaxFeatures();
            }
            n = result;
        }
        catch (Exception e) {
            try {
                throw (IOException)new IOException().initCause(e);
            }
            catch (Throwable throwable) {
                store.closeSafe(rs);
                store.closeSafe(st);
                store.closeSafe(cx);
                throw throwable;
            }
        }
        store.closeSafe(rs);
        store.closeSafe(st);
        store.closeSafe(cx);
        return n;
    }

    String createCountQuery(SQLDialect dialect, SimpleFeatureType querySchema, JoiningQuery query, Set<String> idColumnNames, AtomicReference<PreparedFilterToSQL> toSQLRef) throws FilterToSQLException, SQLException {
        StringBuffer countSQL = new StringBuffer("SELECT COUNT(*) FROM (SELECT DISTINCT ");
        boolean first = true;
        for (String idColumnName : idColumnNames) {
            if (!first) {
                countSQL.append(", ");
            }
            this.getDataStore().encodeTableName(querySchema.getTypeName(), countSQL, query.getHints());
            countSQL.append(".");
            dialect.encodeColumnName(null, idColumnName, countSQL);
            first = false;
        }
        countSQL.append(" FROM ");
        this.getDataStore().encodeTableName(querySchema.getTypeName(), countSQL, query.getHints());
        if (!query.getFilter().equals(Filter.INCLUDE)) {
            countSQL.append(" ");
            FilterToSQL toSql = this.createFilterToSQL(querySchema);
            countSQL.append(toSql.encodeToString(query.getFilter()));
            if (toSql instanceof PreparedFilterToSQL) {
                toSQLRef.set((PreparedFilterToSQL)toSql);
            }
        }
        countSQL.append(")");
        dialect.encodeTableName(DISTINCT_TABLE_ALIAS, countSQL);
        String countQuery = countSQL.toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(countQuery);
        }
        return countQuery;
    }

    private String createJoiningCountQuery(SQLDialect dialect, SimpleFeatureType querySchema, JoiningQuery query, Set<String> idColumnNames, AtomicReference<PreparedFilterToSQL> toSQLRef) throws IOException, SQLException, FilterToSQLException {
        StringBuffer countSQL = new StringBuffer("SELECT COUNT(*) FROM (SELECT DISTINCT ");
        boolean first = true;
        for (String idColumnName : idColumnNames) {
            if (!first) {
                countSQL.append(", ");
            }
            dialect.encodeColumnName(COUNT_TABLE_ALIAS, idColumnName, countSQL);
            first = false;
        }
        countSQL.append(" FROM (");
        String sql = this.selectSQL(querySchema, query, toSQLRef, true);
        countSQL.append(sql).append(") ");
        dialect.encodeTableName(COUNT_TABLE_ALIAS, countSQL);
        countSQL.append(") ");
        dialect.encodeTableName(DISTINCT_TABLE_ALIAS, countSQL);
        String countQuery = countSQL.toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(countQuery);
        }
        return countQuery;
    }

    private Set<String> getIdColumnNames(SimpleFeatureType featureType) throws IOException {
        HashSet<String> columnNames = new HashSet<String>();
        for (PrimaryKeyColumn column : this.getDataStore().getPrimaryKey(featureType).getColumns()) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }

    private Set<String> getAllPrimaryKeys(SimpleFeatureType featureType) {
        PrimaryKey key = null;
        try {
            key = this.getDataStore().getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> pkColumnNames = new HashSet<String>();
        for (PrimaryKeyColumn col : key.getColumns()) {
            pkColumnNames.add(col.getName());
        }
        return pkColumnNames;
    }

    private boolean isJoinRequired(Filter filter, List<MultipleValue> multipleValues, Set<PropertyName> propertyNameSet) {
        return NestedFilterToSQL.isNestedFilter(filter) || !multipleValues.isEmpty() || propertyNameSet.stream().anyMatch(p -> p instanceof JoinPropertyName);
    }

    public static class JoiningFieldEncoder
    implements FilterToSQL.FieldEncoder {
        private String tableName;
        private JDBCDataStore store;

        public JoiningFieldEncoder(String tableName, JDBCDataStore store) {
            this.tableName = tableName;
            this.store = store;
        }

        public String encode(String s) {
            StringBuffer buf = new StringBuffer();
            this.store.dialect.encodeTableName(this.tableName, buf);
            buf.append(".");
            buf.append(s);
            return buf.toString();
        }
    }
}

