/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.Parameter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ToDirectPositionFunction
implements Function {
    private final List<Expression> parameters;
    private final Literal fallback;
    private static final String USAGE = "Usage: toDirectPosition('SRS_NAME'(optional), srsName(optional), point 1, point 2(optional))";
    public static final FunctionName NAME = new FunctionNameImpl("toDirectPosition", FunctionNameImpl.parameter((String)"return", DirectPosition.class), new Parameter[]{FunctionNameImpl.parameter((String)"parameter", Object.class, (int)1, (int)4)});
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    public static final Expression SRS_NAME = ff.literal((Object)"SRS_NAME");

    public ToDirectPositionFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public ToDirectPositionFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, DirectPosition.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        DirectPosition1D geom;
        Expression param1 = this.parameters.get(0);
        CoordinateReferenceSystem crs = null;
        if (param1.equals(SRS_NAME)) {
            if (this.parameters.size() < 3 || this.parameters.size() > 4) {
                throw new IllegalArgumentException("Wrong number of parameters toDirectPosition function: " + this.parameters.toString() + ". Usage: toDirectPosition('SRS_NAME'(optional), srsName(optional), point 1, point 2(optional))");
            }
            String srsName = (String)this.parameters.get(1).evaluate(object, String.class);
            try {
                crs = CRS.decode((String)srsName);
            }
            catch (NoSuchAuthorityCodeException e) {
                throw new IllegalArgumentException("Invalid or unsupported SRS name detected for toDirectPosition function: " + srsName + ". Cause: " + e.getMessage());
            }
            catch (FactoryException e) {
                throw new RuntimeException("Unable to decode SRS name. Cause: " + e.getMessage());
            }
            if (this.parameters.size() == 3) {
                geom = new DirectPosition1D(crs);
            } else {
                geom = new DirectPosition2D(crs);
                geom.setOrdinate(1, ((Double)this.parameters.get(3).evaluate(object, Double.class)).doubleValue());
            }
            geom.setOrdinate(0, ((Double)this.parameters.get(2).evaluate(object, Double.class)).doubleValue());
        } else {
            if (this.parameters.size() > 2) {
                throw new IllegalArgumentException("Too many parameters for toDirectPosition function: " + this.parameters.toString() + ". Usage: toDirectPosition('SRS_NAME'(optional), srsName(optional), point 1, point 2(optional))");
            }
            if (this.parameters.size() == 1) {
                geom = new DirectPosition1D();
            } else {
                geom = new DirectPosition2D();
                geom.setOrdinate(1, ((Double)this.parameters.get(1).evaluate(object, Double.class)).doubleValue());
            }
            geom.setOrdinate(0, ((Double)param1.evaluate(object, Double.class)).doubleValue());
        }
        return (T)geom;
    }
}

