/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.util.Stopwatch;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class PolymorphicChainingTest
extends AppSchemaTestSupport {
    static final String EX_NS = "urn:example:xmlns:ArtifactML:1.0";
    static final Name ARTIFACT = Types.typeName((String)"urn:example:xmlns:ArtifactML:1.0", (String)"Artifact");
    static FilterFactory2 ff;
    private static final String schemaBase = "/test-data/";
    private static FeatureSource<FeatureType, Feature> artifactSource;
    private NamespaceSupport namespaces = new NamespaceSupport();

    public PolymorphicChainingTest() {
        this.namespaces.declarePrefix("ex", EX_NS);
        ff = new FilterFactoryImplNamespaceAware(this.namespaces);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Stopwatch sw = new Stopwatch();
        sw.start();
        PolymorphicChainingTest.loadDataAccesses();
        sw.stop();
    }

    @Test
    public void testSimpleFilter() throws Exception {
        PropertyName property = ff.property("ex:seqId");
        PropertyIsEqualTo filter = ff.equals((Expression)property, (Expression)ff.literal(101));
        FeatureCollection filteredResults = artifactSource.getFeatures((Filter)filter);
        List<Feature> retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)1L, (long)retVal.size());
        Feature feature = retVal.get(0);
        PolymorphicChainingTest.assertId("a.101", feature);
    }

    @Test
    public void testMultiMappedFilter() throws Exception {
        PropertyName property = ff.property("ex:attributes/ex:Attribute/ex:key", this.namespaces);
        PropertyIsEqualTo filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"stringKey1"));
        FeatureCollection filteredResults = artifactSource.getFeatures((Filter)filter);
        List<Feature> retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)0L, (long)retVal.size());
        property = ff.property("ex:attributes/ex:StringAttribute/ex:key", this.namespaces);
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"stringKey1"));
        filteredResults = artifactSource.getFeatures((Filter)filter);
        retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)2L, (long)retVal.size());
        Feature feature = retVal.get(0);
        PolymorphicChainingTest.assertId("a.101", feature);
        feature = retVal.get(1);
        PolymorphicChainingTest.assertId("a.102", feature);
        property = ff.property("ex:attributes/ex:GeoAttribute/ex:key", this.namespaces);
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"stringKey1"));
        filteredResults = artifactSource.getFeatures((Filter)filter);
        retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)0L, (long)retVal.size());
        property = ff.property("ex:attributes/ex:key");
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"stringKey1"));
        filteredResults = artifactSource.getFeatures((Filter)filter);
        retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)0L, (long)retVal.size());
    }

    protected static void assertId(String expected, Feature f) {
        String actual = f.getIdentifier().toString();
        Assert.assertEquals((String)("Incorrect id: " + actual), (Object)expected, (Object)actual);
    }

    private static void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = PolymorphicChainingTest.class.getResource("/test-data/artifact_mapping.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureType mappedFeatureType = mfDataAccess.getSchema(ARTIFACT);
        Assert.assertNotNull((Object)mappedFeatureType);
        artifactSource = mfDataAccess.getFeatureSource(ARTIFACT);
    }

    protected List<Feature> getFeatures(FeatureCollection<FeatureType, Feature> features) {
        try (FeatureIterator iterator = features.features();){
            ArrayList<Feature> retVal = new ArrayList<Feature>();
            while (iterator.hasNext()) {
                retVal.add(iterator.next());
            }
            ArrayList<Feature> arrayList = retVal;
            return arrayList;
        }
    }
}

