/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.net.URL;
import java.util.HashMap;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.complex.AbstractHiddenDataAccessDisposalTest;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureChainingTest;
import org.geotools.feature.NameImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.type.Name;

public class HiddenDataAccessDisposalTest
extends AbstractHiddenDataAccessDisposalTest {
    static final Name EXPOSURE_COLOR = new NameImpl("exposureColor");
    private static final String schemaBase = "/test-data/";
    AppSchemaDataAccess mfDataAccess;

    @Before
    public void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        this.mfDataAccess = (AppSchemaDataAccess)DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)this.mfDataAccess);
        Assert.assertNotNull((Object)this.mfDataAccess.getSchema(FeatureChainingTest.MAPPED_FEATURE));
        Assert.assertFalse((boolean)this.mfDataAccess.hidden);
        this.loadGeologicUnit();
        Assert.assertEquals((long)5L, (long)DataAccessRegistry.getInstance().registry.size());
    }

    @Test
    public void testDisposeGeologicUnitDataAccess() {
        this.guDataAccess.dispose();
        Assert.assertEquals((long)1L, (long)DataAccessRegistry.getInstance().registry.size());
    }

    @Test
    public void testDisposeMappedFeatureDataAccess() {
        this.mfDataAccess.dispose();
        Assert.assertEquals((long)4L, (long)DataAccessRegistry.getInstance().registry.size());
        this.guDataAccess.dispose();
        Assert.assertEquals((long)0L, (long)DataAccessRegistry.getInstance().registry.size());
    }

    @After
    public void cleanUp() {
        DataAccessRegistry.unregisterAndDisposeAll();
        Assert.assertEquals((long)0L, (long)DataAccessRegistry.getInstance().registry.size());
    }
}

