/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.AppSchemaFeatureTypeRegistry;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeImpl;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.EmfComplexFeatureReader;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.SchemaIndex;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class BoreholeTest
extends AppSchemaTestSupport {
    private static final Logger LOGGER = Logging.getLogger(BoreholeTest.class);
    private static final String XMMLNS = "http://www.opengis.net/xmml";
    private static final String SANS = "http://www.seegrid.csiro.au/xml/sampling";
    private static final String OMNS = "http://www.opengis.net/om";
    private static final String SWENS = "http://www.opengis.net/swe/0.0";
    private static final String GMLNS = "http://www.opengis.net/gml";
    private static final String GEONS = "http://www.seegrid.csiro.au/xml/geometry";
    private static final String schemaBase = "/test-data/";
    final Name typeName = new NameImpl("http://www.opengis.net/xmml", "Borehole");
    private static EmfComplexFeatureReader reader;
    private FeatureSource source;
    private static DataAccess<FeatureType, Feature> mappingDataStore;

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = BoreholeTest.class.getResource("/test-data/BoreholeTest_properties.xml");
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mappingDataStore = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull(mappingDataStore);
        reader = EmfComplexFeatureReader.newInstance();
    }

    private SchemaIndex loadSchema(String location) throws IOException {
        URL schemaLocation = this.getClass().getResource(location);
        Assert.assertNotNull((String)location, (Object)schemaLocation);
        return reader.parse(schemaLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseBoreholeSchema() throws Exception {
        SchemaIndex schemaIndex;
        try {
            schemaIndex = this.loadSchema("/test-data/commonSchemas/XMML/1/borehole.xsd");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            throw e;
        }
        AppSchemaFeatureTypeRegistry typeRegistry = new AppSchemaFeatureTypeRegistry();
        try {
            typeRegistry.addSchemas(schemaIndex);
            Name typeName = Types.typeName((String)XMMLNS, (String)"BoreholeType");
            ComplexFeatureTypeImpl borehole = (ComplexFeatureTypeImpl)typeRegistry.getAttributeType(typeName);
            Assert.assertNotNull((Object)borehole);
            Assert.assertTrue((boolean)(borehole instanceof FeatureType));
            AttributeType superType = borehole.getSuper();
            Assert.assertNotNull((Object)superType);
            Name superTypeName = Types.typeName((String)SANS, (String)"ProfileType");
            Assert.assertEquals((Object)superTypeName, (Object)superType.getName());
            Assert.assertTrue((boolean)(superType instanceof FeatureType));
            Collection properties = borehole.getTypeDescriptors();
            Assert.assertEquals((long)16L, (long)properties.size());
            HashMap<Name, Name> expectedNamesAndTypes = new HashMap<Name, Name>();
            expectedNamesAndTypes.put(this.name(GMLNS, "metaDataProperty"), this.typeName(GMLNS, "MetaDataPropertyType"));
            expectedNamesAndTypes.put(this.name(GMLNS, "description"), this.typeName(GMLNS, "StringOrRefType"));
            expectedNamesAndTypes.put(this.name(GMLNS, "name"), this.typeName(GMLNS, "CodeType"));
            expectedNamesAndTypes.put(this.name(GMLNS, "boundedBy"), this.typeName(GMLNS, "BoundingShapeType"));
            expectedNamesAndTypes.put(this.name(GMLNS, "location"), this.typeName(GMLNS, "LocationPropertyType"));
            expectedNamesAndTypes.put(this.name(SANS, "begin"), this.typeName(GMLNS, "PointPropertyType"));
            expectedNamesAndTypes.put(this.name(SANS, "end"), this.typeName(GMLNS, "PointPropertyType"));
            expectedNamesAndTypes.put(this.name(SANS, "length"), this.typeName(SWENS, "RelativeMeasureType"));
            expectedNamesAndTypes.put(this.name(SANS, "shape"), this.typeName(GEONS, "Shape1DPropertyType"));
            expectedNamesAndTypes.put(this.name(SANS, "member"), this.typeName(SANS, "SamplingFeaturePropertyType"));
            expectedNamesAndTypes.put(this.name(SANS, "surveyDetails"), this.typeName(SANS, "SurveyProcedurePropertyType"));
            expectedNamesAndTypes.put(this.name(SANS, "associatedSpecimen"), this.typeName(SANS, "SpecimenPropertyType"));
            expectedNamesAndTypes.put(this.name(SANS, "relatedObservation"), this.typeName(OMNS, "AbstractObservationPropertyType"));
            expectedNamesAndTypes.put(this.name(XMMLNS, "drillMethod"), this.typeName(XMMLNS, "drillCode"));
            expectedNamesAndTypes.put(this.name(XMMLNS, "collarDiameter"), this.typeName(GMLNS, "MeasureType"));
            expectedNamesAndTypes.put(this.name(XMMLNS, "log"), this.typeName(XMMLNS, "LogPropertyType"));
            Iterator iterator = expectedNamesAndTypes.entrySet().iterator();
            while (iterator.hasNext()) {
                AttributeType type;
                Map.Entry nameNameEntry;
                Map.Entry entry = nameNameEntry = iterator.next();
                Name dName = (Name)entry.getKey();
                Name tName = (Name)entry.getValue();
                AttributeDescriptor d = (AttributeDescriptor)Types.descriptor((ComplexType)borehole, (Name)dName);
                Assert.assertNotNull((String)("Descriptor not found: " + String.valueOf(dName)), (Object)d);
                try {
                    type = d.getType();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "type not parsed for " + String.valueOf(d.getName()), e);
                    throw e;
                }
                Assert.assertNotNull((Object)type);
                Assert.assertNotNull((Object)type.getName());
                Assert.assertNotNull((Object)type.getBinding());
                if (tName == null) continue;
                Assert.assertEquals((Object)tName, (Object)type.getName());
            }
            Name tcl = Types.typeName((String)SWENS, (String)"TypedCategoryListType");
            AttributeType typedCategoryListType = typeRegistry.getAttributeType(tcl);
            Assert.assertNotNull((Object)typedCategoryListType);
            Assert.assertTrue((boolean)(typedCategoryListType instanceof ComplexType));
        }
        finally {
            typeRegistry.disposeSchemaIndexes();
        }
    }

    private Name typeName(String ns, String localName) {
        return Types.typeName((String)ns, (String)localName);
    }

    private Name name(String ns, String localName) {
        return new NameImpl(ns, localName);
    }

    @Test
    public void testLoadMappingsConfig() throws Exception {
        XMLConfigDigester reader = new XMLConfigDigester();
        URL url = this.getClass().getResource("/test-data/BoreholeTest_properties.xml");
        AppSchemaDataAccessDTO config = reader.parse(url);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)1L, (long)mappings.size());
        FeatureTypeMapping mapping = (FeatureTypeMapping)mappings.iterator().next();
        AttributeDescriptor targetFeature = mapping.getTargetFeature();
        Assert.assertNotNull((Object)targetFeature);
        Assert.assertNotNull((Object)targetFeature.getType());
        Assert.assertEquals((Object)XMMLNS, (Object)targetFeature.getName().getNamespaceURI());
        Assert.assertEquals((Object)"Borehole", (Object)targetFeature.getName().getLocalPart());
        this.source = mapping.getSource();
        Assert.assertNotNull((Object)this.source);
        FeatureType schema = this.source.getSchema();
        String typeName = schema.getName().toString();
        Assert.assertEquals((Object)"test-data:boreholes_denormalized", (Object)typeName);
        List attributeMappings = mapping.getAttributeMappings();
        Assert.assertEquals((long)24L, (long)attributeMappings.size());
        AttributeMapping attMapping = (AttributeMapping)attributeMappings.get(0);
        Assert.assertNotNull((Object)attMapping);
        XPathUtil.StepList targetXPath = attMapping.getTargetXPath();
        Assert.assertNotNull((Object)targetXPath);
        Assert.assertEquals((Object)"xmml:Borehole", (Object)targetXPath.toString());
        Expression idExpression = attMapping.getIdentifierExpression();
        Assert.assertNotNull((Object)idExpression);
        Assert.assertTrue((boolean)(idExpression instanceof Function));
        Function idFunction = (Function)idExpression;
        Assert.assertEquals((Object)"strConcat", (Object)idFunction.getName());
        Assert.assertTrue((boolean)(idFunction.getParameters().get(0) instanceof Literal));
        Assert.assertTrue((boolean)(idFunction.getParameters().get(1) instanceof PropertyName));
        Assert.assertEquals((Object)Expression.NIL, (Object)attMapping.getSourceExpression());
    }

    @Test
    public void testGetDataStore() throws Exception {
        Assert.assertNotNull((Object)mappingDataStore.getSchema(this.typeName));
    }

    @Test
    public void testDataStore() throws Exception {
        FeatureSource fSource = mappingDataStore.getFeatureSource(this.typeName);
        int EXPECTED_RESULT_COUNT = 20;
        FeatureCollection features = fSource.getFeatures();
        int resultCount = this.size((FeatureCollection<FeatureType, Feature>)features);
        String msg = "be sure difference in result count is not due to different dataset. Query used should be min_time_d = 'carnian'";
        Assert.assertEquals((String)msg, (long)20L, (long)resultCount);
        int count = 0;
        try (FeatureIterator it = features.features();){
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
        }
    }

    private int size(FeatureCollection<FeatureType, Feature> features) {
        int size = 0;
        try (FeatureIterator i = features.features();){
            while (i.hasNext()) {
                ++size;
                i.next();
            }
        }
        return size;
    }

    @Test
    public void testQueryXlinkProperty() throws Exception {
        FeatureSource fSource = mappingDataStore.getFeatureSource(this.typeName);
        String queryProperty = "sa:shape/geo:LineByVector/geo:origin/@xlink:href";
        String queryLiteral = "#bh.176909a.start";
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("sa", SANS);
        namespaces.declarePrefix("geo", GEONS);
        namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware(namespaces);
        PropertyName propertyName = ff.property("sa:shape/geo:LineByVector/geo:origin/@xlink:href");
        Literal literal = ff.literal((Object)"#bh.176909a.start");
        PropertyIsEqualTo filter = ff.equals((Expression)propertyName, (Expression)literal);
        FeatureCollection features = fSource.getFeatures((Filter)filter);
        int resultCount = this.size((FeatureCollection<FeatureType, Feature>)features);
        Assert.assertEquals((long)1L, (long)resultCount);
    }

    @Test
    public void testTraverseDeep() throws Exception {
        FeatureSource fSource = mappingDataStore.getFeatureSource(this.typeName);
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("sa", SANS);
        namespaces.declarePrefix("geo", GEONS);
        namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
        FeatureCollection features = fSource.getFeatures();
        Feature f = features.features().next();
        this.traverse((Attribute)f);
    }

    private void traverse(Attribute f) {
        Object value = f.getValue();
        if (f instanceof ComplexAttribute) {
            Collection values = (Collection)value;
            for (Object o : values) {
                Attribute att = (Attribute)o;
                Assert.assertNotNull((Object)att);
                this.traverse(att);
            }
        }
    }
}

