/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DefaultGeometryTest;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.Assert;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractStationsTest {
    protected static String STATIONS_SCHEMA_BASE;
    static final String STATIONS_NS = "http://www.stations.org/1.0";
    static final Name STATION_FEATURE_TYPE;
    static final Name STATION_FEATURE;
    static final Name STATION_WITH_MEASUREMENTS_CODE_FEATURE;
    static final Name STATION_NO_DEFAULT_GEOM_MAPPING;
    static final Name STATION_MULTIPLE_GEOM_MAPPING;
    static final Name STATION_WITH_MEASUREMENTS_FEATURE_TYPE;
    static final Name STATION_WITH_MEASUREMENTS_FEATURE;
    static final Name STATION_WITH_GEOM_FEATURE_TYPE;
    static final Name STATION_WITH_GEOM_FEATURE;
    static final Name STATION_DEFAULT_GEOM_OVERRIDE_MAPPING;
    static final String MEASUREMENTS_NS = "http://www.measurements.org/1.0";
    static final Name MEASUREMENT_FEATURE_TYPE;
    static final Name MEASUREMENT_FEATURE;
    static final Name MEASUREMENT_CODE_FEATURE;
    static final Name MEASUREMENT_MANY_TO_ONE_MAPPING;
    static FilterFactory2 ff;
    WKTWriter writer = new WKTWriter();
    NamespaceSupport namespaces = new NamespaceSupport();
    static AppSchemaDataAccess stationsDataAccess;
    static AppSchemaDataAccess measurementsDataAccess;
    protected static final XPath XPATH;

    public AbstractStationsTest() {
        this.namespaces.declarePrefix("st", STATIONS_NS);
        this.namespaces.declarePrefix("ms", MEASUREMENTS_NS);
        ff = new FilterFactoryImplNamespaceAware(this.namespaces);
    }

    protected static AppSchemaDataAccess loadDataAccess(String mappingFile) throws IOException {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = DefaultGeometryTest.class.getResource(STATIONS_SCHEMA_BASE + mappingFile);
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        Assert.assertTrue((boolean)(dataAccess instanceof AppSchemaDataAccess));
        return (AppSchemaDataAccess)dataAccess;
    }

    protected static void loadDataAccesses() throws Exception {
        measurementsDataAccess = AbstractStationsTest.loadDataAccess("measurementsDefaultGeometry.xml");
        stationsDataAccess = AbstractStationsTest.loadDataAccess("stationsDefaultGeometry.xml");
        FeatureType ft = stationsDataAccess.getSchema(STATION_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)STATION_FEATURE_TYPE, (Object)ft.getName());
        Assert.assertNotNull((Object)stationsDataAccess.getSchema(STATION_NO_DEFAULT_GEOM_MAPPING));
        Assert.assertNotNull((Object)stationsDataAccess.getSchema(STATION_MULTIPLE_GEOM_MAPPING));
        ft = stationsDataAccess.getSchema(STATION_WITH_MEASUREMENTS_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)STATION_WITH_MEASUREMENTS_FEATURE_TYPE, (Object)ft.getName());
        ft = stationsDataAccess.getSchema(STATION_WITH_GEOM_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)STATION_WITH_GEOM_FEATURE_TYPE, (Object)ft.getName());
        Assert.assertNotNull((Object)stationsDataAccess.getSchema(STATION_DEFAULT_GEOM_OVERRIDE_MAPPING));
        FeatureSource fs = stationsDataAccess.getFeatureSource(STATION_FEATURE);
        FeatureCollection stationFeatures = fs.getFeatures();
        Assert.assertEquals((long)3L, (long)AbstractStationsTest.size(stationFeatures));
        ft = measurementsDataAccess.getSchema(MEASUREMENT_FEATURE);
        Assert.assertNotNull((Object)ft);
        Assert.assertEquals((Object)MEASUREMENT_FEATURE_TYPE, (Object)ft.getName());
        Assert.assertNotNull((Object)measurementsDataAccess.getSchema(MEASUREMENT_MANY_TO_ONE_MAPPING));
        ft = measurementsDataAccess.getSchema(MEASUREMENT_CODE_FEATURE);
        Assert.assertNotNull((Object)ft);
    }

    protected static int size(FeatureCollection features) {
        int size = 0;
        try (FeatureIterator iterator = features.features();){
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            int n = size;
            return n;
        }
    }

    protected List<Element> getElementsFromDocumentUsingXpath(Document document, String xpathExpression) {
        try {
            NodeList nodes = (NodeList)XPATH.evaluate(xpathExpression, document, XPathConstants.NODESET);
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                elements.add((Element)node);
            }
            return elements;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected static XPath buildXPath() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new SimpleNamespaceContext());
        return xpath;
    }

    static {
        STATION_FEATURE_TYPE = Types.typeName((String)STATIONS_NS, (String)"StationType");
        STATION_FEATURE = Types.typeName((String)STATIONS_NS, (String)"Station");
        STATION_WITH_MEASUREMENTS_CODE_FEATURE = Types.typeName((String)STATIONS_NS, (String)"StationWithMeasurementCode");
        STATION_NO_DEFAULT_GEOM_MAPPING = Types.typeName((String)"stationsNoDefaultGeometry");
        STATION_MULTIPLE_GEOM_MAPPING = Types.typeName((String)"stationsMultipleGeometries");
        STATION_WITH_MEASUREMENTS_FEATURE_TYPE = Types.typeName((String)STATIONS_NS, (String)"StationWithMeasurementsType");
        STATION_WITH_MEASUREMENTS_FEATURE = Types.typeName((String)STATIONS_NS, (String)"StationWithMeasurements");
        STATION_WITH_GEOM_FEATURE_TYPE = Types.typeName((String)STATIONS_NS, (String)"StationWithGeometryPropertyType");
        STATION_WITH_GEOM_FEATURE = Types.typeName((String)STATIONS_NS, (String)"StationWithGeometryProperty");
        STATION_DEFAULT_GEOM_OVERRIDE_MAPPING = Types.typeName((String)"stationsDefaultGeometryOverride");
        MEASUREMENT_FEATURE_TYPE = Types.typeName((String)MEASUREMENTS_NS, (String)"MeasurementType");
        MEASUREMENT_FEATURE = Types.typeName((String)MEASUREMENTS_NS, (String)"Measurement");
        MEASUREMENT_CODE_FEATURE = Types.typeName((String)MEASUREMENTS_NS, (String)"MeasurementCode");
        MEASUREMENT_MANY_TO_ONE_MAPPING = Types.typeName((String)"measurementsManyToOne");
        XPATH = AbstractStationsTest.buildXPath();
    }

    static class SimpleNamespaceContext
    implements NamespaceContext {
        private Map<String, String> namespaces = new HashMap<String, String>();

        public SimpleNamespaceContext() {
            this.namespaces.put("gml", "http://www.opengis.net/gml");
            this.namespaces.put("xlink", "http://www.w3.org/1999/xlink");
            this.namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.namespaces.put("st", AbstractStationsTest.STATIONS_NS);
            this.namespaces.put("ms", AbstractStationsTest.MEASUREMENTS_NS);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

