/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.jdbc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.geotools.appschema.jdbc.JoiningJDBCFeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.data.oracle.OracleDialect;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.store.ContentEntry;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCState;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.SQLDialect;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class JoiningJDBCFeatureSourceTest {
    private FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    @Test
    public void testMultipleIds() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        SimpleFeatureType origType = builder.buildFeatureType();
        JoiningQuery query = new JoiningQuery();
        JoiningQuery.QueryJoin join = new JoiningQuery.QueryJoin();
        join.getIds().add("one");
        join.getIds().add("two");
        query.setQueryJoins(Collections.singletonList(join));
        JDBCDataStore mockStore = (JDBCDataStore)Mockito.mock(JDBCDataStore.class);
        ContentEntry mockEntry = (ContentEntry)Mockito.mock(ContentEntry.class);
        Mockito.when((Object)mockStore.getPrimaryKey(origType)).thenReturn((Object)new PrimaryKey(null, Collections.emptyList()));
        Mockito.when((Object)mockStore.getSQLDialect()).thenReturn((Object)new PostGISDialect(mockStore));
        Mockito.when((Object)mockEntry.getDataStore()).thenReturn((Object)mockStore);
        JoiningJDBCFeatureSource source = new JoiningJDBCFeatureSource(new JDBCFeatureSource(mockEntry, null));
        SimpleFeatureType type = source.getFeatureType(origType, query);
        Assert.assertNotNull((Object)type);
        Assert.assertEquals((Object)"FOREIGN_ID_0_0", (Object)type.getDescriptor(0).getName().getLocalPart());
        Assert.assertEquals((Object)"FOREIGN_ID_0_1", (Object)type.getDescriptor(1).getName().getLocalPart());
    }

    @Test
    public void testCountQuery() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.add("testAttr", String.class);
        SimpleFeatureType origType = builder.buildFeatureType();
        JoiningQuery query = new JoiningQuery();
        JoiningQuery.QueryJoin join = new JoiningQuery.QueryJoin();
        join.getIds().add("one");
        join.getIds().add("two");
        query.setQueryJoins(Collections.singletonList(join));
        query.setFilter((Filter)this.FF.equals((Expression)this.FF.property("testAttr"), (Expression)this.FF.literal((Object)"testValue")));
        JDBCDataStore store = new JDBCDataStore();
        OracleDialect dialect = new OracleDialect(store);
        store.setSQLDialect((SQLDialect)dialect);
        ContentEntry mockEntry = (ContentEntry)Mockito.mock(ContentEntry.class);
        Mockito.when((Object)mockEntry.getDataStore()).thenReturn((Object)store);
        JDBCState state = (JDBCState)Mockito.mock(JDBCState.class);
        Mockito.when((Object)mockEntry.getState((Transaction)Mockito.any(Transaction.class))).thenReturn((Object)state);
        Mockito.when((Object)state.getPrimaryKey()).thenReturn((Object)new PrimaryKey(null, Collections.emptyList()));
        JoiningJDBCFeatureSource source = (JoiningJDBCFeatureSource)Mockito.mock(JoiningJDBCFeatureSource.class);
        Mockito.when((Object)source.getEntry()).thenReturn((Object)mockEntry);
        Mockito.when((Object)source.createFilterToSQL(origType)).thenReturn((Object)new PreparedFilterToSQL((PreparedStatementSQLDialect)dialect));
        Mockito.when((Object)source.createFilterToSQL(origType, true)).thenReturn((Object)new PreparedFilterToSQL((PreparedStatementSQLDialect)dialect));
        Mockito.when((Object)source.getDataStore()).thenReturn((Object)store);
        HashSet<String> columns = new HashSet<String>(Arrays.asList("one", "two"));
        AtomicReference toSQLRef = new AtomicReference();
        ((JoiningJDBCFeatureSource)Mockito.doCallRealMethod().when((Object)source)).createCountQuery((SQLDialect)dialect, origType, query, columns, toSQLRef);
        String sql = source.createCountQuery((SQLDialect)dialect, origType, query, columns, toSQLRef);
        Assert.assertEquals((Object)"SELECT COUNT(*) FROM (SELECT DISTINCT TEST.ONE, TEST.TWO FROM TEST WHERE testAttr = ?)DISTINCT_TABLE", (Object)sql);
    }
}

