/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.util.Converters;
import org.geotools.util.URLs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.xml.sax.helpers.NamespaceSupport;

public class VocabFunctionsTest
extends AppSchemaTestSupport {
    private DataAccess<FeatureType, Feature> dataAccess;
    private FeatureCollection<FeatureType, Feature> exCollection;
    private FilterFactory ff;

    @Before
    public void setUp() throws Exception {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("ex", "http://example.com");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        this.ff = new FilterFactoryImplNamespaceAware(namespaces);
        Name EXAMPLE_TYPE = Types.typeName((String)"http://example.com", (String)"FirstParentFeature");
        String schemaBase = "/test-data/";
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = this.getClass().getResource("/test-data/VocabFunctionsTest.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        this.dataAccess = DataAccessFinder.getDataStore(dsParams);
        FeatureSource fSource = this.dataAccess.getFeatureSource(EXAMPLE_TYPE);
        this.exCollection = fSource.getFeatures();
        Assert.assertEquals((long)3L, (long)this.size(this.exCollection));
    }

    @After
    public void tearDown() {
        this.dataAccess.dispose();
    }

    @Test
    public void testRecodeFunction() throws IOException {
        HashMap<String, String> VALUE_MAP = new HashMap<String, String>(){
            {
                this.put("sc.1", "a");
                this.put("sc.2", "b");
                this.put("sc.3", "c");
            }
        };
        try (FeatureIterator features = this.exCollection.features();){
            while (features.hasNext()) {
                Feature feature = features.next();
                String fId = feature.getIdentifier().getID();
                String recodedName = (String)VALUE_MAP.get(fId);
                ComplexAttribute complexAttribute = (ComplexAttribute)this.ff.property("gml:name[3]").evaluate((Object)feature);
                String value = (String)Converters.convert((Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute), String.class);
                Assert.assertEquals((Object)recodedName, (Object)value);
            }
        }
    }

    private int size(FeatureCollection<FeatureType, Feature> features) {
        int size = 0;
        try (FeatureIterator i = features.features();){
            while (i.hasNext()) {
                ++size;
                i.next();
            }
        }
        return size;
    }

    @Test
    public void testCategorizeFunction() {
        HashMap<String, String> VALUE_MAP = new HashMap<String, String>(){
            {
                this.put("sc.1", "missing value");
                this.put("sc.2", "a valid value");
                this.put("sc.3", "a valid value");
            }
        };
        try (FeatureIterator features = this.exCollection.features();){
            while (features.hasNext()) {
                Feature feature = features.next();
                String fId = feature.getIdentifier().getID();
                Property attribute = feature.getProperty("someAttribute");
                Assert.assertEquals((Object)attribute.getValue(), VALUE_MAP.get(fId));
            }
        }
    }

    @Test
    public void testVocabFunction() {
        URL file = this.getClass().getResource("/test-data/minoc_lithology_mapping.properties");
        Assert.assertNotNull((Object)file);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Function function = ff.function("Vocab", new Expression[]{ff.literal((Object)"1LIST"), ff.literal((Object)URLs.urlToFile((URL)file).getPath())});
        Object value = function.evaluate(null);
        Assert.assertEquals((Object)"urn:cgi:classifier:CGI:SimpleLithology:2008:calcareous_carbonate_sedimentary_rock", (Object)value);
    }

    @Test
    public void testNoVocabFunction() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Function function = ff.function("Vocab", new Expression[]{ff.literal((Object)"a"), ff.literal((Object)"urn:1234")});
        try {
            function.evaluate(null);
            Assert.fail((String)"Should not be able to get this far");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testVocabFunctionInMappingFile() {
        HashMap<String, String> VALUE_MAP = new HashMap<String, String>(){
            {
                this.put("sc.1", "urn:cgi:classifier:CGI:SimpleLithology:2008:gravel");
                this.put("sc.2", "urn:cgi:classifier:CGI:SimpleLithology:2008:diamictite");
                this.put("sc.3", "urn:cgi:classifier:CGI:SimpleLithology:2008:sediment");
            }
        };
        try (FeatureIterator features = this.exCollection.features();){
            while (features.hasNext()) {
                Feature feature = features.next();
                String fId = feature.getIdentifier().getID();
                ComplexAttribute complexAttribute = (ComplexAttribute)this.ff.property("gml:name[2]").evaluate((Object)feature);
                String value = (String)Converters.convert((Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute), String.class);
                Assert.assertEquals(VALUE_MAP.get(fId), (Object)value);
            }
        }
    }

    @Test
    public void testVocabFunctionInMappingFileWithConfigParent() {
        HashMap<String, String> expectedValues = new HashMap<String, String>(){
            {
                this.put("sc.1", "urn:cgi:classifier:CGI:SimpleLithology:2008:gravel");
                this.put("sc.2", "urn:cgi:classifier:CGI:SimpleLithology:2008:diamictite");
                this.put("sc.3", "urn:cgi:classifier:CGI:SimpleLithology:2008:sediment");
            }
        };
        try (FeatureIterator features = this.exCollection.features();){
            while (features.hasNext()) {
                Feature feature = features.next();
                String fid = feature.getIdentifier().getID();
                ComplexAttribute complexAttribute = (ComplexAttribute)this.ff.property("gml:name[4]").evaluate((Object)feature);
                String value = (String)Converters.convert((Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute), String.class);
                Assert.assertEquals(expectedValues.get(fid), (Object)value);
            }
        }
    }
}

