/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs20.ResolveValueType;
import org.geotools.appschema.feature.AppSchemaFeatureFactoryImpl;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.joining.JoiningQuery;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.geotools.xlink.XLINK;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractMappingFeatureIterator
implements IMappingFeatureIterator {
    protected static final Logger LOGGER = Logging.getLogger(AbstractMappingFeatureIterator.class);
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));
    protected FilterFactory2 filterFac = CommonFactoryFinder.getFilterFactory2(null);
    protected FeatureTypeFactory ftf = new ComplexFeatureTypeFactoryImpl();
    public static final Name XLINK_HREF_NAME = Types.toTypeName((QName)XLINK.HREF);
    public static final String MULTI_VALUE_TYPE = "multi_value_type";
    public static final String UNBOUNDED_MULTI_VALUE = "unbounded-multi-value";
    public static final long RESOLVE_TIMEOUT_POLL_INTERVAL = 100L;
    protected FeatureTypeMapping mapping;
    protected List<AttributeMapping> selectedMapping;
    protected Map<AttributeMapping, List<PropertyName>> selectedProperties;
    protected boolean includeMandatory;
    protected FeatureFactory attf;
    protected AppSchemaDataAccess store;
    protected final XPath xpathAttributeBuilder;
    protected FilterFactory namespaceAwareFilterFactory;
    protected final int requestMaxFeatures;
    protected final int dataMaxFeatures;
    protected int featureCounter;
    protected NamespaceSupport namespaces;
    protected int resolveDepth;
    protected Integer resolveTimeOut;
    protected Transaction transaction;
    protected Query query;
    private boolean hasNextCalled = false;

    public Transaction getTransaction() {
        return this.transaction;
    }

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        this(store, mapping, query, null);
    }

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery) throws IOException {
        this(store, mapping, query, unrolledQuery, false, false);
    }

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery, boolean hasPostFilter) throws IOException {
        this(store, mapping, query, unrolledQuery, false, hasPostFilter);
    }

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery, boolean removeQueryLimitIfDenormalised, boolean hasPostFilter) throws IOException {
        this(store, mapping, query, unrolledQuery, removeQueryLimitIfDenormalised, hasPostFilter, null);
    }

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, Query unrolledQuery, boolean removeQueryLimitIfDenormalised, boolean hasPostFilter, Transaction tx) throws IOException {
        boolean resolve;
        this.store = store;
        this.attf = new AppSchemaFeatureFactoryImpl();
        this.mapping = mapping;
        this.transaction = tx;
        Hints hints = query.getHints();
        ResolveValueType resolveVal = (ResolveValueType)hints.get((Object)Hints.RESOLVE);
        boolean bl = resolve = ResolveValueType.ALL.equals((Object)resolveVal) || ResolveValueType.LOCAL.equals((Object)resolveVal);
        if (!resolve && resolveVal != null && !ResolveValueType.NONE.equals((Object)resolveVal)) {
            throw new IllegalArgumentException("Resolve:" + resolveVal.getName() + " is not supported in app-schema!");
        }
        Integer atd = (Integer)hints.get((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH);
        this.resolveDepth = resolve ? (atd == null ? 0 : atd) : 0;
        this.resolveTimeOut = (Integer)hints.get((Object)Hints.RESOLVE_TIMEOUT);
        this.namespaces = mapping.getNamespaces();
        this.namespaceAwareFilterFactory = new FilterFactoryImplNamespaceAware(this.namespaces);
        Object includeProps = query.getHints().get((Object)Query.INCLUDE_MANDATORY_PROPS);
        boolean bl2 = this.includeMandatory = includeProps instanceof Boolean && (Boolean)includeProps != false;
        if (mapping.isDenormalised()) {
            if (removeQueryLimitIfDenormalised) {
                this.dataMaxFeatures = 1000000;
                this.requestMaxFeatures = hasPostFilter ? 1000000 : query.getMaxFeatures();
            } else {
                this.dataMaxFeatures = query.getMaxFeatures();
                this.requestMaxFeatures = query.getMaxFeatures();
            }
        } else {
            this.requestMaxFeatures = query.getMaxFeatures();
            this.dataMaxFeatures = query.getMaxFeatures();
        }
        if (unrolledQuery == null) {
            unrolledQuery = this.getUnrolledQuery(query);
            if (query instanceof JoiningQuery && unrolledQuery instanceof JoiningQuery) {
                ((JoiningQuery)unrolledQuery).setRootMapping(((JoiningQuery)query).getRootMapping());
            }
        }
        if (query.getProperties() != null) {
            this.setPropertyNames(query.getProperties());
        } else {
            this.setPropertyNames(null);
        }
        this.xpathAttributeBuilder = new XPath();
        this.xpathAttributeBuilder.setFeatureFactory(this.attf);
        this.initialiseSourceFeatures(mapping, unrolledQuery, query.getCoordinateSystemReproject());
        this.xpathAttributeBuilder.setFilterFactory(this.namespaceAwareFilterFactory);
        this.query = unrolledQuery;
    }

    private void setPropertyNames(Collection<PropertyName> propertyNames) {
        this.selectedProperties = new HashMap<AttributeMapping, List<PropertyName>>();
        if (propertyNames == null) {
            this.selectedMapping = this.mapping.getAttributeMappings();
        } else {
            AttributeDescriptor targetDescriptor = this.mapping.getTargetFeature();
            this.selectedMapping = new ArrayList<AttributeMapping>();
            for (AttributeMapping attMapping : this.mapping.getAttributeMappings()) {
                PropertyName targetProp;
                Object descr;
                XPathUtil.StepList targetSteps = attMapping.getTargetXPath();
                boolean alreadyAdded = false;
                if (this.includeMandatory && (descr = (targetProp = this.namespaceAwareFilterFactory.property(targetSteps.toString())).evaluate((Object)targetDescriptor.getType())) instanceof PropertyDescriptor && ((PropertyDescriptor)descr).getMinOccurs() >= 1) {
                    this.selectedMapping.add(attMapping);
                    this.selectedProperties.put(attMapping, new ArrayList());
                    alreadyAdded = true;
                }
                for (PropertyName requestedProperty : propertyNames) {
                    XPathUtil.StepList requestedPropertySteps;
                    if ("__DEFAULT_GEOMETRY__".equals(requestedProperty.getPropertyName())) {
                        String defGeomPath = this.mapping.getDefaultGeometryXPath();
                        requestedProperty = this.namespaceAwareFilterFactory.property(defGeomPath);
                    }
                    if (!((requestedPropertySteps = requestedProperty.getNamespaceContext() == null ? XPath.steps((AttributeDescriptor)targetDescriptor, (String)requestedProperty.getPropertyName(), (NamespaceSupport)this.namespaces) : XPath.steps((AttributeDescriptor)targetDescriptor, (String)requestedProperty.getPropertyName(), (NamespaceSupport)requestedProperty.getNamespaceContext())) == null ? AppSchemaDataAccess.matchProperty(requestedProperty.getPropertyName(), targetSteps) : AppSchemaDataAccess.matchProperty(requestedPropertySteps, targetSteps))) continue;
                    if (!alreadyAdded) {
                        this.selectedMapping.add(attMapping);
                        this.selectedProperties.put(attMapping, new ArrayList());
                        alreadyAdded = true;
                    }
                    if (requestedPropertySteps == null || requestedPropertySteps.size() <= targetSteps.size()) continue;
                    List<PropertyName> pnList = this.selectedProperties.get(attMapping);
                    XPathUtil.StepList subProperty = requestedPropertySteps.subList(targetSteps.size(), requestedPropertySteps.size());
                    pnList.add(this.filterFac.property(subProperty.toString(), requestedProperty.getNamespaceContext()));
                }
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.closeSourceFeatures();
    }

    protected abstract String extractIdForAttribute(Expression var1, Object var2);

    protected Query getUnrolledQuery(Query query) {
        return this.store.unrollQuery(query, this.mapping);
    }

    protected boolean isHasNextCalled() {
        return this.hasNextCalled;
    }

    protected void setHasNextCalled(boolean hasNextCalled) {
        this.hasNextCalled = hasNextCalled;
    }

    @Override
    public Feature next() {
        Feature next;
        boolean hasNext = false;
        try {
            hasNext = this.hasNext();
        }
        catch (Throwable e) {
            this.close();
            throw new RuntimeException(e);
        }
        if (!hasNext) {
            throw new NoSuchElementException("there are no more features in this iterator");
        }
        try {
            next = this.computeNext();
        }
        catch (Throwable e) {
            this.close();
            throw new RuntimeException(e);
        }
        ++this.featureCounter;
        this.setHasNextCalled(false);
        return next;
    }

    protected Map<Name, Expression> getClientProperties(Property attribute) throws DataSourceException {
        Map props;
        Map userData = attribute.getUserData();
        HashMap<Name, Expression> clientProperties = new HashMap<Name, Expression>();
        if (userData != null && userData.containsKey(Attributes.class) && !(props = (Map)userData.get(Attributes.class)).isEmpty()) {
            clientProperties.putAll(props);
        }
        return clientProperties;
    }

    protected static String referenceToIdentifier(String reference) {
        String[] urn = reference.split(":");
        String lastPart = urn[urn.length - 1];
        if (lastPart.contains("#")) {
            lastPart = lastPart.substring(lastPart.lastIndexOf("#"));
        }
        if ("missing".equals(urn[urn.length - 1]) || "unknown".equals(urn[urn.length - 1])) {
            return null;
        }
        return lastPart;
    }

    protected Attribute setAttributeContent(Attribute target, XPathUtil.StepList xpath, Object value, String id, AttributeType targetNodeType, boolean isXlinkRef, Expression sourceExpression, Object source, Map<Name, Expression> clientProperties, boolean ignoreXlinkHref) {
        String refid;
        Attribute instance = null;
        HashMap<Name, Expression> properties = new HashMap<Name, Expression>(clientProperties);
        if (ignoreXlinkHref) {
            properties.remove(XLINK_HREF_NAME);
        }
        if (properties.containsKey(XLINK_HREF_NAME) && this.resolveDepth > 0 && (refid = AbstractMappingFeatureIterator.referenceToIdentifier(this.getValue((Expression)properties.get(XLINK_HREF_NAME), source).toString())) != null) {
            Hints hints = new Hints();
            if (this.resolveDepth > 1) {
                hints.put((Object)Hints.RESOLVE, (Object)ResolveValueType.ALL);
                hints.put((Object)Hints.RESOLVE_TIMEOUT, (Object)Integer.MAX_VALUE);
                hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)(this.resolveDepth - 1));
            } else {
                hints.put((Object)Hints.RESOLVE, (Object)ResolveValueType.NONE);
            }
            FeatureFinder finder = new FeatureFinder(refid, hints);
            Feature foundFeature = null;
            if (this.resolveTimeOut == Integer.MAX_VALUE) {
                finder.run();
                foundFeature = finder.getFeature();
            } else {
                Thread thread = new Thread(finder);
                long startTime = System.currentTimeMillis();
                thread.start();
                try {
                    while (thread.isAlive() && (System.currentTimeMillis() - startTime) / 1000L < (long)this.resolveTimeOut.intValue()) {
                        Thread.sleep(100L);
                    }
                    thread.interrupt();
                    thread.join();
                    foundFeature = finder.getFeature();
                }
                catch (InterruptedException e) {
                    thread.interrupt();
                    throw new RuntimeException("Interrupted while resolving resource " + refid);
                }
            }
            if (foundFeature != null) {
                instance = this.xpathAttributeBuilder.set(target, xpath, Collections.singletonList(foundFeature), id, targetNodeType, false, sourceExpression);
                properties.remove(XLINK_HREF_NAME);
            }
        }
        if (instance == null) {
            instance = this.xpathAttributeBuilder.set(target, xpath, value, id, targetNodeType, false, sourceExpression);
        }
        this.setClientProperties(instance, source, properties);
        return instance;
    }

    protected void setClientProperties(Attribute target, Object source, Map<Name, Expression> clientProperties) {
        if (target == null) {
            return;
        }
        if (source == null && clientProperties.isEmpty()) {
            return;
        }
        HashMap<Name, Object> targetAttributes = new HashMap<Name, Object>();
        if (target.getUserData().containsValue(Attributes.class)) {
            Map map = (Map)target.getUserData().get(Attributes.class);
            targetAttributes.putAll(map);
        }
        for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
            Name propName = entry.getKey();
            Expression propExpr = entry.getValue();
            Object propValue = propExpr instanceof Expression ? this.getValue(propExpr, source) : propExpr;
            if (propValue == null) continue;
            if (propValue instanceof Collection) {
                if (((Collection)propValue).isEmpty()) continue;
                propValue = ((Collection)propValue).iterator().next();
                targetAttributes.put(propName, propValue);
                continue;
            }
            targetAttributes.put(propName, propValue);
        }
        if (!targetAttributes.isEmpty()) {
            target.getUserData().put(Attributes.class, targetAttributes);
        }
        this.setGeometryUserData(target, targetAttributes);
    }

    protected void setGeometryUserData(Attribute target, Map<Name, Object> targetAttributes) {
        Object geom;
        if (target instanceof GeometryAttribute && (!targetAttributes.isEmpty() || target.getIdentifier() != null) && (geom = target.getValue() == null ? GEOMETRY_FACTORY.createGeometryCollection() : ((Geometry)target.getValue()).copy()) != null) {
            Object userData = geom.getUserData();
            HashMap<Object, Object> newUserData = new HashMap<Object, Object>();
            if (userData != null) {
                if (userData instanceof Map) {
                    Map map = (Map)userData;
                    newUserData.putAll(map);
                } else if (userData instanceof CoordinateReferenceSystem) {
                    newUserData.put(CoordinateReferenceSystem.class, userData);
                }
            }
            if (target.getIdentifier() != null) {
                newUserData.put("gml:id", target.getIdentifier().toString());
            }
            if (!targetAttributes.isEmpty()) {
                newUserData.put(Attributes.class, targetAttributes);
            }
            geom.setUserData(newUserData);
            target.setValue(geom);
        }
    }

    protected abstract void closeSourceFeatures();

    protected abstract FeatureIterator<? extends Feature> getSourceFeatureIterator();

    protected abstract void initialiseSourceFeatures(FeatureTypeMapping var1, Query var2, CoordinateReferenceSystem var3) throws IOException;

    protected abstract boolean unprocessedFeatureExists();

    protected abstract boolean sourceFeatureIteratorHasNext();

    protected abstract boolean isNextSourceFeatureNull();

    protected abstract Feature populateFeatureData(String var1) throws IOException;

    protected abstract Object getValue(Expression var1, Object var2);

    protected abstract boolean isSourceFeatureIteratorNull();

    protected abstract Feature computeNext() throws IOException;

    @Override
    public abstract boolean hasNext();

    private class FeatureFinder
    implements Runnable {
        private Feature feature = null;
        private String refId;
        private Hints hints;

        public Feature getFeature() {
            return this.feature;
        }

        public FeatureFinder(String refId, Hints hints) {
            this.refId = refId;
            this.hints = hints;
        }

        @Override
        public void run() {
            try {
                this.feature = DataAccessRegistry.getInstance().findFeature((FeatureId)new FeatureIdImpl(this.refId), this.hints);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

