/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.PropSelectionTest;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.test.AppSchemaTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public class ClientPropertiesTest
extends AppSchemaTestSupport {
    private static final String schemaBase = "/test-data/";
    static final String GSMLNS = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
    static final String GMLNS = "http://www.opengis.net/gml";
    static final Name MAPPED_FEATURE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
    private FeatureSource<FeatureType, Feature> mfSource;
    private FilterFactory2 ff;

    @Before
    public void setUp() throws Exception {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", GSMLNS);
        namespaces.declarePrefix("gml", GMLNS);
        this.ff = new FilterFactoryImplNamespaceAware(namespaces);
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = PropSelectionTest.class.getResource("/test-data/MappedFeatureClientProperties.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        url = PropSelectionTest.class.getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams = new HashMap();
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess guDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataAccess);
        this.mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
    }

    @Test
    public void testClientPropertyOnRootElement() throws IOException {
        PropertyName clientProp1 = this.ff.property("@codeSpace");
        PropertyName clientProp2 = this.ff.property("@staticProp");
        Query query = new Query();
        query.setProperties(Query.ALL_PROPERTIES);
        query.setFilter((Filter)Filter.INCLUDE);
        PropertyName namePn = this.ff.property("gml:name");
        FeatureCollection mfCollection = this.mfSource.getFeatures(query);
        try (FeatureIterator iterator = mfCollection.features();){
            int featureCount = 0;
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                String name = (String)namePn.evaluate((Object)feature, String.class);
                Assert.assertEquals((Object)("urn:x-test:classifierScheme:TestAuthority:" + name), (Object)clientProp1.evaluate((Object)feature));
                Assert.assertEquals((Object)"static_property", (Object)clientProp2.evaluate((Object)feature));
                ++featureCount;
            }
            Assert.assertEquals((long)5L, (long)featureCount);
        }
    }
}

