/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.appschema.filter.expression.ToDirectPositionFunction;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GMLSchema;
import org.geotools.referencing.CRS;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XSSchema;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryFunctionsTest
extends AppSchemaTestSupport {
    public static final Logger LOGGER = Logging.getLogger(GeometryFunctionsTest.class);
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private static SimpleFeature feature;
    private static PropertyName pointOne;
    private static PropertyName pointTwo;

    @BeforeClass
    public static void setUpOnce() {
        ArrayList<AttributeDescriptorImpl> schema = new ArrayList<AttributeDescriptorImpl>();
        schema.add(new AttributeDescriptorImpl(XSSchema.DOUBLE_TYPE, Types.typeName((String)"pointOne"), 0, 1, false, null));
        schema.add(new AttributeDescriptorImpl(XSSchema.DOUBLE_TYPE, Types.typeName((String)"pointTwo"), 0, 1, false, null));
        SimpleFeatureTypeImpl type = new SimpleFeatureTypeImpl(Types.typeName((String)"GeometryContainer"), schema, null, false, null, (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
        feature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{5.0, 2.5}, null);
        pointOne = ff.property("pointOne");
        pointTwo = ff.property("pointTwo");
    }

    @Test
    public void testToDirectPosition() throws Exception {
        Function function = ff.function("toDirectPosition", new Expression[]{ToDirectPositionFunction.SRS_NAME, ff.literal((Object)"EPSG:4326"), pointOne, pointTwo});
        Object value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof DirectPosition));
        DirectPosition pos = (DirectPosition)value;
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)pos.getCoordinateReferenceSystem()), (Object)"EPSG:4326");
        Assert.assertEquals((long)pos.getDimension(), (long)2L);
        Assert.assertEquals((double)pos.getOrdinate(0), (double)5.0, (double)0.0);
        Assert.assertEquals((double)pos.getOrdinate(1), (double)2.5, (double)0.0);
        function = ff.function("toDirectPosition", new Expression[]{pointOne});
        value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof DirectPosition));
        pos = (DirectPosition)value;
        Assert.assertNull((Object)pos.getCoordinateReferenceSystem());
        Assert.assertEquals((long)pos.getDimension(), (long)1L);
        Assert.assertEquals((double)pos.getOrdinate(0), (double)5.0, (double)0.0);
        try {
            function = ff.function("toDirectPosition", new Expression[]{ToDirectPositionFunction.SRS_NAME, ff.literal((Object)"1"), pointOne, pointTwo});
            function.evaluate((Object)feature);
            Assert.fail((String)"Shouldn't get this far with invalid SRS name: '1'");
        }
        catch (Throwable e) {
            LOGGER.info("Testing exception: " + e.toString());
        }
        try {
            function = ff.function("toDirectPosition", new Expression[]{pointOne, pointTwo, pointOne});
            function.evaluate((Object)feature);
            Assert.fail((String)("Shouldn't get this far with too many parameters: " + pointOne.toString() + ", " + pointTwo.toString() + ", " + pointOne.toString()));
        }
        catch (Throwable e) {
            LOGGER.info("Testing exception: " + e.toString());
        }
        try {
            function = ff.function("toDirectPosition", new Expression[]{ToDirectPositionFunction.SRS_NAME, ff.literal((Object)"EPSG:WGS84")});
            function.evaluate((Object)feature);
            Assert.fail((String)("Shouldn't get this far with too many parameters: " + pointOne.toString() + ", " + pointTwo.toString() + ", " + pointOne.toString()));
        }
        catch (Throwable e) {
            LOGGER.info("Testing exception: " + e.toString());
        }
    }

    @Test
    public void testToPoint() throws NoSuchAuthorityCodeException, FactoryException {
        Function function = ff.function("toPoint", new Expression[]{ToDirectPositionFunction.SRS_NAME, ff.literal((Object)"EPSG:4283"), pointOne, pointTwo, ff.literal((Object)"1")});
        Object value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof Point));
        Point pt = (Point)value;
        Assert.assertEquals((long)pt.getDimension(), (long)0L);
        Assert.assertEquals((double)pt.getCoordinate().x, (double)5.0, (double)0.0);
        Assert.assertEquals((double)pt.getCoordinate().y, (double)2.5, (double)0.0);
        Map userData = (Map)pt.getUserData();
        Assert.assertEquals(userData.get("gml:id"), (Object)"1");
        Assert.assertEquals(userData.get(CoordinateReferenceSystem.class), (Object)CRS.decode((String)"EPSG:4283"));
        function = ff.function("toPoint", new Expression[]{pointOne, pointTwo});
        value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof Point));
        pt = (Point)value;
        Assert.assertEquals((long)pt.getDimension(), (long)0L);
        Assert.assertEquals((double)pt.getCoordinate().x, (double)5.0, (double)0.0);
        Assert.assertEquals((double)pt.getCoordinate().y, (double)2.5, (double)0.0);
        Assert.assertNull((Object)pt.getUserData());
        function = ff.function("toPoint", new Expression[]{pointOne});
        try {
            value = function.evaluate((Object)feature);
            Assert.fail((String)("Shouldn't get this far with not enough parameters :" + pointOne.toString()));
        }
        catch (Throwable e) {
            LOGGER.info("Testing exception: " + e.toString());
        }
        function = ff.function("toPoint", new Expression[]{ToDirectPositionFunction.SRS_NAME, ff.literal((Object)"1"), pointOne, pointTwo, pointOne});
        try {
            function.evaluate((Object)feature);
            Assert.fail((String)("Shouldn't get this far with too many parameters: " + pointOne.toString() + ", " + pointTwo.toString() + ", " + pointOne.toString()));
        }
        catch (Throwable e) {
            LOGGER.info("Testing exception: " + e.toString());
        }
    }

    @Test
    public void testToEnvelope() {
        Function function = ff.function("toEnvelope", new Expression[]{pointOne, pointTwo});
        Object value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof Envelope));
        Envelope env = (Envelope)value;
        Assert.assertEquals((double)env.getMinX(), (double)env.getMaxX(), (double)0.0);
        Assert.assertEquals((double)env.getMinX(), (double)5.0, (double)0.0);
        Assert.assertEquals((double)env.getMinY(), (double)env.getMaxY(), (double)0.0);
        Assert.assertEquals((double)env.getMinY(), (double)2.5, (double)0.0);
        function = ff.function("toEnvelope", new Expression[]{pointOne, pointTwo, ff.literal((Object)"EPSG:4283")});
        value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof ReferencedEnvelope));
        ReferencedEnvelope refEnv = (ReferencedEnvelope)value;
        Assert.assertEquals((double)refEnv.getMinX(), (double)refEnv.getMaxX(), (double)0.0);
        Assert.assertEquals((double)refEnv.getMinX(), (double)5.0, (double)0.0);
        Assert.assertEquals((double)refEnv.getMinY(), (double)refEnv.getMaxY(), (double)0.0);
        Assert.assertEquals((double)refEnv.getMinY(), (double)2.5, (double)0.0);
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)refEnv.getCoordinateReferenceSystem()), (Object)"EPSG:4283");
        function = ff.function("toEnvelope", new Expression[]{pointTwo, pointOne, pointTwo, pointOne});
        value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof Envelope));
        env = (Envelope)value;
        Assert.assertEquals((double)env.getMinX(), (double)2.5, (double)0.0);
        Assert.assertEquals((double)env.getMaxX(), (double)5.0, (double)0.0);
        Assert.assertEquals((double)env.getMinY(), (double)2.5, (double)0.0);
        Assert.assertEquals((double)env.getMaxY(), (double)5.0, (double)0.0);
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)refEnv.getCoordinateReferenceSystem()), (Object)"EPSG:4283");
        function = ff.function("toEnvelope", new Expression[]{pointTwo, pointOne, pointTwo, pointOne, ff.literal((Object)"EPSG:4283")});
        value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof ReferencedEnvelope));
        refEnv = (ReferencedEnvelope)value;
        Assert.assertEquals((double)refEnv.getMinX(), (double)2.5, (double)0.0);
        Assert.assertEquals((double)refEnv.getMaxX(), (double)5.0, (double)0.0);
        Assert.assertEquals((double)refEnv.getMinY(), (double)2.5, (double)0.0);
        Assert.assertEquals((double)refEnv.getMaxY(), (double)5.0, (double)0.0);
        Assert.assertEquals((Object)CRS.toSRS((CoordinateReferenceSystem)refEnv.getCoordinateReferenceSystem()), (Object)"EPSG:4283");
    }

    @Test
    public void testToLineStringEPSG() {
        Function function = ff.function("toLineString", new Expression[]{ff.literal((Object)"EPSG:9902"), pointOne, pointTwo});
        Object value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof LineString));
        LineString linestring = (LineString)value;
        Assert.assertEquals((long)linestring.getDimension(), (long)1L);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)linestring.getUserData();
        Assert.assertEquals((long)1L, (long)crs.getCoordinateSystem().getDimension());
        Assert.assertEquals((Object)"EPSG:9902", (Object)crs.getName().getCode());
        Assert.assertEquals((double)linestring.getCoordinateN((int)0).x, (double)5.0, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN((int)0).y, (double)Double.NaN, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN(0).getZ(), (double)Double.NaN, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN((int)1).x, (double)2.5, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN((int)1).y, (double)Double.NaN, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN(1).getZ(), (double)Double.NaN, (double)0.0);
    }

    @Test
    public void testToLineStringCustomSRS() {
        String customSRS = "#borehole.GA.1";
        Function function = ff.function("toLineString", new Expression[]{ff.literal((Object)customSRS), pointOne, pointTwo});
        Object value = function.evaluate((Object)feature);
        Assert.assertTrue((boolean)(value instanceof LineString));
        LineString linestring = (LineString)value;
        Assert.assertEquals((long)linestring.getDimension(), (long)1L);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)linestring.getUserData();
        Assert.assertEquals((long)1L, (long)crs.getCoordinateSystem().getDimension());
        Assert.assertEquals((Object)customSRS, (Object)crs.getName().getCode());
        Assert.assertEquals((double)linestring.getCoordinateN((int)0).x, (double)5.0, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN((int)0).y, (double)Double.NaN, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN(0).getZ(), (double)Double.NaN, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN((int)1).x, (double)2.5, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN((int)1).y, (double)Double.NaN, (double)0.0);
        Assert.assertEquals((double)linestring.getCoordinateN(1).getZ(), (double)Double.NaN, (double)0.0);
    }

    @Test
    public void testToLineStringNullParams() {
        Function function = ff.function("toLineString", new Expression[]{null, null});
        try {
            function.evaluate((Object)feature);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid parameters for toLineString function: [null, null]. Usage: toLineString(srsName, point 1, point 2)";
            Assert.assertEquals((Object)msg, (Object)e.getMessage());
        }
    }

    @Test
    public void testToLineStringInvalidParams() {
        Function function = ff.function("toLineString", new Expression[]{ff.literal((Object)"#GA.borehole.100"), Literal.NIL, ff.literal((Object)"something")});
        try {
            function.evaluate((Object)feature);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            String msg = "Error converting the parameters for toLineString function: [#GA.borehole.100, Expression.NIL, something]. Usage: toLineString(srsName, point 1, point 2)";
            Assert.assertEquals((Object)msg, (Object)e.getMessage());
            Assert.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
    }
}

