/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.data.complex.feature.type.ComplexTypeProxy;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class NonFeatureTypeProxy
extends ComplexTypeProxy
implements FeatureType {
    private final Collection<PropertyDescriptor> descriptors;
    private final AttributeType subject;

    public NonFeatureTypeProxy(AttributeType type, FeatureTypeMapping mapping) {
        super(type.getName(), null);
        this.subject = type;
        AttributeDescriptor originalTarget = mapping.getTargetFeature();
        int maxOccurs = originalTarget.getMaxOccurs();
        int minOccurs = originalTarget.getMinOccurs();
        boolean nillable = originalTarget.isNillable();
        Object defaultValue = originalTarget.getDefaultValue();
        Name name = originalTarget.getName();
        ComplexFeatureTypeFactoryImpl typeFactory = new ComplexFeatureTypeFactoryImpl();
        AttributeDescriptor descriptor = typeFactory.createAttributeDescriptor((AttributeType)this, name, minOccurs, maxOccurs, nillable, defaultValue);
        descriptor.getUserData().putAll(originalTarget.getUserData());
        mapping.setTargetFeature(descriptor);
        this.descriptors = new ArrayList<PropertyDescriptor>(){
            {
                this.add(ComplexFeatureConstants.FEATURE_CHAINING_LINK);
            }
        };
        if (this.subject instanceof ComplexType) {
            this.descriptors.addAll(((ComplexType)this.subject).getDescriptors());
        }
    }

    public NonFeatureTypeProxy(AttributeType type, FeatureTypeMapping mapping, Collection<PropertyDescriptor> schema) {
        super(type.getName(), null);
        this.subject = type;
        AttributeDescriptor originalTarget = mapping.getTargetFeature();
        int maxOccurs = originalTarget.getMaxOccurs();
        int minOccurs = originalTarget.getMinOccurs();
        boolean nillable = originalTarget.isNillable();
        Object defaultValue = originalTarget.getDefaultValue();
        Name name = originalTarget.getName();
        ComplexFeatureTypeFactoryImpl typeFactory = new ComplexFeatureTypeFactoryImpl();
        AttributeDescriptor descriptor = typeFactory.createAttributeDescriptor((AttributeType)this, name, minOccurs, maxOccurs, nillable, defaultValue);
        descriptor.getUserData().putAll(originalTarget.getUserData());
        mapping.setTargetFeature(descriptor);
        schema.add(ComplexFeatureConstants.FEATURE_CHAINING_LINK);
        this.descriptors = schema;
    }

    public AttributeType getSubject() {
        return this.subject;
    }

    public PropertyDescriptor getDescriptor(Name name) {
        if (name.equals((Object)ComplexFeatureConstants.FEATURE_CHAINING_LINK_NAME)) {
            return ComplexFeatureConstants.FEATURE_CHAINING_LINK;
        }
        return super.getDescriptor(name);
    }

    public Collection<PropertyDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public Collection<PropertyDescriptor> getTypeDescriptors() {
        if (this.subject instanceof ComplexType) {
            return ((ComplexType)this.subject).getDescriptors();
        }
        return Collections.emptyList();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public GeometryDescriptor getGeometryDescriptor() {
        return null;
    }
}

