/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.filter.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geotools.appschema.filter.expression.ToDirectPositionFunction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.Parameter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ToPointFunction
implements Function {
    private final List<Expression> parameters;
    private final Literal fallback;
    private static final String USAGE = "Usage: toPoint('SRS_NAME'(optional), srsName(optional), point 1, point 2, gml:id(optional))";
    public static final FunctionName NAME = new FunctionNameImpl("toPoint", FunctionNameImpl.parameter((String)"return", Point.class), new Parameter[]{FunctionNameImpl.parameter((String)"parameter", Object.class, (int)2, (int)5)});
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    public static final Expression GML_ID = ff.literal((Object)"gml:id");

    public ToPointFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public ToPointFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Point.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Point point;
        Expression param1 = this.parameters.get(0);
        if (param1.equals(ToDirectPositionFunction.SRS_NAME)) {
            if (this.parameters.size() > 5 || this.parameters.size() < 4) {
                throw new IllegalArgumentException("Wrong number of parameters for toPoint function: " + this.parameters.toString() + ". Usage: toPoint('SRS_NAME'(optional), srsName(optional), point 1, point 2, gml:id(optional))");
            }
            CoordinateReferenceSystem crs = null;
            String srsName = (String)this.parameters.get(1).evaluate(object, String.class);
            try {
                crs = CRS.decode((String)srsName);
            }
            catch (NoSuchAuthorityCodeException e) {
                throw new IllegalArgumentException("Invalid or unsupported SRS name detected for toPoint function: " + srsName + ". Cause: " + e.getMessage());
            }
            catch (FactoryException e) {
                throw new RuntimeException("Unable to decode SRS name. Cause: " + e.getMessage());
            }
            GeometryFactory fac = new GeometryFactory(new PrecisionModel());
            point = fac.createPoint(new Coordinate(((Double)this.parameters.get(2).evaluate(object, Double.class)).doubleValue(), ((Double)this.parameters.get(3).evaluate(object, Double.class)).doubleValue()));
            String gmlId = null;
            if (this.parameters.size() == 5) {
                gmlId = (String)this.parameters.get(4).evaluate(object, String.class);
            }
            this.setUserData(point, crs, gmlId);
        } else {
            if (this.parameters.size() > 3 || this.parameters.size() < 2) {
                throw new IllegalArgumentException("Wrong number of parameters for toPoint function: " + this.parameters.toString() + ". Usage: toPoint('SRS_NAME'(optional), srsName(optional), point 1, point 2, gml:id(optional))");
            }
            GeometryFactory fac = new GeometryFactory();
            point = fac.createPoint(new Coordinate(((Double)param1.evaluate(object, Double.class)).doubleValue(), ((Double)this.parameters.get(1).evaluate(object, Double.class)).doubleValue()));
            if (this.parameters.size() == 3) {
                String gmlId = (String)this.parameters.get(2).evaluate(object, String.class);
                this.setUserData(point, null, gmlId);
            }
        }
        return (T)point;
    }

    private void setUserData(Point point, CoordinateReferenceSystem crs, String gmlId) {
        HashMap<Object, String> userData = new HashMap<Object, String>();
        if (gmlId != null) {
            userData.put("gml:id", gmlId);
        }
        if (crs != null) {
            userData.put(CoordinateReferenceSystem.class, (String)crs);
        }
        point.setUserData(userData);
    }
}

