/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.data.ComplexTestData;
import org.geotools.data.complex.feature.type.UniqueNameFeatureTypeFactoryImpl;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.xlink.XLINK;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.xml.sax.helpers.NamespaceSupport;

public class XPathUtilTest {
    @Test
    public void testSteps() throws Exception {
        FeatureType complexType = ComplexTestData.createExample01MultiValuedComplexProperty((FeatureTypeFactory)new UniqueNameFeatureTypeFactoryImpl());
        Name name = complexType.getName();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl((AttributeType)complexType, name, 0, Integer.MAX_VALUE, true, null);
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("wq", name.getNamespaceURI());
        try {
            XPathUtil.steps((AttributeDescriptor)descriptor, null, (NamespaceSupport)namespaces);
            Assert.fail((String)"passed null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String xpath = "/";
        Assert.assertEquals((long)1L, (long)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces).size());
        XPathUtil.Step step = (XPathUtil.Step)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces).get(0);
        QName rootQName = new QName(name.getNamespaceURI(), name.getLocalPart());
        Assert.assertEquals((Object)rootQName, (Object)step.getName());
        List<XPathUtil.Step> expected = Collections.singletonList(new XPathUtil.Step(rootQName, 1));
        xpath = "wq_plus";
        Assert.assertEquals(expected, (Object)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Collections.singletonList(new XPathUtil.Step(rootQName, 1));
        xpath = "/wq_plus";
        Assert.assertEquals(expected, (Object)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Collections.singletonList(new XPathUtil.Step(rootQName, 1));
        xpath = "wq_plus/measurement/result/../../measurement/determinand_description/../..";
        Assert.assertEquals(expected, (Object)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Arrays.asList(new XPathUtil.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 2), new XPathUtil.Step(new QName(rootQName.getNamespaceURI(), "result"), 1));
        xpath = "wq_plus/measurement/result/../../measurement[2]/result";
        Assert.assertEquals(expected, (Object)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Arrays.asList(new XPathUtil.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 1), new XPathUtil.Step(new QName(rootQName.getNamespaceURI(), "result"), 1));
        xpath = "wq_plus/measurement/result/../result/.";
        Assert.assertEquals(expected, (Object)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Arrays.asList(new XPathUtil.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 5));
        xpath = "measurement/result/../../measurement[5]";
        Assert.assertEquals(expected, (Object)XPathUtil.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
    }

    @Test
    public void testStepsWithXmlAttribute() throws Exception {
        FeatureType complexType = ComplexTestData.createExample01MultiValuedComplexProperty((FeatureTypeFactory)new UniqueNameFeatureTypeFactoryImpl());
        Name name = complexType.getName();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl((AttributeType)complexType, name, 0, Integer.MAX_VALUE, true, null);
        QName rootQName = new QName(name.getNamespaceURI(), name.getLocalPart());
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("wq", name.getNamespaceURI());
        namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
        XPathUtil.StepList steps = XPathUtil.steps((AttributeDescriptor)descriptor, (String)"wq_plus/measurement[2]/@xlink:href", (NamespaceSupport)namespaces);
        Assert.assertNotNull((Object)steps);
        Assert.assertEquals((String)steps.toString(), (long)2L, (long)steps.size());
        XPathUtil.Step step1 = new XPathUtil.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 2, false);
        XPathUtil.Step step2 = new XPathUtil.Step(XLINK.HREF, 1, true);
        Assert.assertEquals((Object)step1, (Object)steps.get(0));
        Assert.assertEquals((Object)step2, (Object)steps.get(1));
    }

    @Test
    public void testStepEquals() {
        XPathUtil.Step step1 = new XPathUtil.Step(XLINK.FROM, 1);
        XPathUtil.Step step2 = new XPathUtil.Step(XLINK.HREF, 1, false);
        XPathUtil.Step step3 = new XPathUtil.Step(XLINK.HREF, 1, false);
        XPathUtil.Step step4 = new XPathUtil.Step(XLINK.HREF, 1, true);
        XPathUtil.Step step5 = new XPathUtil.Step(XLINK.HREF, 2, false);
        Assert.assertNotEquals(null, (Object)step1);
        Assert.assertNotEquals((Object)step1, (Object)new Object());
        Assert.assertNotEquals((Object)step1, (Object)step2);
        Assert.assertEquals((Object)step2, (Object)step3);
        Assert.assertNotEquals((Object)step2, (Object)step4);
        Assert.assertNotEquals((Object)step2, (Object)step5);
    }

    @Test
    public void testRootElementSteps() {
        NamespaceSupport namespaces = new NamespaceSupport();
        try {
            XPathUtil.rootElementSteps(null, (NamespaceSupport)namespaces);
            Assert.fail((String)"passed null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        FeatureType complexType = ComplexTestData.createExample05NoNamespaceURI((FeatureTypeFactory)new UniqueNameFeatureTypeFactoryImpl());
        Name name = complexType.getName();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl((AttributeType)complexType, name, 0, Integer.MAX_VALUE, true, null);
        try {
            XPathUtil.rootElementSteps((AttributeDescriptor)descriptor, (NamespaceSupport)namespaces);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"failed null");
        }
        Assert.assertEquals((long)1L, (long)XPathUtil.rootElementSteps((AttributeDescriptor)descriptor, (NamespaceSupport)namespaces).size());
        XPathUtil.Step step = (XPathUtil.Step)XPathUtil.rootElementSteps((AttributeDescriptor)descriptor, (NamespaceSupport)namespaces).get(0);
        QName rootQName = new QName(name.getNamespaceURI(), name.getLocalPart(), "");
        Assert.assertEquals((Object)rootQName, (Object)step.getName());
        complexType = ComplexTestData.createExample01MultiValuedComplexProperty((FeatureTypeFactory)new UniqueNameFeatureTypeFactoryImpl());
        name = complexType.getName();
        descriptor = new AttributeDescriptorImpl((AttributeType)complexType, name, 0, Integer.MAX_VALUE, true, null);
        String prefix = "wq";
        namespaces.declarePrefix(prefix, name.getNamespaceURI());
        try {
            XPathUtil.rootElementSteps((AttributeDescriptor)descriptor, (NamespaceSupport)namespaces);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"failed null");
        }
        Assert.assertEquals((long)1L, (long)XPathUtil.rootElementSteps((AttributeDescriptor)descriptor, (NamespaceSupport)namespaces).size());
        step = (XPathUtil.Step)XPathUtil.rootElementSteps((AttributeDescriptor)descriptor, (NamespaceSupport)namespaces).get(0);
        rootQName = new QName(name.getNamespaceURI(), name.getLocalPart(), prefix);
        Assert.assertEquals((Object)rootQName, (Object)step.getName());
    }
}

