/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.net.URL;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.tools.ResolvingXMLReader;
import org.geotools.test.AppSchemaTestSupport;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OasisCatalogTest
extends AppSchemaTestSupport {
    Catalog catalog;

    @Before
    public void setUp() throws Exception {
        this.catalog = new Catalog();
        this.catalog.setupReaders();
    }

    @Test
    public void testParseCatalog() throws Exception {
        URL file = TestData.url((Object)this, (String)"commonSchemas_new.oasis.xml");
        ResolvingXMLReader reader = new ResolvingXMLReader();
        Catalog catalog = reader.getCatalog();
        catalog.getCatalogManager().setVerbosity(9);
        catalog.parseCatalog(file);
        URL baseUri = new URL("http://schemas.opengis.net/gml/");
        URL override = new URL("file:///schemas/gml/trunk/gml/");
        String extraPath = "3.1.1/basicTypes.xsd";
        String uri = new URL(baseUri, "3.1.1/basicTypes.xsd").toExternalForm();
        String expected = new URL(override, "3.1.1/basicTypes.xsd").toExternalForm();
        String resolved = catalog.resolveSystem(uri);
        Assert.assertNotNull((Object)resolved);
        String actual = new URL(resolved).toExternalForm();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

