/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2004-2007 Open Geospatial Consortium Inc.
 *
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.geotools.api.feature.type;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;

/**
 * The type of a GeometryAttribute.
 *
 * <p>Beyond AttributeType, this class stores the coordinate reference system that geometries are defined in, see
 * {@link #getCoordinateReferenceSystem()}.
 *
 * @author Jody Garnett, Refractions Research
 * @author Justin Deoliveira, The Open Planning Project
 */
public interface GeometryType extends AttributeType {
    /**
     * The coordinate reference system in which geometries are defined.
     *
     * <p>This method may return <code>null</code>, but this should only occur in cases where the actual crs is not
     * known. A common case is when a shapefile does not have an accompanied .prj file.
     */
    CoordinateReferenceSystem getCoordinateReferenceSystem();
}
