/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.style;

import java.awt.Color;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.dialog.JExceptionReporter;
import org.geotools.swing.styling.JSimpleStyleDialog;
import org.geotools.xml.styling.SLDParser;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;

public class StyleLab {
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
    static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();

    public static void main(String[] args) throws Exception {
        StyleLab me = new StyleLab();
        me.displayShapefile();
    }

    private void displayShapefile() throws Exception {
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        MapContent map = new MapContent();
        map.setTitle("StyleLab");
        Style style = this.createStyle(file, (FeatureSource)featureSource);
        FeatureLayer layer = new FeatureLayer((FeatureSource)featureSource, style);
        map.addLayer((Layer)layer);
        JMapFrame.showMap((MapContent)map);
    }

    private Style createStyle(File file, FeatureSource featureSource) {
        File sld = this.toSLDFile(file);
        if (sld != null) {
            return this.createFromSLD(sld);
        }
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        return JSimpleStyleDialog.showDialog(null, (SimpleFeatureType)schema);
    }

    public File toSLDFile(File file) {
        String path = file.getAbsolutePath();
        String base = path.substring(0, path.length() - 4);
        String newPath = base + ".sld";
        File sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        newPath = base + ".SLD";
        sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        return null;
    }

    private Style createFromSLD(File sld) {
        try {
            SLDParser stylereader = new SLDParser(styleFactory, sld.toURI().toURL());
            Style[] style = stylereader.readXML();
            return style[0];
        }
        catch (Exception e) {
            JExceptionReporter.showDialog((Throwable)e, (String)"Problem creating style");
            return null;
        }
    }

    private Style createStyle2(FeatureSource featureSource) {
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        Class geomType = schema.getGeometryDescriptor().getType().getBinding();
        if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
            return this.createPolygonStyle();
        }
        if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
            return this.createLineStyle();
        }
        return this.createPointStyle();
    }

    private Style createPolygonStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1), (Expression)filterFactory.literal(0.5));
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN), (Expression)filterFactory.literal(0.5));
        PolygonSymbolizer sym = styleFactory.createPolygonSymbolizer(stroke, fill, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createLineStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1));
        LineSymbolizer sym = styleFactory.createLineSymbolizer(stroke, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createPointStyle() {
        Graphic gr = styleFactory.createDefaultGraphic();
        Mark mark = styleFactory.getCircleMark();
        mark.setStroke((org.opengis.style.Stroke)styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1)));
        mark.setFill((Fill)styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN)));
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(mark);
        gr.setSize((Expression)filterFactory.literal(5));
        PointSymbolizer sym = styleFactory.createPointSymbolizer(gr, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }
}

