/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.quickstart;

import java.io.File;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.collection.SpatialIndexFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.opengis.feature.type.FeatureType;

public class QuickstartCache {
    public static void main(String[] args) throws Exception {
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        SimpleFeatureSource cachedSource = DataUtilities.source((FeatureCollection)new SpatialIndexFeatureCollection(featureSource.getFeatures()));
        MapContent map = new MapContent();
        map.setTitle("Using cached features");
        Style style = SLD.createSimpleStyle((FeatureType)featureSource.getSchema());
        FeatureLayer layer = new FeatureLayer((FeatureSource)cachedSource, style);
        map.addLayer((Layer)layer);
        JMapFrame.showMap((MapContent)map);
    }
}

