/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.process;

import java.util.HashMap;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.Process;
import org.geotools.process.ProcessExecutor;
import org.geotools.process.Processors;
import org.geotools.process.Progress;
import org.geotools.tutorial.process.BufferFactory;
import org.geotools.tutorial.process.BufferFeatureCollectionFactory;
import org.geotools.tutorial.process.BufferFeatureCollectionProcess;
import org.geotools.tutorial.process.BufferProcess;
import org.geotools.util.KVP;
import org.junit.Assert;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class ProcessExample {
    public static void main(String[] args) throws Exception {
        ProcessExample.example1();
    }

    public static void example1() throws Exception {
        WKTReader wktReader = new WKTReader(new GeometryFactory());
        Geometry geom = wktReader.read("MULTIPOINT (1 1, 5 4, 7 9, 5 5, 2 2)");
        NameImpl name = new NameImpl("tutorial", "octagonalEnvelope");
        Process process = Processors.createProcess((Name)name);
        ProcessExecutor engine = Processors.newProcessExecutor((int)2);
        KVP input = new KVP(new Object[]{"geom", geom});
        Progress working = engine.submit(process, (Map)input);
        if (working.isCancelled()) {
            return;
        }
        Map result = (Map)working.get();
        Geometry octo = (Geometry)result.get("result");
        System.out.println(octo);
    }

    public static void exampleParam() throws Exception {
        NameImpl name = new NameImpl("tutorial", "octagonalEnvelope");
        Map paramInfo = Processors.getParameterInfo((Name)name);
    }

    public static void example2() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory());
        Polygon geom1 = (Polygon)reader.read("POLYGON((20 10, 30 0, 40 10, 30 20, 20 10))");
        Double buffer = 213.78;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(BufferFactory.GEOM1.key, geom1);
        map.put(BufferFactory.BUFFER.key, buffer);
        BufferProcess process = new BufferProcess(null);
        Map<String, Object> resultMap = process.execute(map, null);
        Object result = resultMap.get(BufferFactory.RESULT.key);
        Geometry bufferedGeom = geom1.buffer(buffer.doubleValue());
    }

    public static void example3() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("featureType");
        tb.add("geometry", Point.class);
        tb.add("integer", Integer.class);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, b.getFeatureType());
        for (int i = 0; i < 2; ++i) {
            b.add((Object)gf.createPoint(new Coordinate((double)i, (double)i)));
            b.add((Object)i);
            features.add(b.buildFeature(i + ""));
        }
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put(BufferFeatureCollectionFactory.FEATURES.key, features);
        input.put(BufferFeatureCollectionFactory.BUFFER.key, 10.0);
        BufferFeatureCollectionFactory factory = new BufferFeatureCollectionFactory();
        BufferFeatureCollectionProcess process = factory.create();
        Map output = process.execute(input, null);
        FeatureCollection buffered = (FeatureCollection)output.get(BufferFeatureCollectionFactory.RESULT.key);
        Assert.assertEquals((long)2L, (long)buffered.size());
        for (int i = 0; i < 2; ++i) {
            Geometry expected = gf.createPoint(new Coordinate((double)i, (double)i)).buffer(10.0);
            FeatureCollection sub = buffered.subCollection((Filter)ff.equals((Expression)ff.property("integer"), (Expression)ff.literal(i)));
            Assert.assertEquals((long)1L, (long)sub.size());
            FeatureIterator iterator = sub.features();
            SimpleFeature sf = (SimpleFeature)iterator.next();
            Assert.assertTrue((boolean)expected.equals((Geometry)sf.getDefaultGeometry()));
            iterator.close();
        }
    }
}

