/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv3.parse;

import com.csvreader.CsvWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tutorial.csv3.CSVFileState;
import org.geotools.tutorial.csv3.parse.CSVStrategy;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CSVSpecifiedWKTStrategy
extends CSVStrategy {
    private final String wktField;

    public CSVSpecifiedWKTStrategy(CSVFileState csvFileState, String wktField) {
        super(csvFileState);
        this.wktField = wktField;
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        SimpleFeatureTypeBuilder featureBuilder = CSVSpecifiedWKTStrategy.createBuilder(this.csvFileState);
        AttributeDescriptor descriptor = featureBuilder.get(this.wktField);
        if (descriptor != null) {
            AttributeTypeBuilder attributeBuilder = new AttributeTypeBuilder();
            attributeBuilder.init(descriptor);
            attributeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            attributeBuilder.binding(Geometry.class);
            AttributeDescriptor modified = attributeBuilder.buildDescriptor(this.wktField);
            featureBuilder.set(modified);
        }
        return featureBuilder.buildFeatureType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.featureType = featureType;
        ArrayList<String> header = new ArrayList<String>();
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) {
                header.add(this.wktField);
                continue;
            }
            header.add(descriptor.getLocalName());
        }
        try (CsvWriter writer = new CsvWriter((Writer)new FileWriter(this.csvFileState.getFile()), ',');){
            writer.writeRecord(header.toArray(new String[header.size()]));
        }
    }

    @Override
    public String[] encode(SimpleFeature feature) {
        ArrayList<String> csvRecord = new ArrayList<String>();
        for (Property property : feature.getProperties()) {
            String name = property.getName().getLocalPart();
            Object value = property.getValue();
            if (value == null) {
                csvRecord.add("");
                continue;
            }
            if (name.compareTo(this.wktField) == 0) {
                WKTWriter wkt = new WKTWriter();
                String txt = wkt.write((Geometry)value);
                csvRecord.add(txt);
                continue;
            }
            String txt = (String)Converters.convert((Object)value, String.class);
            csvRecord.add(txt);
        }
        return csvRecord.toArray(new String[csvRecord.size() - 1]);
    }

    @Override
    public SimpleFeature decode(String recordId, String[] csvRecord) {
        SimpleFeatureType featureType = this.getFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        String[] headers = this.csvFileState.getCSVHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (i < csvRecord.length) {
                String value = csvRecord[i].trim();
                if (geometryDescriptor != null && header.equals(this.wktField)) {
                    Geometry geometry;
                    WKTReader wktReader = new WKTReader();
                    try {
                        geometry = wktReader.read(value);
                    }
                    catch (ParseException e) {
                        geometry = null;
                    }
                    builder.set(this.wktField, (Object)geometry);
                    continue;
                }
                builder.set(header, (Object)value);
                continue;
            }
            builder.set(header, null);
        }
        return builder.buildFeature(this.csvFileState.getTypeName() + "-" + recordId);
    }
}

