/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv3.parse;

import com.csvreader.CsvWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.tutorial.csv3.CSVFileState;
import org.geotools.tutorial.csv3.parse.CSVStrategy;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class CSVAttributesOnlyStrategy
extends CSVStrategy {
    public CSVAttributesOnlyStrategy(CSVFileState csvFileState) {
        super(csvFileState);
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        SimpleFeatureTypeBuilder builder = CSVAttributesOnlyStrategy.createBuilder(this.csvFileState);
        return builder.buildFeatureType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        ArrayList<String> header = new ArrayList<String>();
        this.featureType = featureType;
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            header.add(descriptor.getLocalName());
        }
        try (CsvWriter writer = new CsvWriter((Writer)new FileWriter(this.csvFileState.getFile()), ',');){
            writer.writeRecord(header.toArray(new String[header.size()]));
        }
    }

    @Override
    public String[] encode(SimpleFeature feature) {
        ArrayList<String> csvRecord = new ArrayList<String>();
        for (Property property : feature.getProperties()) {
            Object value = property.getValue();
            if (value == null) {
                csvRecord.add("");
                continue;
            }
            if (Geometry.class.isAssignableFrom(value.getClass())) continue;
            String txt = value.toString();
            csvRecord.add(txt);
        }
        return csvRecord.toArray(new String[csvRecord.size() - 1]);
    }

    @Override
    public SimpleFeature decode(String recordId, String[] csvRecord) {
        SimpleFeatureType featureType = this.getFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        String[] headers = this.csvFileState.getCSVHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (i < csvRecord.length) {
                String value = csvRecord[i].trim();
                builder.set(header, (Object)value);
                continue;
            }
            builder.set(header, null);
        }
        return builder.buildFeature(this.csvFileState.getTypeName() + "-" + recordId);
    }
}

