/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv3;

import com.csvreader.CsvReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CSVFileState {
    private final File file;
    private final String typeName;
    private final CoordinateReferenceSystem crs;
    private final URI namespace;
    private final String dataInput;
    private volatile String[] headers = null;

    private static CoordinateReferenceSystem DEFAULT_CRS() throws FactoryException {
        return CRS.decode((String)"EPSG:4326");
    }

    public CSVFileState(File file) {
        this(file, null, null, null);
    }

    public CSVFileState(File file, URI namespace) {
        this(file, namespace, null, null);
    }

    public CSVFileState(File file, URI namespace, String typeName, CoordinateReferenceSystem crs) {
        this.file = file;
        this.typeName = typeName;
        this.crs = crs;
        this.namespace = namespace;
        this.dataInput = null;
    }

    public CSVFileState(String dataInput) {
        this(dataInput, null);
    }

    public CSVFileState(String dataInput, String typeName) {
        this.dataInput = dataInput;
        this.typeName = typeName;
        this.crs = null;
        this.namespace = null;
        this.file = null;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public File getFile() {
        return this.file;
    }

    public String getTypeName() {
        return this.typeName != null ? this.typeName : FilenameUtils.getBaseName((String)this.file.getPath());
    }

    public CoordinateReferenceSystem getCrs() {
        if (this.crs != null) {
            return this.crs;
        }
        try {
            return CSVFileState.DEFAULT_CRS();
        }
        catch (FactoryException e) {
            return null;
        }
    }

    public CsvReader openCSVReader() throws IOException {
        Reader reader = this.file != null ? new BufferedReader(new FileReader(this.file)) : new StringReader(this.dataInput);
        CsvReader csvReader = new CsvReader(reader);
        if (!csvReader.readHeaders()) {
            reader.close();
            throw new IOException("Error reading csv headers");
        }
        return csvReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCSVHeaders() {
        if (this.headers == null) {
            CSVFileState cSVFileState = this;
            synchronized (cSVFileState) {
                if (this.headers == null) {
                    this.headers = this.readCSVHeaders();
                }
            }
        }
        return this.headers;
    }

    private String[] readCSVHeaders() {
        try (CsvReader csvReader = null;){
            csvReader = this.openCSVReader();
            String[] stringArray = csvReader.getHeaders();
            return stringArray;
        }
    }
}

