/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv2;

import com.csvreader.CsvReader;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tutorial.csv2.CSVDataStore;
import org.geotools.tutorial.csv2.CSVFeatureReader;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CSVFeatureSource
extends ContentFeatureSource {
    public CSVFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public CSVDataStore getDataStore() {
        return (CSVDataStore)super.getDataStore();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new CSVFeatureReader(this.getState(), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCountInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            try (CsvReader reader = this.getDataStore().read();){
                boolean connect = reader.readHeaders();
                if (!connect) {
                    throw new IOException("Unable to connect");
                }
                int count = 0;
                while (reader.readRecord()) {
                    ++count;
                }
                int n = count;
                return n;
            }
        }
        return -1;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.entry.getName());
        try (CsvReader reader = this.getDataStore().read();){
            SimpleFeatureType SCHEMA;
            boolean success = reader.readHeaders();
            if (!success) {
                throw new IOException("Header of CSV file not available");
            }
            builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            builder.add("Location", Point.class);
            for (String column : reader.getHeaders()) {
                if ("lat".equalsIgnoreCase(column) || "lon".equalsIgnoreCase(column)) continue;
                builder.add(column, String.class);
            }
            SimpleFeatureType simpleFeatureType = SCHEMA = builder.buildFeatureType();
            return simpleFeatureType;
        }
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

