/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv2;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.tutorial.csv2.CSVDataStore;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class CSVFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    protected ContentState state;
    private int row;
    protected CsvReader reader;
    protected SimpleFeatureBuilder builder;
    private GeometryFactory geometryFactory;
    private SimpleFeature next;

    public CSVFeatureReader(ContentState contentState, Query query) throws IOException {
        this.state = contentState;
        CSVDataStore csv = (CSVDataStore)contentState.getEntry().getDataStore();
        this.reader = csv.read();
        boolean header = this.reader.readHeaders();
        if (!header) {
            throw new IOException("Unable to read csv header");
        }
        this.builder = new SimpleFeatureBuilder(this.state.getFeatureType());
        this.geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        this.row = 0;
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature feature;
        if (this.next != null) {
            feature = this.next;
            this.next = null;
        } else {
            feature = this.readFeature();
        }
        return feature;
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        if (this.reader == null) {
            return false;
        }
        this.next = this.readFeature();
        return this.next != null;
    }

    SimpleFeature readFeature() throws IOException {
        if (this.reader == null) {
            throw new IOException("FeatureReader is closed; no additional features can be read");
        }
        boolean read = this.reader.readRecord();
        if (!read) {
            this.close();
            return null;
        }
        Coordinate coordinate = new Coordinate();
        for (String column : this.reader.getHeaders()) {
            String value = this.reader.get(column);
            if ("lat".equalsIgnoreCase(column)) {
                coordinate.y = Double.valueOf(value.trim());
                continue;
            }
            if ("lon".equalsIgnoreCase(column)) {
                coordinate.x = Double.valueOf(value.trim());
                continue;
            }
            this.builder.set(column, (Object)value);
        }
        this.builder.set("Location", (Object)this.geometryFactory.createPoint(coordinate));
        return this.buildFeature();
    }

    protected SimpleFeature buildFeature() {
        ++this.row;
        return this.builder.buildFeature(this.state.getEntry().getTypeName() + "." + this.row);
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.builder = null;
        this.geometryFactory = null;
        this.next = null;
    }
}

