/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv2;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tutorial.csv2.CSVFeatureSource;
import org.geotools.tutorial.csv2.CSVFeatureStore;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;

public class CSVDataStore
extends ContentDataStore {
    File file;

    public CSVDataStore(File file) {
        this.file = file;
    }

    CsvReader read() throws IOException {
        FileReader reader = new FileReader(this.file);
        CsvReader csvReader = new CsvReader((Reader)reader);
        return csvReader;
    }

    protected List<Name> createTypeNames() throws IOException {
        String name = this.file.getName();
        name = name.substring(0, name.lastIndexOf(46));
        NameImpl typeName = new NameImpl(name);
        return Collections.singletonList(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        ArrayList<String> header = new ArrayList<String>();
        GeometryDescriptor geometryDescrptor = featureType.getGeometryDescriptor();
        if (geometryDescrptor == null || !CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)geometryDescrptor.getCoordinateReferenceSystem()) || !geometryDescrptor.getType().getBinding().isAssignableFrom(Point.class)) {
            throw new IOException("Unable use LAT/LON to represent " + geometryDescrptor);
        }
        header.add("LAT");
        header.add("LON");
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            header.add(descriptor.getLocalName());
        }
        try (CsvWriter writer = new CsvWriter((Writer)new FileWriter(this.file), ',');){
            writer.writeRecord(header.toArray(new String[header.size()]));
        }
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        if (this.file.canWrite()) {
            return new CSVFeatureStore(entry, Query.ALL);
        }
        return new CSVFeatureSource(entry, Query.ALL);
    }
}

