/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CSVTest {
    @Test
    public void test() throws Exception {
        ArrayList<String> cities = new ArrayList<String>();
        URL url = CSVTest.class.getResource("locations.csv");
        File file = new File(url.toURI());
        try (FileReader reader = new FileReader(file);){
            CsvReader locations = new CsvReader((Reader)reader);
            locations.readHeaders();
            while (locations.readRecord()) {
                cities.add(locations.get("CITY"));
            }
        }
        Assert.assertTrue((boolean)cities.contains("Victoria"));
    }

    @Test
    public void example1() throws Exception {
        System.out.println("example1 start\n");
        URL url = CSVTest.class.getResource("locations.csv");
        File file = new File(url.toURI());
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", file);
        DataStore store = DataStoreFinder.getDataStore(params);
        String[] names = store.getTypeNames();
        System.out.println("typenames: " + names.length);
        System.out.println("typename[0]: " + names[0]);
        System.out.println("\nexample1 end\n");
    }

    @Test
    public void example2() throws Exception {
        System.out.println("example2 start\n");
        URL url = CSVTest.class.getResource("locations.csv");
        File file = new File(url.toURI());
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", file);
        DataStore store = DataStoreFinder.getDataStore(params);
        SimpleFeatureType type = store.getSchema("locations");
        System.out.println("featureType  name: " + type.getName());
        System.out.println("featureType count: " + type.getAttributeCount());
        System.out.println("featuretype attributes list:");
        for (AttributeDescriptor descriptor : type.getAttributeDescriptors()) {
            System.out.print("  " + descriptor.getName());
            System.out.print(" (" + descriptor.getMinOccurs() + "," + descriptor.getMaxOccurs() + ",");
            System.out.print((descriptor.isNillable() ? "nillable" : "manditory") + ")");
            System.out.print(" type: " + descriptor.getType().getName());
            System.out.println(" binding: " + descriptor.getType().getBinding().getSimpleName());
        }
        AttributeDescriptor attributeDescriptor = type.getDescriptor(0);
        System.out.println("attribute 0    name: " + attributeDescriptor.getName());
        System.out.println("attribute 0    type: " + attributeDescriptor.getType().toString());
        System.out.println("attribute 0 binding: " + attributeDescriptor.getType().getBinding());
        AttributeDescriptor cityDescriptor = type.getDescriptor("CITY");
        System.out.println("attribute 'CITY'    name: " + cityDescriptor.getName());
        System.out.println("attribute 'CITT'    type: " + cityDescriptor.getType().toString());
        System.out.println("attribute 'CITY' binding: " + cityDescriptor.getType().getBinding());
        GeometryDescriptor geometryDescriptor = type.getGeometryDescriptor();
        System.out.println("default geom    name: " + geometryDescriptor.getName());
        System.out.println("default geom    type: " + geometryDescriptor.getType().toString());
        System.out.println("default geom binding: " + geometryDescriptor.getType().getBinding());
        System.out.println("default geom     crs: " + CRS.toSRS((CoordinateReferenceSystem)geometryDescriptor.getCoordinateReferenceSystem()));
        System.out.println("\nexample2 end\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void example3() throws Exception {
        System.out.println("example3 start\n");
        URL url = CSVTest.class.getResource("locations.csv");
        File file = new File(url.toURI());
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", file);
        DataStore datastore = DataStoreFinder.getDataStore(params);
        Query query = new Query("locations");
        System.out.println("open feature reader");
        try (FeatureReader reader = datastore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            int count = 0;
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                System.out.println("  " + feature.getID() + " " + feature.getAttribute("CITY"));
                ++count;
            }
            System.out.println("close feature reader");
            System.out.println("read in " + count + " features");
        }
        System.out.println("\nexample3 end\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void example4() throws Exception {
        System.out.println("example4 start\n");
        URL url = CSVTest.class.getResource("locations.csv");
        File file = new File(url.toURI());
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", file);
        DataStore store = DataStoreFinder.getDataStore(params);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        HashSet<FeatureId> selection = new HashSet<FeatureId>();
        selection.add(ff.featureId("locations.7"));
        Id filter = ff.id(selection);
        Query query = new Query("locations", (Filter)filter);
        try (FeatureReader reader = store.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                System.out.println("feature " + feature.getID());
                for (Property property : feature.getProperties()) {
                    System.out.print("\t");
                    System.out.print(property.getName());
                    System.out.print(" = ");
                    System.out.println(property.getValue());
                }
            }
        }
        System.out.println("\nexample4 end\n");
    }

    @Test
    public void example5() throws Exception {
        System.out.println("example5 start\n");
        URL url = CSVTest.class.getResource("locations.csv");
        File file = new File(url.toURI());
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", file);
        DataStore store = DataStoreFinder.getDataStore(params);
        SimpleFeatureSource featureSource = store.getFeatureSource("locations");
        Filter filter = CQL.toFilter((String)"CITY = 'Denver'");
        SimpleFeatureCollection features = featureSource.getFeatures(filter);
        System.out.println("found :" + features.size() + " feature");
        SimpleFeatureIterator iterator = features.features();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                System.out.println(feature.getID() + " default geometry " + geometry);
            }
        }
        catch (Throwable t) {
            iterator.close();
        }
        System.out.println("\nexample5 end\n");
    }

    @Test
    public void example6() throws Exception {
        System.out.println("example6 start\n");
        URL url = CSVTest.class.getResource("locations.csv");
        File file = new File(url.toURI());
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", file);
        DataStore store = DataStoreFinder.getDataStore(params);
        SimpleFeatureSource featureSource = store.getFeatureSource("locations");
        SimpleFeatureCollection featureCollection = featureSource.getFeatures();
        ArrayList<String> list = new ArrayList<String>();
        try (SimpleFeatureIterator features = featureCollection.features();){
            while (features.hasNext()) {
                list.add(((SimpleFeature)features.next()).getID());
            }
        }
        System.out.println("           List Contents: " + list);
        System.out.println("    FeatureSource  count: " + featureSource.getCount(Query.ALL));
        System.out.println("    FeatureSource bounds: " + featureSource.getBounds(Query.ALL));
        System.out.println("FeatureCollection   size: " + featureCollection.size());
        System.out.println("FeatureCollection bounds: " + featureCollection.getBounds());
        DefaultFeatureCollection collection = DataUtilities.collection((FeatureCollection)featureCollection);
        System.out.println("         collection size: " + collection.size());
        System.out.println("\nexample6 end\n");
    }
}

