/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.csv;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.tutorial.csv.CSVFeatureSource;
import org.opengis.feature.type.Name;

public class CSVDataStore
extends ContentDataStore {
    File file;

    public CSVDataStore(File file) {
        this.file = file;
    }

    CsvReader read() throws IOException {
        FileReader reader = new FileReader(this.file);
        CsvReader csvReader = new CsvReader((Reader)reader);
        return csvReader;
    }

    protected List<Name> createTypeNames() throws IOException {
        String name = this.file.getName();
        name = name.substring(0, name.lastIndexOf(46));
        NameImpl typeName = new NameImpl(name);
        return Collections.singletonList(typeName);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        return new CSVFeatureSource(entry, Query.ALL);
    }
}

