/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tutorial.crs;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.map.FeatureLayer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.JProgressWindow;
import org.geotools.swing.action.SafeAction;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

public class CRSLab {
    private File sourceFile;
    private SimpleFeatureSource featureSource;
    private MapContent map;

    public static void main(String[] args) throws Exception {
        CRSLab lab = new CRSLab();
        lab.displayShapefile();
    }

    private void displayShapefile() throws Exception {
        this.sourceFile = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (this.sourceFile == null) {
            return;
        }
        FileDataStore store = FileDataStoreFinder.getDataStore((File)this.sourceFile);
        this.featureSource = store.getFeatureSource();
        this.map = new MapContent();
        Style style = SLD.createSimpleStyle((FeatureType)this.featureSource.getSchema());
        FeatureLayer layer = new FeatureLayer((FeatureSource)this.featureSource, style);
        this.map.layers().add(layer);
        JMapFrame mapFrame = new JMapFrame(this.map);
        mapFrame.enableToolBar(true);
        mapFrame.enableStatusBar(true);
        JToolBar toolbar = mapFrame.getToolBar();
        toolbar.addSeparator();
        toolbar.add(new JButton((Action)((Object)new ValidateGeometryAction())));
        toolbar.add(new JButton((Action)((Object)new ExportShapefileAction())));
        mapFrame.setSize(800, 600);
        mapFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToShapefile() throws Exception {
        SimpleFeatureType schema = (SimpleFeatureType)this.featureSource.getSchema();
        JFileDataStoreChooser chooser = new JFileDataStoreChooser("shp");
        chooser.setDialogTitle("Save reprojected shapefile");
        chooser.setSaveFile(this.sourceFile);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file.equals(this.sourceFile)) {
            JOptionPane.showMessageDialog(null, "Cannot replace " + file);
            return;
        }
        CoordinateReferenceSystem dataCRS = schema.getCoordinateReferenceSystem();
        CoordinateReferenceSystem worldCRS = this.map.getCoordinateReferenceSystem();
        boolean lenient = true;
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)dataCRS, (CoordinateReferenceSystem)worldCRS, (boolean)lenient);
        SimpleFeatureCollection featureCollection = this.featureSource.getFeatures();
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> create = new HashMap<String, Serializable>();
        create.put("url", file.toURI().toURL());
        create.put("create spatial index", Boolean.TRUE);
        DataStore dataStore = factory.createNewDataStore(create);
        SimpleFeatureType featureType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)schema, (CoordinateReferenceSystem)worldCRS);
        dataStore.createSchema((FeatureType)featureType);
        String createdName = dataStore.getTypeNames()[0];
        try (DefaultTransaction transaction = new DefaultTransaction("Reproject");
             FeatureWriter writer = dataStore.getFeatureWriterAppend(createdName, (Transaction)transaction);
             SimpleFeatureIterator iterator = featureCollection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                SimpleFeature copy = (SimpleFeature)writer.next();
                copy.setAttributes(feature.getAttributes());
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                Geometry geometry2 = JTS.transform((Geometry)geometry, (MathTransform)transform);
                copy.setDefaultGeometry((Object)geometry2);
                writer.write();
            }
            transaction.commit();
            JOptionPane.showMessageDialog(null, "Export to shapefile complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToShapefile2() throws Exception {
        FeatureType schema = this.featureSource.getSchema();
        String typeName = schema.getName().getLocalPart();
        JFileDataStoreChooser chooser = new JFileDataStoreChooser("shp");
        chooser.setDialogTitle("Save reprojected shapefile");
        chooser.setSaveFile(this.sourceFile);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file.equals(this.sourceFile)) {
            JOptionPane.showMessageDialog(null, "Cannot replace " + file, "File warning", 2);
            return;
        }
        Query query = new Query(typeName);
        query.setCoordinateSystemReproject(this.map.getCoordinateReferenceSystem());
        SimpleFeatureCollection featureCollection = this.featureSource.getFeatures(query);
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> create = new HashMap<String, Serializable>();
        create.put("url", file.toURI().toURL());
        create.put("create spatial index", Boolean.TRUE);
        DataStore newDataStore = factory.createNewDataStore(create);
        newDataStore.createSchema((FeatureType)((SimpleFeatureType)featureCollection.getSchema()));
        DefaultTransaction transaction = new DefaultTransaction("Reproject");
        SimpleFeatureStore featureStore = (SimpleFeatureStore)newDataStore.getFeatureSource(typeName);
        featureStore.setTransaction((Transaction)transaction);
        try {
            featureStore.addFeatures((FeatureCollection)featureCollection);
            transaction.commit();
            JOptionPane.showMessageDialog(null, "Export to shapefile complete", "Export", 1);
        }
        catch (Exception problem) {
            transaction.rollback();
            problem.printStackTrace();
            JOptionPane.showMessageDialog(null, "Export to shapefile failed", "Export", 0);
        }
        finally {
            transaction.close();
        }
    }

    private int validateFeatureGeometry(ProgressListener progress) throws Exception {
        SimpleFeatureCollection featureCollection = this.featureSource.getFeatures();
        class ValidationVisitor
        implements FeatureVisitor {
            public int numInvalidGeometries = 0;

            ValidationVisitor() {
            }

            public void visit(Feature f) {
                SimpleFeature feature = (SimpleFeature)f;
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom != null && !geom.isValid()) {
                    ++this.numInvalidGeometries;
                    System.out.println("Invalid Geoemtry: " + feature.getID());
                }
            }
        }
        ValidationVisitor visitor = new ValidationVisitor();
        featureCollection.accepts((FeatureVisitor)visitor, progress);
        return visitor.numInvalidGeometries;
    }

    class ValidateGeometryAction2
    extends SafeAction {
        ValidateGeometryAction2() {
            super("Validate geometry");
            this.putValue("ShortDescription", "Check each geometry");
        }

        public void action(ActionEvent e) throws Throwable {
            SwingWorker<String, Object> worker = new SwingWorker<String, Object>(){

                @Override
                protected String doInBackground() throws Exception {
                    JProgressWindow progress = new JProgressWindow(null);
                    progress.setTitle("Validating feature geometry");
                    int numInvalid = CRSLab.this.validateFeatureGeometry((ProgressListener)progress);
                    if (numInvalid == 0) {
                        return "All feature geometries are valid";
                    }
                    return "Invalid geometries: " + numInvalid;
                }

                @Override
                protected void done() {
                    try {
                        Object result = this.get();
                        JOptionPane.showMessageDialog(null, result, "Geometry results", 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            worker.execute();
        }
    }

    class ValidateGeometryAction
    extends SafeAction {
        ValidateGeometryAction() {
            super("Validate geometry");
            this.putValue("ShortDescription", "Check each geometry");
        }

        public void action(ActionEvent e) throws Throwable {
            int numInvalid = CRSLab.this.validateFeatureGeometry(null);
            String msg = numInvalid == 0 ? "All feature geometries are valid" : "Invalid geometries: " + numInvalid;
            JOptionPane.showMessageDialog(null, msg, "Geometry results", 1);
        }
    }

    class ExportShapefileAction
    extends SafeAction {
        ExportShapefileAction() {
            super("Export...");
            this.putValue("ShortDescription", "Export using current crs");
        }

        public void action(ActionEvent e) throws Throwable {
            CRSLab.this.exportToShapefile();
        }
    }
}

