/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.render;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.sld.SLDConfiguration;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.AnchorPoint;
import org.opengis.style.Displacement;
import org.opengis.style.Fill;

public class StyleExamples {
    private void styleFactoryExample() throws Exception {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        sld.setName("sld");
        sld.setTitle("Example");
        sld.setAbstract("Example Style Layer Descriptor");
        UserLayer layer = sf.createUserLayer();
        layer.setName("layer");
        FeatureTypeConstraint constraint = sf.createFeatureTypeConstraint("Feature", (Filter)Filter.INCLUDE, null);
        layer.layerFeatureConstraints().add(constraint);
        Style style = sf.createStyle();
        style.setName("style");
        style.getDescription().setTitle("User Style");
        style.getDescription().setAbstract("Definition of Style");
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        Rule rule1 = sf.createRule();
        rule1.setName("rule1");
        rule1.getDescription().setTitle("City");
        rule1.getDescription().setAbstract("Rule for drawing cities");
        rule1.setFilter((Filter)ff.less((Expression)ff.property("POPULATION"), (Expression)ff.literal(50000)));
        Stroke stroke = sf.stroke((Expression)ff.literal((Object)"#000000"), null, null, null, null, null, null);
        org.geotools.styling.Fill fill = sf.fill(null, (Expression)ff.literal((Object)Color.BLUE), (Expression)ff.literal(1.0));
        OnLineResourceImpl svg = new OnLineResourceImpl(new URI("file:city.svg"));
        svg.freeze();
        OnLineResourceImpl png = new OnLineResourceImpl(new URI("file:city.png"));
        png.freeze();
        ArrayList<Object> symbols = new ArrayList<Object>();
        symbols.add(sf.externalGraphic((OnLineResource)svg, "svg", null));
        symbols.add(sf.externalGraphic((OnLineResource)png, "png", null));
        symbols.add(sf.mark((Expression)ff.literal((Object)"circle"), (Fill)fill, (org.opengis.style.Stroke)stroke));
        Expression opacity = null;
        Literal size = ff.literal(10);
        Expression rotation = null;
        AnchorPoint anchor = null;
        Displacement displacement = null;
        Graphic city = sf.graphic(symbols, opacity, (Expression)size, rotation, anchor, displacement);
        PointSymbolizer pointSymbolizer = sf.pointSymbolizer("point", (Expression)ff.property("the_geom"), null, null, (org.opengis.style.Graphic)city);
        rule1.symbolizers().add(pointSymbolizer);
        featureTypeStyle.rules().add(rule1);
        ArrayList<Mark> dotSymbols = new ArrayList<Mark>();
        dotSymbols.add(sf.mark((Expression)ff.literal((Object)"circle"), null, null));
        Graphic dotGraphic = sf.graphic(dotSymbols, null, (Expression)ff.literal(3), null, null, null);
        PointSymbolizer dotSymbolizer = sf.pointSymbolizer("dot", null, null, null, (org.opengis.style.Graphic)dotGraphic);
        ArrayList<PointSymbolizer> symbolizers = new ArrayList<PointSymbolizer>();
        symbolizers.add(dotSymbolizer);
        Filter other = null;
        Rule rule2 = sf.rule("default", null, null, Double.MIN_VALUE, Double.MAX_VALUE, symbolizers, other);
        featureTypeStyle.rules().add(rule2);
        style.featureTypeStyles().add(featureTypeStyle);
        layer.userStyles().add(style);
        sld.layers().add(layer);
    }

    private void styleBuilderExample() throws Exception {
        StyleBuilder builder = new StyleBuilder();
        FilterFactory2 ff = builder.getFilterFactory();
        Graphic city = builder.createGraphic();
        city.setSize((Expression)ff.literal(10));
        city.graphicalSymbols().add(builder.createExternalGraphic("file:city.svg", "svg"));
        city.graphicalSymbols().add(builder.createExternalGraphic("file:city.png", "png"));
        city.graphicalSymbols().add(builder.createMark("circle", Color.BLUE, Color.BLACK, 1.0));
        PointSymbolizer pointSymbolizer = builder.createPointSymbolizer(city, "the_geom");
        Rule rule1 = builder.createRule((Symbolizer)pointSymbolizer);
        rule1.setName("rule1");
        rule1.getDescription().setTitle("City");
        rule1.getDescription().setAbstract("Rule for drawing cities");
        rule1.setFilter((Filter)ff.less((Expression)ff.property("POPULATION"), (Expression)ff.literal(50000)));
        Graphic dotGraphic = builder.createGraphic(null, builder.createMark("circle"), null);
        PointSymbolizer dotSymbolize = builder.createPointSymbolizer(dotGraphic);
        Rule rule2 = builder.createRule((Symbolizer)dotSymbolize);
        rule2.setElseFilter(true);
        Rule[] rules = new Rule[]{rule1, rule2};
        FeatureTypeStyle featureTypeStyle = builder.createFeatureTypeStyle("Feature", rules);
        Style style = builder.createStyle();
        style.setName("style");
        style.getDescription().setTitle("User Style");
        style.getDescription().setAbstract("Definition of Style");
        style.featureTypeStyles().add(featureTypeStyle);
    }

    private void splatExample() {
        StyleBuilder builder = new StyleBuilder();
        FilterFactory2 ff = builder.getFilterFactory();
        Graphic splat = builder.createGraphic(null, builder.createMark("splat"), null);
        PointSymbolizer symbolizer = builder.createPointSymbolizer(splat);
        Style style = builder.createStyle((Symbolizer)symbolizer);
    }

    private void sldExample() {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        sld.setName("example");
        sld.setAbstract("Example Style Layer Descriptor");
        UserLayer layer = styleFactory.createUserLayer();
        layer.setName("layer");
        FeatureTypeConstraint constraint = styleFactory.createFeatureTypeConstraint("Feature", (Filter)Filter.INCLUDE, null);
        layer.layerFeatureConstraints().add(constraint);
        Style style = styleFactory.createStyle();
        style.getDescription().setTitle("Style");
        style.getDescription().setAbstract("Definition of Style");
        layer.userStyles().add(style);
        sld.layers().add(layer);
    }

    private void featureTypeStyleExample() {
        StyleBuilder styleBuilder = new StyleBuilder();
        Style style = styleBuilder.createStyle();
        PointSymbolizer pointSymbolizer = styleBuilder.createPointSymbolizer();
        Graphic graphic = styleBuilder.createGraphic();
        ExternalGraphic external = styleBuilder.createExternalGraphic("file:///C:/images/house.gif", "image/gif");
        graphic.graphicalSymbols().add(external);
        graphic.graphicalSymbols().add(styleBuilder.createMark("circle"));
        pointSymbolizer.setGraphic((org.opengis.style.Graphic)graphic);
        Rule rule = styleBuilder.createRule((Symbolizer)pointSymbolizer);
        FeatureTypeStyle featureTypeStyle = styleBuilder.createFeatureTypeStyle("Feature", rule);
        style.featureTypeStyles().add(featureTypeStyle);
    }

    private void twoFeatureTypeStyles() {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();
        Style style = styleFactory.getDefaultStyle();
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type-1"));
        style.featureTypeStyles().add(fts);
        FeatureTypeStyle fts2 = styleFactory.createFeatureTypeStyle();
        fts2.featureTypeNames().add(new NameImpl("feature-type-2"));
        Rule rule1 = styleFactory.createRule();
        rule1.setName("rule1");
        Id aFilter = filterFactory.id(Collections.singleton(filterFactory.featureId("FID")));
        rule1.setFilter((Filter)aFilter);
        fts2.rules().add(rule1);
        Rule rule2 = styleFactory.createRule();
        rule2.setElseFilter(true);
        rule2.setName("rule2");
        fts2.rules().add(rule2);
        style.featureTypeStyles().add(fts2);
    }

    private void quickPointSymbolizer() {
        StyleBuilder sb = new StyleBuilder();
        FilterFactory2 ff = sb.getFilterFactory();
        Mark testMark = sb.createMark(sb.attributeExpression("name"), sb.createFill(Color.RED, 0.5), null);
        Graphic graph = sb.createGraphic(null, new Mark[]{testMark}, null, (Expression)ff.literal(1), (Expression)ff.property("size"), (Expression)ff.property("rotation"));
        PointSymbolizer aPointSymbolizer = sb.createPointSymbolizer(graph);
        Style style = sb.createStyle((Symbolizer)aPointSymbolizer);
    }

    private void quickTextSymbolizer() {
        StyleBuilder sb = new StyleBuilder();
        FilterFactory2 ff = sb.getFilterFactory();
        org.geotools.styling.AnchorPoint anchorPoint = sb.createAnchorPoint(sb.attributeExpression("X"), sb.attributeExpression("Y"));
        PointPlacement pointPlacement = sb.createPointPlacement(anchorPoint, null, sb.literalExpression(0));
        TextSymbolizer textSymbolizer = sb.createTextSymbolizer(sb.createFill(Color.BLACK), new Font[]{sb.createFont("Lucida Sans", 10.0), sb.createFont("Arial", 10.0)}, sb.createHalo(), sb.attributeExpression("name"), (LabelPlacement)pointPlacement, null);
        Mark circle = sb.createMark("circle", Color.RED);
        Graphic graph2 = sb.createGraphic(null, circle, null, 1.0, 4.0, 0.0);
        PointSymbolizer pointSymbolizer = sb.createPointSymbolizer(graph2);
        Style style = sb.createStyle();
        FeatureTypeStyle featureTypeStyle = sb.createFeatureTypeStyle("labelPoint", new Symbolizer[]{textSymbolizer, pointSymbolizer});
        style.featureTypeStyles().add(featureTypeStyle);
    }

    private void quickPolygonSymbolizer() {
        StyleBuilder styleBuilder = new StyleBuilder();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PolygonSymbolizer polygonSymbolizer = styleBuilder.createPolygonSymbolizer(Color.BLUE);
        polygonSymbolizer.getFill().setOpacity((Expression)ff.literal(0.5));
        polygonSymbolizer.setStroke((org.opengis.style.Stroke)styleBuilder.createStroke(Color.BLACK, 2.0));
        Style style = styleBuilder.createStyle((Symbolizer)polygonSymbolizer);
    }

    private void parseSLD() throws Exception {
        SLDConfiguration configuration = new SLDConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        FileInputStream xml = new FileInputStream("markTest.sld");
        StyledLayerDescriptor sld = (StyledLayerDescriptor)parser.parse((InputStream)xml);
    }

    private void markTestSLD() {
        StyleBuilder sb = new StyleBuilder();
        FilterFactory2 ff = sb.getFilterFactory();
        Style style = sb.createStyle();
        style.setName("MyStyle");
        Mark testMark = sb.createMark(sb.attributeExpression("name"), sb.createFill(Color.RED, 0.5), null);
        Graphic graph = sb.createGraphic(null, new Mark[]{testMark}, null, sb.literalExpression(1), sb.attributeExpression("size"), sb.attributeExpression("rotation"));
        style.featureTypeStyles().add(sb.createFeatureTypeStyle("testPoint", (Symbolizer)sb.createPointSymbolizer(graph)));
        org.geotools.styling.AnchorPoint anchorPoint = sb.createAnchorPoint(sb.attributeExpression("X"), sb.attributeExpression("Y"));
        PointPlacement pointPlacement = sb.createPointPlacement(anchorPoint, null, sb.literalExpression(0));
        TextSymbolizer textSymbolizer = sb.createTextSymbolizer(sb.createFill(Color.BLACK), new Font[]{sb.createFont("Lucida Sans", 10.0), sb.createFont("Arial", 10.0)}, sb.createHalo(), sb.attributeExpression("name"), (LabelPlacement)pointPlacement, null);
        Mark circle = sb.createMark("circle", Color.RED);
        Graphic graph2 = sb.createGraphic(null, circle, null, 1.0, 4.0, 0.0);
        PointSymbolizer pointSymbolizer = sb.createPointSymbolizer(graph2);
        style.featureTypeStyles().add(sb.createFeatureTypeStyle("labelPoint", new Symbolizer[]{textSymbolizer, pointSymbolizer}));
    }

    private void backgroundExample() {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        Style style = sf.createStyle();
        style.setName("style");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        org.geotools.styling.Fill background = sf.fill(null, (Expression)ff.literal((Object)Color.RED), (Expression)ff.literal(1.0));
        style.setBackground(background);
    }
}

