/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.geometry.jts.JTS;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.GenericName;
import si.uom.NonSI;
import si.uom.SI;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class ReferencingExamples {
    private ProjectedCRS utm10NCRS;
    private GeographicCRS nad27CRS;

    ReferencingExamples() {
        try {
            this.premadeObjects();
            this.creatCRSFromWKT();
            this.createFromEPSGCode();
            this.createFromEPSGCode2();
            this.createCRSByHand1();
            this.createCRSByHand2();
            this.createCRSByHand3();
            this.toWKT();
            this.toWKTFormat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void factories() {
        Hints hints = null;
        ReferencingFactoryContainer group = new ReferencingFactoryContainer(hints);
        CRSFactory crsFactory = group.getCRSFactory();
        CSFactory csFactory = group.getCSFactory();
        DatumFactory datumFactory = group.getDatumFactory();
    }

    void referencingFactoryContainer() {
        Object datumFactory = null;
        Object csFactory = null;
        Object crsFactory = null;
        Object mtFactory = null;
        HashMap<Hints.ClassKey, Object> map = new HashMap<Hints.ClassKey, Object>();
        map.put(Hints.DATUM_FACTORY, datumFactory);
        map.put(Hints.CS_FACTORY, csFactory);
        map.put(Hints.CRS_FACTORY, crsFactory);
        map.put(Hints.MATH_TRANSFORM_FACTORY, mtFactory);
        Hints hints = new Hints(map);
        ReferencingFactoryContainer container = new ReferencingFactoryContainer(hints);
    }

    void referencingFactoryContainer2() {
        ReferencingFactoryContainer container;
        Hints hints = GeoTools.getDefaultHints();
        DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory((Hints)hints);
        if (datumFactory == (container = new ReferencingFactoryContainer(hints)).getDatumFactory()) {
            System.out.println("Will be the same DatumFactory");
        }
    }

    void premadeObjects() {
        DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
        DefaultGeodeticDatum wgs84Datum = DefaultGeodeticDatum.WGS84;
        DefaultPrimeMeridian greenwichMeridian = DefaultPrimeMeridian.GREENWICH;
        DefaultCartesianCS cartCS = DefaultCartesianCS.GENERIC_2D;
        DefaultCoordinateSystemAxis latAxis = DefaultCoordinateSystemAxis.GEODETIC_LATITUDE;
    }

    void creatCRSFromWKT() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS from a WKT string:");
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        String wkt = "PROJCS[\"UTM_Zone_10N\", GEOGCS[\"WGS84\", DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\",0.017453292519943295], AXIS[\"Longitude\",EAST], AXIS[\"Latitude\",NORTH]], PROJECTION[\"Transverse_Mercator\"], PARAMETER[\"semi_major\", 6378137.0], PARAMETER[\"semi_minor\", 6356752.314245179], PARAMETER[\"central_meridian\", -123.0], PARAMETER[\"latitude_of_origin\", 0.0], PARAMETER[\"scale_factor\", 0.9996], PARAMETER[\"false_easting\", 500000.0], PARAMETER[\"false_northing\", 0.0], UNIT[\"metre\",1.0], AXIS[\"x\",EAST], AXIS[\"y\",NORTH]]";
        CoordinateReferenceSystem crs = crsFactory.createFromWKT(wkt);
        System.out.println("  CRS: " + crs.toWKT());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)crs);
        System.out.println("Identified Datum object:");
        this.printIdentifierStuff((IdentifiedObject)((ProjectedCRS)crs).getDatum());
        System.out.println("------------------------------------------");
    }

    void createFromEPSGCode2() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS from an authority factory:");
        String code = "26910";
        CRSAuthorityFactory crsAuthorityFactory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", null);
        CoordinateReferenceSystem crs = crsAuthorityFactory.createCoordinateReferenceSystem(code);
        System.out.println("  CRS: " + crs.toWKT());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)crs);
        System.out.println("------------------------------------------");
    }

    void createFromEPSGCode() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS from an authority factory:");
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:26910", (boolean)false);
        System.out.println("  CRS: " + crs.toWKT());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)crs);
        System.out.println("------------------------------------------");
    }

    void createCRSByHand1() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS by hand:");
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
        DefaultCartesianCS cartCS = DefaultCartesianCS.GENERIC_2D;
        ParameterValueGroup parameters = mtFactory.getDefaultParameters("Transverse_Mercator");
        parameters.parameter("central_meridian").setValue(-111.0);
        parameters.parameter("latitude_of_origin").setValue(0.0);
        parameters.parameter("scale_factor").setValue(0.9996);
        parameters.parameter("false_easting").setValue(500000.0);
        parameters.parameter("false_northing").setValue(0.0);
        DefiningConversion conversion = new DefiningConversion("Transverse_Mercator", parameters);
        Map<String, String> properties = Collections.singletonMap("name", "WGS 84 / UTM Zone 12N");
        ProjectedCRS projCRS = crsFactory.createProjectedCRS(properties, (GeographicCRS)geoCRS, (Conversion)conversion, (CartesianCS)cartCS);
        System.out.println("  Projected CRS: " + projCRS.toWKT());
        System.out.println("------------------------------------------");
        this.utm10NCRS = projCRS;
    }

    void createCRSByHand2() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS by hand:");
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(null);
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory(null);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Clarke 1866");
        Ellipsoid clark1866ellipse = datumFactory.createFlattenedSphere(map, 6378206.4, 294.978698213901, SI.METRE);
        DefaultPrimeMeridian greenwichMeridian = DefaultPrimeMeridian.GREENWICH;
        BursaWolfParameters toWGS84 = new BursaWolfParameters((GeodeticDatum)DefaultGeodeticDatum.WGS84);
        toWGS84.dx = -3.0;
        toWGS84.dy = 142.0;
        toWGS84.dz = 183.0;
        map.clear();
        map.put("name", "North American Datum 1927");
        map.put("bursaWolf", (String)toWGS84);
        GeodeticDatum clark1866datum = datumFactory.createGeodeticDatum(map, clark1866ellipse, (PrimeMeridian)greenwichMeridian);
        System.out.println(clark1866datum.toWKT());
        System.out.println("Identified Datum object:");
        this.printIdentifierStuff((IdentifiedObject)clark1866datum);
        map.clear();
        map.put("name", "<lat>, <long>");
        DefaultCoordinateSystemAxis latAxis = DefaultCoordinateSystemAxis.GEODETIC_LATITUDE;
        DefaultCoordinateSystemAxis longAxis = DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE;
        EllipsoidalCS ellipsCS = csFactory.createEllipsoidalCS(map, (CoordinateSystemAxis)latAxis, (CoordinateSystemAxis)longAxis);
        map.clear();
        map.put("name", "NAD 27");
        map.put("authority", "9999");
        GeographicCRS nad27CRS = crsFactory.createGeographicCRS(map, clark1866datum, ellipsCS);
        System.out.println(nad27CRS.toWKT());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)nad27CRS);
        System.out.println("------------------------------------------");
        this.nad27CRS = nad27CRS;
    }

    void createCRSByHand3() throws FactoryException {
        System.out.println("------------------------------------------");
        System.out.println("Creating two CRSs by hand:");
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(null);
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory(null);
        HashMap<String, String> map = new HashMap<String, String>();
        map.clear();
        map.put("name", "Greenwich Meridian");
        PrimeMeridian greenwichMeridian = datumFactory.createPrimeMeridian(map, 0.0, NonSI.DEGREE_ANGLE);
        map.clear();
        map.put("name", "WGS 84 Ellipsoid Datum");
        Ellipsoid wgs84Ellipsoid = datumFactory.createFlattenedSphere(map, 6378137.0, 298.257223563, SI.METRE);
        map.clear();
        map.put("name", "WGS84 Height Datum");
        GeodeticDatum wgs84Datum = datumFactory.createGeodeticDatum(map, wgs84Ellipsoid, greenwichMeridian);
        map.clear();
        map.put("name", "Cartesian X axis");
        CoordinateSystemAxis xAxis = csFactory.createCoordinateSystemAxis(map, "X", AxisDirection.GEOCENTRIC_X, SI.METRE);
        map.clear();
        map.put("name", "Cartesian Y axis");
        CoordinateSystemAxis yAxis = csFactory.createCoordinateSystemAxis(map, "Y", AxisDirection.GEOCENTRIC_Y, SI.METRE);
        map.clear();
        map.put("name", "Cartesian Z axis");
        CoordinateSystemAxis zAxis = csFactory.createCoordinateSystemAxis(map, "Z", AxisDirection.GEOCENTRIC_Z, SI.METRE);
        map.clear();
        map.put("name", "Rendered Cartesian CS");
        CartesianCS worldCS = csFactory.createCartesianCS(map, xAxis, yAxis, zAxis);
        map.clear();
        map.put("name", "Output Cartesian CS");
        GeocentricCRS geocentricCRS = crsFactory.createGeocentricCRS(map, wgs84Datum, worldCS);
        System.out.println("Geocentric CRS: " + geocentricCRS.toWKT());
        map.clear();
        map.put("name", "Geodetic North axis");
        CoordinateSystemAxis northAxis = csFactory.createCoordinateSystemAxis(map, "N", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        map.clear();
        map.put("name", "Geodetic East axis");
        CoordinateSystemAxis eastAxis = csFactory.createCoordinateSystemAxis(map, "E", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        map.clear();
        map.put("name", "Geodetic Height axis");
        CoordinateSystemAxis heightAxis = csFactory.createCoordinateSystemAxis(map, "Up", AxisDirection.UP, SI.METRE);
        map.clear();
        map.put("name", "<long>,<lat> Airy 1830 geodetic");
        EllipsoidalCS airyCS = csFactory.createEllipsoidalCS(map, eastAxis, northAxis, heightAxis);
        GeographicCRS airyCRS = crsFactory.createGeographicCRS(map, wgs84Datum, airyCS);
        System.out.println("Geographic CRS: " + airyCRS.toString());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)airyCRS);
        System.out.println("Identified Datum object:");
        this.printIdentifierStuff((IdentifiedObject)airyCRS.getDatum());
        System.out.println("------------------------------------------");
    }

    void printIdentifierStuff(IdentifiedObject identObj) {
        System.out.println("  getName().getCode() - " + identObj.getName().getCode());
        System.out.println("  getName().getAuthority() - " + identObj.getName().getAuthority());
        System.out.println("  getRemarks() - " + identObj.getRemarks());
        System.out.println("  getAliases():");
        Iterator aliases = identObj.getAlias().iterator();
        if (!aliases.hasNext()) {
            System.out.println("    no aliases");
        } else {
            int i = 0;
            while (aliases.hasNext()) {
                System.out.println("    alias(" + i + "): " + (GenericName)aliases.next());
                ++i;
            }
        }
        System.out.println("  getIdentifiers():");
        Iterator idents = identObj.getIdentifiers().iterator();
        if (!idents.hasNext()) {
            System.out.println("    no extra identifiers");
        } else {
            int i = 0;
            while (idents.hasNext()) {
                Identifier ident = (Identifier)idents.next();
                System.out.println("    identifier(" + i + ").getCode() - " + ident.getCode());
                System.out.println("    identifier(" + i + ").getAuthority() - " + ident.getAuthority());
                ++i;
            }
        }
    }

    public void distance() throws Exception {
        Coordinate start = null;
        Coordinate end = null;
        CoordinateReferenceSystem crs = null;
        GeodeticCalculator gc = new GeodeticCalculator(crs);
        gc.setStartingPosition((Position)JTS.toDirectPosition(start, crs));
        gc.setDestinationPosition((Position)JTS.toDirectPosition(end, crs));
        double distance = gc.getOrthodromicDistance();
        int totalmeters = (int)distance;
        int km = totalmeters / 1000;
        int meters = totalmeters - km * 1000;
        float remaining_cm = (float)(distance - (double)totalmeters) * 10000.0f;
        remaining_cm = Math.round(remaining_cm);
        float cm = remaining_cm / 100.0f;
        System.out.println("Distance = " + km + "km " + meters + "m " + cm + "cm");
        double angle = gc.getAzimuth();
        System.out.println("Angle = " + angle);
    }

    public void movePoint() {
        GeodeticCalculator calc = new GeodeticCalculator();
        calc.setStartingGeographicPoint(45.4644, 9.1908);
        calc.setDirection(90.0, 200.0);
        Point2D dest = calc.getDestinationGeographicPoint();
        System.out.println("Longitude: " + dest.getX() + " Latitude: " + dest.getY());
    }

    public void toWKT() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:32735");
        String wkt = crs.toWKT();
        System.out.println("wkt for EPSG:32735");
        System.out.println(wkt);
    }

    public void toWKTFormat() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:32735");
        Formattable f = (Formattable)CRS.decode((String)"EPSG:32735", (boolean)true);
        String wkt = f.toWKT(Citations.ESRI, 2);
        System.out.println("wkt for EPSG:32735 (ESRI)");
        System.out.println(wkt);
    }

    public static void main(String[] args) {
        new ReferencingExamples();
    }
}

