/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.opengis;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Version;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;

public class FilterExamples {
    public void includeExclude() {
        IncludeFilter filter = Filter.INCLUDE;
        filter = Filter.EXCLUDE;
    }

    public void ffExample() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        ff.equal((Expression)ff.property("land_use"), (Expression)ff.literal((Object)"URBAN"));
        PropertyIsNull filter = ff.isNull((Expression)ff.property("approved"));
        filter = ff.less((Expression)ff.property("depth"), (Expression)ff.literal(300));
        filter = ff.lessOrEqual((Expression)ff.property("risk"), (Expression)ff.literal(3.7));
        filter = ff.greater((Expression)ff.property("name"), (Expression)ff.literal((Object)"Smith"));
        filter = ff.greaterOrEqual((Expression)ff.property("schedule"), (Expression)ff.literal((Object)new Date()));
        filter = ff.between((Expression)ff.property("age"), (Expression)ff.literal(20), (Expression)ff.literal((Object)"29"));
        filter = ff.between((Expression)ff.property("group"), (Expression)ff.literal((Object)"A"), (Expression)ff.literal((Object)"D"));
        filter = ff.notEqual((Expression)ff.property("type"), (Expression)ff.literal((Object)"draft"));
        filter = ff.like((Expression)ff.property("code"), "2300%");
        filter = ff.like((Expression)ff.property("code"), "2300?", "*", "?", "\\");
    }

    public void nilExample() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PropertyIsNull filter = ff.isNull((Expression)ff.property("approved"));
        filter = ff.isNil((Expression)ff.property("approved"), (Object)"no approval available");
    }

    public void id() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Id filter = ff.id(new FeatureId[]{ff.featureId("CITY.98734597823459687235"), ff.featureId("CITY.98734592345235823474")});
    }

    public void rid() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Id filter = ff.id(new FeatureId[]{ff.featureId("CITY.98734597823459687235", "A457")});
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", "A457", new Version())});
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", "A457", new Version(Version.Action.PREVIOUS))});
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", "A457", new Version(Version.Action.NEXT))});
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", "A457", new Version(Version.Action.FIRST))});
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", "A457", new Version(Integer.valueOf(1)))});
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", "A457", new Version(Integer.valueOf(12)))});
        DateFormat df = DateFormat.getDateInstance(3);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", "A457", new Version(df.parse("1985-1-1")))});
        filter = ff.id(new FeatureId[]{ff.resourceId("CITY.98734597823459687235", df.parse("1990-1-1"), df.parse("2000-1-1"))});
    }

    public void idSet() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        HashSet<FeatureId> selected = new HashSet<FeatureId>();
        selected.add(ff.featureId("CITY.98734597823459687235"));
        selected.add(ff.featureId("CITY.98734592345235823474"));
        Id filter = ff.id(selected);
    }

    public void logical() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Not filter = ff.not((Filter)ff.like((Expression)ff.property("code"), "230%"));
        filter = ff.and((Filter)ff.greater((Expression)ff.property("rainfall"), (Expression)ff.literal(70)), (Filter)ff.equal((Expression)ff.property("land_use"), (Expression)ff.literal((Object)"urban"), false));
        filter = ff.or((Filter)ff.equal((Expression)ff.property("code"), (Expression)ff.literal((Object)"approved")), (Filter)ff.greater((Expression)ff.property("funding"), (Expression)ff.literal(23000)));
    }

    void temporal() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date1 = FORMAT.parse("2001-07-05T12:08:56.235-0700");
        DefaultInstant temporalInstant = new DefaultInstant((Position)new DefaultPosition(date1));
        After after = ff.after((Expression)ff.property("date"), (Expression)ff.literal((Object)temporalInstant));
        Date date2 = FORMAT.parse("2001-07-04T12:08:56.235-0700");
        DefaultInstant temporalInstant2 = new DefaultInstant((Position)new DefaultPosition(date2));
        DefaultPeriod period = new DefaultPeriod((Instant)temporalInstant, (Instant)temporalInstant2);
        TOverlaps within = ff.toverlaps((Expression)ff.property("constructed_date"), (Expression)ff.literal((Object)period));
    }

    void caseSensitive() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Equals filter = ff.equal((Expression)ff.property("state"), (Expression)ff.literal((Object)"queensland"));
        filter = ff.equal((Expression)ff.property("state"), (Expression)ff.literal((Object)"new south wales"), false);
        PropertyIsGreaterThan welcome = ff.greater((Expression)ff.property("zone"), (Expression)ff.literal((Object)"danger"), false);
    }

    public void matchAction() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PropertyIsGreaterThan filter = ff.greater((Expression)ff.property("child/age"), (Expression)ff.literal(12), true, MultiValuedFilter.MatchAction.ALL);
    }

    public void matchActionAny() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        List<Integer> ages = Arrays.asList(7, 8, 10, 15);
        PropertyIsGreaterThan filter = ff.greater((Expression)ff.literal(ages), (Expression)ff.literal(12), false, MultiValuedFilter.MatchAction.ANY);
        System.out.println("Any: " + filter.evaluate(null));
    }

    public void matchActionAll() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        List<Integer> ages = Arrays.asList(7, 8, 10, 15);
        PropertyIsGreaterThan filter = ff.greater((Expression)ff.literal(ages), (Expression)ff.literal(12), false, MultiValuedFilter.MatchAction.ALL);
        System.out.println("All: " + filter.evaluate(null));
    }

    public void matchActionOne() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        List<Integer> ages = Arrays.asList(7, 8, 10, 15);
        PropertyIsGreaterThan filter = ff.greater((Expression)ff.literal(ages), (Expression)ff.literal(12), false, MultiValuedFilter.MatchAction.ONE);
        System.out.println("One: " + filter.evaluate(null));
    }

    public void bbox() {
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        ReferencedEnvelope bbox = new ReferencedEnvelope(x1, x2, y1, y2, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BBOX filter = ff.bbox((Expression)ff.property("the_geom"), (BoundingBox)bbox);
    }
}

