/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.opengis;

import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureExamples {
    public void javaFlag() {
        GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory();
        class Flag {
            public Point location;
            public String name;
            public int classification;
            public double height;

            Flag() {
            }
        }
        Flag here = new Flag();
        here.location = geomFactory.createPoint(new Coordinate(23.3, -37.2));
        here.name = "Here";
        here.classification = 3;
        here.height = 2.0;
    }

    public void featureFlag() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("Flag");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("location", Point.class);
        b.add("name", String.class);
        b.add("classification", Integer.class);
        b.add("height", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder f = new SimpleFeatureBuilder(type);
        f.add((Object)geomFactory.createPoint(new Coordinate(23.3, -37.2)));
        f.add((Object)"here");
        f.add((Object)3);
        f.add((Object)2.0);
        SimpleFeature feature = f.buildFeature("fid.1");
    }
}

