/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.main;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.factory.GeoTools;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class JoinExample {
    public static void main(String[] args) throws Exception {
        System.out.println("Welcome to GeoTools:" + GeoTools.getVersion());
        File file = args.length == 0 ? JFileDataStoreChooser.showOpenFile((String)"shp", null) : new File(args[0]);
        File file2 = args.length <= 1 ? JFileDataStoreChooser.showOpenFile((String)"shp", null) : new File(args[1]);
        if (file == null || !file.exists() || file2 == null || !file2.exists()) {
            System.exit(1);
        }
        HashMap<String, URL> connect = new HashMap<String, URL>();
        connect.put("url", file.toURI().toURL());
        DataStore shapefile = DataStoreFinder.getDataStore(connect);
        String typeName = shapefile.getTypeNames()[0];
        SimpleFeatureSource shapes = shapefile.getFeatureSource(typeName);
        HashMap connect2 = new HashMap();
        connect.put("url", file2.toURI().toURL());
        DataStore shapefile2 = DataStoreFinder.getDataStore(connect);
        String typeName2 = shapefile2.getTypeNames()[0];
        SimpleFeatureSource shapes2 = shapefile2.getFeatureSource(typeName2);
        JoinExample.joinExample(shapes, shapes2);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void joinExample(SimpleFeatureSource shapes, SimpleFeatureSource shapes2) throws Exception {
        int max;
        String typeName2;
        String typeName;
        block7: {
            SimpleFeatureType schema = (SimpleFeatureType)shapes.getSchema();
            typeName = schema.getTypeName();
            String geomName = schema.getGeometryDescriptor().getLocalName();
            SimpleFeatureType schema2 = (SimpleFeatureType)shapes2.getSchema();
            typeName2 = schema2.getTypeName();
            String geomName2 = schema2.getGeometryDescriptor().getLocalName();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
            Query outerGeometry = new Query(typeName, (Filter)Filter.INCLUDE, new String[]{geomName});
            SimpleFeatureCollection outerFeatures = shapes.getFeatures(outerGeometry);
            SimpleFeatureIterator iterator = outerFeatures.features();
            max = 0;
            block5: while (true) {
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    try {
                        Geometry geometry = (Geometry)feature.getDefaultGeometry();
                        if (!geometry.isValid()) continue;
                        Intersects innerFilter = ff.intersects((Expression)ff.property(geomName2), (Expression)ff.literal((Object)geometry));
                        Query innerQuery = new Query(typeName2, (Filter)innerFilter, Query.NO_NAMES);
                        SimpleFeatureCollection join = shapes2.getFeatures(innerQuery);
                        int size = join.size();
                        max = Math.max(max, size);
                        continue block5;
                    }
                    catch (Exception exception) {
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                iterator.close();
            }
        }
        System.out.println("At most " + max + " " + typeName2 + " features in a single " + typeName + " feature");
    }
}

