/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.main;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.measure.Unit;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.filter.FunctionFactory;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.util.SuppressFBWarnings;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.Parameter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class FilterExamples {
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    SimpleFeatureSource featureSource;
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    private JMapFrame mapFrame;
    static final String codeBlock = "``";

    SimpleFeatureCollection grabSelectedIds(Set<String> selection) throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        for (String id : selection) {
            FeatureId fid = ff.featureId(id);
            fids.add(fid);
        }
        Id filter = ff.id(fids);
        return this.featureSource.getFeatures((Filter)filter);
    }

    SimpleFeatureCollection grabSelectedName(String name) throws Exception {
        return this.featureSource.getFeatures(CQL.toFilter((String)("Name = '" + name + "'")));
    }

    SimpleFeatureCollection grabSelectedNameIgnoreCase(String name) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property("Name"), (Expression)ff.literal((Object)name), false);
        return this.featureSource.getFeatures((Filter)filter);
    }

    SimpleFeatureCollection grabSelectedNames(Set<String> selectedNames) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        ArrayList<PropertyIsEqualTo> match = new ArrayList<PropertyIsEqualTo>();
        for (String name : selectedNames) {
            PropertyIsEqualTo aMatch = ff.equals((Expression)ff.property("Name"), (Expression)ff.literal((Object)name));
            match.add(aMatch);
        }
        Or filter = ff.or(match);
        return this.featureSource.getFeatures((Filter)filter);
    }

    SimpleFeatureCollection grabFeaturesInBoundingBox(double x1, double y1, double x2, double y2) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        FeatureType schema = this.featureSource.getSchema();
        String geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
        CoordinateReferenceSystem targetCRS = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        ReferencedEnvelope bbox = new ReferencedEnvelope(x1, y1, x2, y2, targetCRS);
        BBOX filter = ff.bbox((Expression)ff.property(geometryPropertyName), (BoundingBox)bbox);
        return this.featureSource.getFeatures((Filter)filter);
    }

    SimpleFeatureCollection grabFeaturesInPolygon(double x1, double y1, double x2, double y2) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        FeatureType schema = this.featureSource.getSchema();
        DefaultGeographicCRS worldCRS = DefaultGeographicCRS.WGS84;
        String geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
        CoordinateReferenceSystem targetCRS = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        ReferencedEnvelope click = new ReferencedEnvelope(x1, y1, x2, y2, (CoordinateReferenceSystem)worldCRS);
        ReferencedEnvelope bbox = click.transform(targetCRS, true);
        Polygon clickPolygon = JTS.toGeometry((BoundingBox)bbox, null, (int)10);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)worldCRS, (CoordinateReferenceSystem)targetCRS);
        Polygon polygon = (Polygon)JTS.transform((Geometry)clickPolygon, (MathTransform)transform);
        Intersects filter = ff.intersects((Expression)ff.property(geometryPropertyName), (Expression)ff.literal((Object)polygon));
        return this.featureSource.getFeatures((Filter)filter);
    }

    SimpleFeatureCollection grabFeaturesOnScreen(ReferencedEnvelope screen) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        FeatureType schema = this.featureSource.getSchema();
        String geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
        CoordinateReferenceSystem targetCRS = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        CoordinateReferenceSystem worldCRS = screen.getCoordinateReferenceSystem();
        ReferencedEnvelope bbox = screen.transform(targetCRS, true);
        Polygon clickPolygon = JTS.toGeometry((BoundingBox)bbox, null, (int)10);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)worldCRS, (CoordinateReferenceSystem)targetCRS);
        Polygon polygon = (Polygon)JTS.transform((Geometry)clickPolygon, (MathTransform)transform);
        BBOX filter1 = ff.bbox((Expression)ff.property(geometryPropertyName), (BoundingBox)bbox);
        Intersects filter2 = ff.intersects((Expression)ff.property(geometryPropertyName), (Expression)ff.literal((Object)polygon));
        And filter = ff.and((Filter)filter1, (Filter)filter2);
        return this.featureSource.getFeatures((Filter)filter);
    }

    SimpleFeatureCollection click1(MapMouseEvent ev) throws Exception {
        java.awt.Point screenPos = ev.getPoint();
        Rectangle screenRect = new Rectangle(screenPos.x - 1, screenPos.y - 1, 3, 3);
        CoordinateReferenceSystem worldCRS = this.mapFrame.getMapContent().getCoordinateReferenceSystem();
        AffineTransform screenToWorld = this.mapFrame.getMapPane().getScreenToWorldTransform();
        Rectangle2D worldRect = screenToWorld.createTransformedShape(screenRect).getBounds2D();
        ReferencedEnvelope worldBBox = new ReferencedEnvelope(worldRect, worldCRS);
        SimpleFeatureType schema = (SimpleFeatureType)this.featureSource.getSchema();
        CoordinateReferenceSystem targetCRS = schema.getCoordinateReferenceSystem();
        String geometryAttributeName = schema.getGeometryDescriptor().getLocalName();
        ReferencedEnvelope bbox = worldBBox.transform(targetCRS, true, 10);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        BBOX filter = ff.bbox((Expression)ff.property(geometryAttributeName), (BoundingBox)bbox);
        return this.featureSource.getFeatures((Filter)filter);
    }

    SimpleFeatureCollection distance(MapMouseEvent ev) throws Exception {
        DirectPosition2D worldPosition = ev.getWorldPos();
        SimpleFeatureType schema = (SimpleFeatureType)this.featureSource.getSchema();
        CoordinateReferenceSystem crs = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        Unit uom = crs.getCoordinateSystem().getAxis(0).getUnit();
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)worldPosition.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs, (boolean)true);
        DirectPosition dataPosition = transform.transform((DirectPosition)worldPosition, null);
        Point point = JTS.toGeometry((DirectPosition)dataPosition);
        double distance = 10.0;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        DWithin filter = ff.dwithin((Expression)ff.property("POLYGON"), (Expression)ff.literal((Object)point), distance, uom.toString());
        return this.featureSource.getFeatures((Filter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings
    void polygonInteraction() {
        block7: {
            Object polygonCollection = null;
            SimpleFeatureCollection fcResult = null;
            final DefaultFeatureCollection found = new DefaultFeatureCollection();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
            SimpleFeature feature = null;
            Intersects polyCheck = null;
            And andFil = null;
            BBOX boundsCheck = null;
            Object qryStr = null;
            SimpleFeatureIterator it = polygonCollection.features();
            block5: while (true) {
                while (it.hasNext()) {
                    feature = (SimpleFeature)it.next();
                    BoundingBox bounds = feature.getBounds();
                    boundsCheck = ff.bbox((Expression)ff.property("the_geom"), bounds);
                    Geometry geom = (Geometry)feature.getDefaultGeometry();
                    polyCheck = ff.intersects((Expression)ff.property("the_geom"), (Expression)ff.literal((Object)geom));
                    andFil = ff.and((Filter)boundsCheck, (Filter)polyCheck);
                    try {
                        fcResult = this.featureSource.getFeatures((Filter)andFil);
                        fcResult.accepts(new FeatureVisitor(){

                            public void visit(Feature feature) {
                                found.add((SimpleFeature)feature);
                            }
                        }, null);
                        continue block5;
                    }
                    catch (IOException e1) {
                        System.out.println("Unable to run filter for " + feature.getID() + ":" + e1);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                it.close();
            }
        }
    }

    private void expressionExamples() {
        Object geometry = null;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PropertyName propertyAccess = ff.property("THE_GEOM");
        Literal literal = ff.literal(geometry);
        Add math = ff.add((Expression)ff.literal(1), (Expression)ff.literal(2));
        Function function = ff.function("length", new Expression[]{ff.property("CITY_NAME")});
    }

    private static void functionList() {
        Set functionFactories = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory factory : functionFactories) {
            System.out.println(factory.getClass().getName());
            List functionNames = factory.getFunctionNames();
            ArrayList sorted = new ArrayList(functionNames);
            Collections.sort(sorted, new Comparator<FunctionName>(){

                @Override
                public int compare(FunctionName o1, FunctionName o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (FunctionName functionName : sorted) {
                System.out.print("    ");
                System.out.print(functionName.getName());
                System.out.print("(");
                int i = 0;
                for (Parameter argument : functionName.getArguments()) {
                    if (i++ > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(argument.getName());
                    if (argument.getType() == Object.class && argument.isRequired().booleanValue()) continue;
                    System.out.print("{");
                    System.out.print(argument.getType().getSimpleName());
                    if (argument.isRequired().booleanValue()) {
                        System.out.print(",required");
                    } else if (argument.getMinOccurs() == 0 && argument.getMaxOccurs() == 1) {
                        System.out.print(",optional");
                    } else {
                        int min = argument.getMinOccurs();
                        int max = argument.getMaxOccurs();
                        System.out.print(",");
                        System.out.print(min);
                        System.out.print(":");
                        System.out.print(max == Integer.MAX_VALUE ? "unbounded" : Integer.valueOf(max));
                    }
                    System.out.print("}");
                }
                Parameter result = functionName.getReturn();
                System.out.print(")");
                System.out.print(":" + result.getName());
                if (result.getType() != Object.class) {
                    System.out.print("{");
                    Class type = result.getType();
                    if (type != null) {
                        System.out.print(type.getSimpleName());
                    } else {
                        System.out.print("null");
                    }
                    System.out.print("}");
                }
                System.out.println();
            }
        }
    }

    private static void functionListPretty() {
        Set functionFactories = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory factory : functionFactories) {
            String factoryName = factory.getClass().getSimpleName();
            System.out.println(codeBlock + factoryName + codeBlock);
            System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^".substring(0, factoryName.length() + 4));
            System.out.println();
            List functionNames = factory.getFunctionNames();
            ArrayList sorted = new ArrayList(functionNames);
            Collections.sort(sorted, new Comparator<FunctionName>(){

                @Override
                public int compare(FunctionName o1, FunctionName o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            System.out.println("Contains " + sorted.size() + " functions.");
            System.out.println();
            for (FunctionName functionName : sorted) {
                Parameter result = functionName.getReturn();
                StringBuilder fn = new StringBuilder();
                fn.append(codeBlock);
                fn.append(functionName.getName());
                fn.append("(");
                int i = 0;
                for (Parameter argument : functionName.getArguments()) {
                    if (i++ > 0) {
                        fn.append(", ");
                    }
                    fn.append(argument.getName());
                }
                fn.append(")");
                fn.append(codeBlock);
                fn.append(": returns ``" + result.getName() + codeBlock);
                System.out.println(fn.toString());
                for (int h = 0; h < fn.length(); ++h) {
                    System.out.print("'");
                }
                System.out.println();
                System.out.println();
                for (Parameter argument : functionName.getArguments()) {
                    System.out.println("* " + FilterExamples.argument(argument));
                    System.out.println();
                }
                System.out.println("* " + FilterExamples.argument(result, true));
                System.out.println();
            }
        }
    }

    public static String argument(Parameter<?> argument) {
        return FilterExamples.argument(argument, false);
    }

    public static String argument(Parameter<?> argument, boolean result) {
        StringBuilder arg = new StringBuilder();
        arg.append(codeBlock);
        arg.append(argument.getName());
        arg.append(codeBlock);
        Class type = argument.getType();
        if (!(type == null || type == Object.class && argument.isRequired().booleanValue())) {
            arg.append(" (``");
            arg.append(type.getSimpleName());
            arg.append("``)");
            int min = argument.getMinOccurs();
            int max = argument.getMaxOccurs();
            if (min > 1 && max > 1) {
                arg.append(": ");
                arg.append(" min=");
                arg.append(min);
                arg.append(" max=");
                arg.append(max == Integer.MAX_VALUE ? "unbounded" : Integer.valueOf(max));
            } else if (!result) {
                if (argument.isRequired().booleanValue()) {
                    arg.append(" required");
                } else if (argument.getMinOccurs() == 0 && argument.getMaxOccurs() == 1) {
                    arg.append(" optional");
                }
            }
        }
        return arg.toString();
    }

    public static void main(String[] args) {
        FilterExamples.functionListPretty();
    }
}

