/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import java.awt.Color;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.DefaultGridFeatureBuilder;
import org.geotools.grid.Envelopes;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Grids;
import org.geotools.grid.IntersectionBuilder;
import org.geotools.grid.Lines;
import org.geotools.grid.PolygonElement;
import org.geotools.grid.hexagon.HexagonOrientation;
import org.geotools.grid.hexagon.Hexagons;
import org.geotools.grid.oblong.Oblongs;
import org.geotools.grid.ortholine.LineOrientation;
import org.geotools.grid.ortholine.OrthoLineDef;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridExamples {
    private void exampleSquareGrid() {
        ReferencedEnvelope gridBounds = new ReferencedEnvelope(110.0, 150.0, -45.0, -5.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        SimpleFeatureSource grid = Grids.createSquareGrid((ReferencedEnvelope)gridBounds, (double)10.0);
    }

    private void exampleDensifiedSquareGrid() {
        ReferencedEnvelope gridBounds = new ReferencedEnvelope(110.0, 160.0, -45.0, -8.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double squareWidth = 20.0;
        double vertexSpacing = squareWidth / 20.0;
        SimpleFeatureSource grid = Grids.createSquareGrid((ReferencedEnvelope)gridBounds, (double)squareWidth, (double)vertexSpacing);
    }

    private void exampleHexagonalGrid() {
        ReferencedEnvelope gridBounds = new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, null);
        double sideLen = 5.0;
        SimpleFeatureSource grid = Grids.createHexagonalGrid((ReferencedEnvelope)gridBounds, (double)sideLen);
    }

    private void exampleCustomFeatureType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("hextype");
        typeBuilder.add("hexagon", Polygon.class, (CoordinateReferenceSystem)null);
        typeBuilder.add("color", Color.class);
        SimpleFeatureType TYPE = typeBuilder.buildFeatureType();
        final ReferencedEnvelope bounds = new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, null);
        GridFeatureBuilder builder = new GridFeatureBuilder(TYPE){

            public void setAttributes(GridElement element, Map<String, Object> attributes) {
                PolygonElement polyEl = (PolygonElement)element;
                int g = (int)(255.0 * polyEl.getCenter().x / bounds.getWidth());
                int b = (int)(255.0 * polyEl.getCenter().y / bounds.getHeight());
                attributes.put("color", new Color(0, g, b));
            }
        };
        double sideLen = 5.0;
        SimpleFeatureSource grid = Grids.createHexagonalGrid((ReferencedEnvelope)bounds, (double)5.0, (double)-1.0, (GridFeatureBuilder)builder);
    }

    private void exampleIntersection() throws Exception {
        URL url = this.getClass().getResource("oz.shp");
        FileDataStore dataStore = FileDataStoreFinder.getDataStore((URL)url);
        SimpleFeatureSource ozMapSource = dataStore.getFeatureSource();
        double sideLen = 1.0;
        ReferencedEnvelope gridBounds = Envelopes.expandToInclude((ReferencedEnvelope)ozMapSource.getBounds(), (double)sideLen);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("grid");
        tb.add("element", Polygon.class, gridBounds.getCoordinateReferenceSystem());
        tb.add("id", Integer.class);
        SimpleFeatureType TYPE = tb.buildFeatureType();
        IntersectionBuilder builder = new IntersectionBuilder(TYPE, ozMapSource);
        SimpleFeatureSource grid = Grids.createHexagonalGrid((ReferencedEnvelope)gridBounds, (double)sideLen, (double)-1.0, (GridFeatureBuilder)builder);
    }

    private void exampleHexagonOrientation() {
        ReferencedEnvelope gridBounds = new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, null);
        double sideLen = 5.0;
        DefaultGridFeatureBuilder builder = new DefaultGridFeatureBuilder();
        SimpleFeatureSource grid = Hexagons.createGrid((ReferencedEnvelope)gridBounds, (double)sideLen, (HexagonOrientation)HexagonOrientation.ANGLED, (GridFeatureBuilder)builder);
    }

    private void exampleOblong() {
        ReferencedEnvelope gridBounds = new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, null);
        double width = 10.0;
        double height = 5.0;
        DefaultGridFeatureBuilder builder = new DefaultGridFeatureBuilder();
        SimpleFeatureSource grid = Oblongs.createGrid((ReferencedEnvelope)gridBounds, (double)width, (double)height, (GridFeatureBuilder)builder);
    }

    private void exampleMajorMinorLines() {
        ReferencedEnvelope gridBounds = new ReferencedEnvelope(110.0, 150.0, -45.0, -5.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        List<OrthoLineDef> lineDefs = Arrays.asList(new OrthoLineDef(LineOrientation.VERTICAL, 2, 10.0), new OrthoLineDef(LineOrientation.VERTICAL, 1, 2.0), new OrthoLineDef(LineOrientation.HORIZONTAL, 2, 10.0), new OrthoLineDef(LineOrientation.HORIZONTAL, 1, 2.0));
        double vertexSpacing = 0.1;
        SimpleFeatureSource grid = Lines.createOrthoLines((ReferencedEnvelope)gridBounds, lineDefs, (double)vertexSpacing);
    }
}

