/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.BatchFeatureEvent;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

@SuppressFBWarnings(value={"UWF_NULL_FIELD"})
public class SimpleFeatureStoreExamples {
    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    DataStore dataStore = null;
    String typeName;

    private void addFeaturesExample() throws Exception {
        SimpleFeatureStore store = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.typeName);
        SimpleFeatureType featureType = (SimpleFeatureType)store.getSchema();
        SimpleFeatureBuilder build = new SimpleFeatureBuilder(featureType);
        GeometryBuilder geom = new GeometryBuilder();
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        list.add(build.buildFeature("fid1", new Object[]{geom.point(1.0, 1.0), "hello"}));
        list.add(build.buildFeature("fid2", new Object[]{geom.point(2.0, 3.0), "martin"}));
        ListFeatureCollection collection = new ListFeatureCollection(featureType, list);
        DefaultTransaction transaction = new DefaultTransaction("Add Example");
        store.setTransaction((Transaction)transaction);
        try {
            store.addFeatures((FeatureCollection)collection);
            transaction.commit();
        }
        catch (Exception eek) {
            transaction.rollback();
        }
    }

    private void addFeatureIdExample(SimpleFeatureCollection collection) throws Exception {
        DefaultTransaction transaction = new DefaultTransaction("Add Example");
        SimpleFeatureStore store = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.typeName);
        store.setTransaction((Transaction)transaction);
        try {
            List added = store.addFeatures((FeatureCollection)collection);
            System.out.println(added);
            transaction.commit();
            System.out.println(added);
            HashSet selection = new HashSet(added);
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            Id id = ff.id(selection);
        }
        catch (Exception problem) {
            transaction.rollback();
            throw problem;
        }
    }

    private void addFeaturesEvents(SimpleFeatureCollection collection) throws Exception {
        DefaultTransaction transaction = new DefaultTransaction("Add Example");
        SimpleFeatureStore store = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.typeName);
        store.setTransaction((Transaction)transaction);
        class CommitListener
        implements FeatureListener {
            CommitListener() {
            }

            public void changed(FeatureEvent featureEvent) {
                if (featureEvent instanceof BatchFeatureEvent) {
                    BatchFeatureEvent batchEvent = (BatchFeatureEvent)featureEvent;
                    System.out.println("area changed:" + batchEvent.getBounds());
                    System.out.println("created fids:" + batchEvent.fids);
                } else {
                    System.out.println("bounds:" + featureEvent.getBounds());
                    System.out.println("change:" + featureEvent.filter);
                }
            }
        }
        CommitListener listener = new CommitListener();
        store.addFeatureListener((FeatureListener)listener);
        try {
            List added = store.addFeatures((FeatureCollection)collection);
            transaction.commit();
        }
        catch (Exception problem) {
            transaction.rollback();
            throw problem;
        }
    }

    private void removeExample() throws Exception {
        DefaultTransaction transaction = new DefaultTransaction("removeExample");
        SimpleFeatureStore store = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.typeName);
        store.setTransaction((Transaction)transaction);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id filter = ff.id(Collections.singleton(ff.featureId("fred")));
        try {
            store.removeFeatures((Filter)filter);
            transaction.commit();
        }
        catch (Exception eek) {
            transaction.rollback();
        }
    }

    private void removeExample2() throws Exception {
        DefaultTransaction transaction = new DefaultTransaction("removeExample");
        SimpleFeatureStore store = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.typeName);
        store.setTransaction((Transaction)transaction);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id filter = ff.id(Collections.singleton(ff.featureId("fred")));
        try {
            final HashSet removed = new HashSet();
            SimpleFeatureCollection collection = store.getFeatures(new Query(this.typeName, (Filter)filter, Query.NO_NAMES));
            collection.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    removed.add(feature.getIdentifier());
                }
            }, null);
            store.removeFeatures((Filter)filter);
            transaction.commit();
        }
        catch (Exception eek) {
            transaction.rollback();
        }
    }
}

